% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFunctions.R
\name{dataGenerator}
\alias{dataGenerator}
\title{Data Generator}
\usage{
dataGenerator(
  n,
  changepoints,
  parameters,
  type = "mean",
  sigma = 1,
  gamma = 1,
  size = 10
)
}
\arguments{
\item{n}{number of data points to generate}

\item{changepoints}{vector of positions of the changepoints in (0,1] (last element is always 1).}

\item{parameters}{vector of means for the consecutive segments (same length as changepoints)}

\item{type}{a string defining the cost model to use: \code{"mean"}, \code{"variance"}, \code{"poisson"}, \code{"exp"}, \code{"negbin"}}

\item{sigma}{a positive number = the standard deviation of the data}

\item{gamma}{a number between 0 and 1 : the coefficient of the exponential decay (by default = 1 for piecewise constant signals)}

\item{size}{parameter of the \code{rnbinom} function}
}
\value{
a vector of size n generated by the chosen model
}
\description{
Generating data with a given model = changepoint relative positions + parameters + type of cost + (standard deviation + gamma decay)
}
\examples{
dataGenerator(500, c(0.3, 0.6, 1), c(1, 2, 3), type = "mean", sigma = 0.5)

dataGenerator(1000, c(0.2, 0.33,0.5, 1), c(4, 0.2, 3,0.5), type = "variance")

dataGenerator(800, c(0.4, 0.8, 1), c(15, 5, 8), type = "mean", gamma  = 0.95, sigma = 0.4)

dataGenerator(400, c(0.4, 0.9, 1), c(2, 1.5, 3), type = "poisson")

dataGenerator(1000, c(0.44, 0.86, 1), c(0.5, 0.2, 0.4), type = "negbin", size = 3)
}
