% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_hist.R
\name{ggInterval_hist}
\alias{ggInterval_hist}
\title{Histogram for symbolic data with equal-bin or unequal-bin.}
\usage{
ggInterval_hist(data = NULL,mapping = aes(NULL),method="equal-bin",bins=10,
 plotAll = FALSE)
}
\arguments{
\item{data}{A ggESDA object.It can also be either RSDA object or
classical data frame,which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{method}{It can be equal-bin(default) or unequal-bin.Enqual-bin means
the width in histogram is equal, which represent all intervals divided
have the same range. unequal-bin means the range of intervals are not
the same,and it can be more general on data. Thus, the bins of unequal-bin
method depends on the data, and the argument "bins" will be unused.}

\item{bins}{x axis bins,which mean how many partials the variable}

\item{plotAll}{boolean, whether plot all variables, default FALSE.
will be separate into.}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the continuous variable distribution
by dividing the x axis into bins,and calculating the frequency
of observation interval in each bin.
}
\examples{
ggInterval_hist(mtcars,aes(x=wt))

ggInterval_hist(iris,aes(iris$Petal.Length,col="blue",alpha=0.2,
   fill="red"),bins=30)


d<-data.frame(x=rnorm(1000,0,1))
p<-ggInterval_hist(d,aes(x=x),bins=40,method="equal-bin")
p

p+scale_fill_manual(values=rainbow(40))+labs(title="myNorm")

}
