% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx_read_nm_tables.R
\name{pmx_read_nm_tables}
\alias{pmx_read_nm_tables}
\title{NONMEM output table import function}
\usage{
pmx_read_nm_tables(
  file = NULL,
  dir = NULL,
  combined = TRUE,
  rm_duplicates = TRUE,
  quiet = FALSE,
  simtab = NULL,
  ziptab = TRUE,
  user_mode = TRUE,
  ...
)
}
\arguments{
\item{file}{A character vector of path to the files or a \code{nm_table_list} object created with \code{list_nm_tables}.}

\item{dir}{Location of the model files.}

\item{combined}{Logical value indicating whether multiple tables should be combined into a single one. If the number of rows 
does not match an error will be returned.}

\item{rm_duplicates}{Logical value indicating whether duplicated columns should be removed.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{simtab}{If \code{TRUE} only reads in simulation tables, if \code{FALSE} only reads estimation tables. 
Default \code{NULL} reads all tables.}

\item{ziptab}{If \code{TRUE} search for the tables that have been compressed and renamed ??<file>.zip'.}

\item{user_mode}{Adjustment to the original code: usermode is set to "usermode = TRUE" in order to improve this function for purposes of pmx_nm() 
(nonmem_reader.R), In order to use this function seperatly, the use of the original function in the xpose package is advised.}

\item{...}{Additional arguments to be passed to the \code{\link[readr]{read_table2}} or \code{\link[readr]{read_csv}} functions.}
}
\description{
Quickly import NONMEM output tables into R. This function automatically 
detects the optimal settings to import the tables from nonmem. It is based on the read_nm_tables function of xpose.
Slight adjustment were made for purposes of pmx_nm()
}
\section{Table format requirement}{

When using \code{pmx_read_nm_tables} with the \code{combined} argument set to \code{FALSE} an \code{ID} column 
must be present in all data tables. When \code{combined} is set to \code{TRUE} instead an \code{ID} column must be 
present in at least one table for each problem and for each `firstonly` category. \code{ID} columns are required 
to properly combine/merge tables and removing \code{NA} records. If the \code{ID} column is missing from a table and 
\code{combined = FALSE} \code{pmx_read_nm_tables} will return the following warning: \code{Unknown variables: `ID`}. While
the data is returned beware that \code{NA} records might be left in the data and the output should be checked carefully.
If \code{combined = TRUE} \code{pmx_read_nm_tables} is more strict and will return the following warning instead: 
\code{Dropped `<tablenames>` due to missing required `ID` column.}.
}

\examples{
\dontrun{

# Adjustment to the original code: usermode is set to "usermode = TRUE" 
# in order to improve this function for purposes of pmx_nm() (nonmem_reader.R)
# In order to use this function seperatly, the use of the original function in 
# the xpose package is advised.

# Import tables manually and return them as a list of individual tables
nm_tables <- pmx_read_nm_tables(file = c('sdtab001', 'patab001'), 
                            dir = 'models', combined = FALSE)

# Import tables manually and return them as a single merged table
nm_tables <- pmx_read_nm_tables(file = c('sdtab001', 'patab001'), 
                            dir = 'models', combined = TRUE)

}
}
