% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_rfsrc}
\alias{plot.gg_rfsrc}
\title{Predicted response plot from a \code{\link{gg_rfsrc}} object.}
\usage{
\method{plot}{gg_rfsrc}(x, ...)
}
\arguments{
\item{x}{\code{\link{gg_rfsrc}} object created from a \code{randomForestSRC::rfsrc} object}

\item{...}{arguments passed to \code{\link{gg_rfsrc}}.}
}
\value{
\code{ggplot} object
}
\description{
Plot the predicted response from a \code{\link{gg_rfsrc}} object, the
\code{randomForestSRC::rfsrc} prediction, using the OOB prediction from the forest.
}
\examples{
\dontrun{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# iris_rf <- rfsrc(Species ~ ., data = iris)
data(iris_rf, package="ggRandomForests")
gg_dta<- gg_rfsrc(iris_rf)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Regression example
## ------------------------------------------------------------
# airq.obj <- rfsrc(Ozone ~ ., data = airquality, na.action = "na.impute")
data(airq_rf, package="ggRandomForests")
gg_dta<- gg_rfsrc(airq_rf)

plot.gg_rfsrc(gg_dta)

## ------------------------------------------------------------
## Survival example
## ------------------------------------------------------------
## veteran data
## randomized trial of two treatment regimens for lung cancer
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)
data(veteran_rf, package = "ggRandomForests")
gg_dta <- gg_rfsrc(veteran_rf)
plot(gg_dta)

}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for
R, Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, Regression
and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{gg_rfsrc}} \code{randomForestSRC::rfsrc}
}

