% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-mark.R
\name{cross_mark}
\alias{cross_mark}
\title{Add a plot to annotate observations}
\usage{
cross_mark(
  mark,
  data = waiver(),
  ...,
  obs_size = 1,
  inherit_index = NULL,
  inherit_panel = NULL,
  inherit_nobs = NULL,
  size = NULL,
  active = NULL
)
}
\arguments{
\item{mark}{A \code{\link[=mark_draw]{mark_draw()}} object to define how to draw the links. Like
\code{\link[=mark_line]{mark_line()}}, \code{\link[=mark_tetragon]{mark_tetragon()}}. Note the names of the pair links will
be used to define the panel names so must be unique.}

\item{data}{The dataset to use for the layout. By default,
\code{\link[=fortify_matrix]{fortify_matrix()}} will convert the data to a matrix. This argument
allows you to change the layout data. If not specified, the original data
will be used.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{obs_size}{A single numeric value that indicates the size of a single
observation, ranging from \verb{(0, 1]}.}

\item{inherit_index}{A boolean value indicating whether to inherit the
ordering index. If \code{TRUE}, will match the layout ordering index with the
data names.}

\item{inherit_panel}{A boolean value indicating whether to inherit the
panel group. If \code{TRUE}, will match the layout panel with the data names.}

\item{inherit_nobs}{A boolean value indicating whether to inherit the
number of observations (nobs). If \code{TRUE}, the \code{data} input must be
compatible with the layout data.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
Add a plot to annotate observations
}
\section{ggplot2 Specification}{

The \code{cross_mark} function initializes a \code{ggplot} object. The underlying data
contains following columns:
\itemize{
\item \code{.panel}: the panel for the aligned axis. It means \code{x-axis} for vertical
stack layout (including top and bottom annotation), \code{y-axis} for
horizontal stack layout (including left and right annotation).
\item \code{.names} (\code{\link[vctrs:vec_names]{vec_names()}}) and \code{.index}
(\code{\link[vctrs:vec_size]{vec_size()}}/\code{\link[=NROW]{NROW()}}): a character names (only
applicable when names exists) and an integer of index of the original
data.
\item \code{.hand}: A factor with levels \code{c("left", "right")} for horizontal stack
layouts, or \code{c("top", "bottom")} for vertical stack layouts, indicating
the position of the linked observations.
}

You can use \code{\link[=scheme_data]{scheme_data()}} to modify the internal data if needed.
}

