% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-helper.R
\name{element_vec}
\alias{element_vec}
\alias{element_rep}
\alias{element_rep_len}
\alias{element_vec_recycle}
\alias{element_vec_rep}
\alias{element_vec_rep_each}
\alias{element_vec_slice}
\title{Apply a function to the fields of an element object}
\usage{
element_vec(.el, .fn, ...)

element_rep(.el, ...)

element_rep_len(.el, length.out, ...)

element_vec_recycle(.el, size, ...)

element_vec_rep(.el, times, ...)

element_vec_rep_each(.el, times, ...)

element_vec_slice(.el, i, ...)
}
\arguments{
\item{.el}{An \code{\link[ggplot2:element]{element}} object.}

\item{.fn}{The function to be applied to the vectorized fields of the element
object.}

\item{...}{Additional arguments passed on to \code{fn}.}

\item{length.out}{Non-negative integer. The desired length of the output
vector. Other inputs will be coerced to a double vector and the first element
taken. Ignored if \code{NA} or invalid.}

\item{size}{Desired output size.}

\item{times}{For \code{vec_rep()}, a single integer for the number of times to repeat
the entire vector.

For \code{vec_rep_each()}, an integer vector of the number of times to repeat
each element of \code{x}. \code{times} will be \link[vctrs:theory-faq-recycling]{recycled} to
the size of \code{x}.}

\item{i}{An integer, character or logical vector specifying the
locations or names of the observations to get/set. Specify
\code{TRUE} to index all elements (as in \code{x[]}), or \code{NULL}, \code{FALSE} or
\code{integer()} to index none (as in \code{x[NULL]}).}
}
\description{
For an \code{\link[ggplot2:element]{element}} object, some fields are
vectorized, while others are not. This function allows you to apply a
function to the vectorized fields.

The following helper functions are available:
\itemize{
\item \code{element_rep}: Applies \code{\link[=rep]{rep()}}.
\item \code{element_rep_len}: Applies \code{\link[=rep_len]{rep_len()}}.
\item \code{element_vec_recycle}: Applies \code{\link[vctrs:vec_recycle]{vec_recycle()}}.
\item \code{element_vec_rep}: Applies \code{\link[vctrs:vec-rep]{vec_rep()}}.
\item \code{element_vec_rep_each}: Applies \code{\link[vctrs:vec-rep]{vec_rep_each()}}.
\item \code{element_vec_slice}: Applies \code{\link[vctrs:vec_slice]{vec_slice()}}.
}
}
