% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-wrap.R
\name{ggwrap}
\alias{ggwrap}
\title{Wrap Arbitrary Graphics to ggplot}
\usage{
ggwrap(plot, ..., align = "panel", on_top = FALSE, clip = TRUE, vp = NULL)
}
\arguments{
\item{plot}{Any graphic that can be converted into a \code{\link[grid:grid.grob]{grob}}
using \code{\link[=patch]{patch()}}.}

\item{...}{Additional arguments passed to the \code{\link[=patch]{patch()}} method.}

\item{align}{A string specifying the area to place the plot: \code{"full"} for the
full area, \code{"plot"} for the full plotting area (including the axis label), or
\code{"panel"} for only the actual area where data is drawn.}

\item{on_top}{A single boolean value indicates whether the graphic plot
should be put frontmost. Note: the graphic plot will always put above the
background.}

\item{clip}{A single boolean value indicating whether the grob should be
clipped if they expand outside their designated area.}

\item{vp}{A \code{\link[grid:viewport]{viewport}} object, you can use this to define
the plot area.}
}
\value{
A \code{wrapped_plot} object that can be directly placed into
\code{\link[=align_plots]{align_plots()}}.
}
\description{
The \code{ggwrap()} function allows non-ggplot2 elements to be converted into a
compliant representation for use with \code{\link[=align_plots]{align_plots()}}. This is useful for
adding any graphics that can be converted into a \code{\link[grid:grid.grob]{grob}} with
the \code{\link[=patch]{patch()}} method.
}
\examples{
library(grid)
ggwrap(rectGrob(gp = gpar(fill = "goldenrod")), align = "full") +
    inset(rectGrob(gp = gpar(fill = "steelblue")), align = "panel") +
    inset(textGrob("Here are some text", gp = gpar(color = "black")),
        align = "panel"
    )
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp)) +
    ggtitle("Plot 1")
align_plots(p1, ggwrap(
    ~ plot(mtcars$mpg, mtcars$disp),
    mar = c(0, 2, 0, 0), bg = NA
))

}
