% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_pointrange.R
\name{gg_pointrange}
\alias{gg_pointrange}
\title{Pointrange ggplot}
\usage{
gg_pointrange(
  data = NULL,
  x = NULL,
  xmin = NULL,
  xmax = NULL,
  y = NULL,
  ymin = NULL,
  ymax = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  stat = "identity",
  position = "identity",
  coord = ggplot2::coord_cartesian(clip = "off"),
  pal = NULL,
  pal_na = pal_grey,
  alpha = 1,
  ...,
  title = NULL,
  subtitle = NULL,
  x_breaks = NULL,
  x_expand = NULL,
  x_grid = NULL,
  x_include = NULL,
  x_labels = NULL,
  x_limits = NULL,
  x_oob = scales::oob_censor,
  x_sec_axis = ggplot2::waiver(),
  x_title = NULL,
  x_trans = "identity",
  y_breaks = NULL,
  y_expand = NULL,
  y_grid = NULL,
  y_include = NULL,
  y_labels = NULL,
  y_limits = NULL,
  y_oob = scales::oob_censor,
  y_sec_axis = ggplot2::waiver(),
  y_title = NULL,
  y_trans = "identity",
  col_breaks = NULL,
  col_continuous = "gradient",
  col_include = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_legend_rev = FALSE,
  col_limits = NULL,
  col_oob = scales::oob_censor,
  col_rescale = NULL,
  col_title = NULL,
  col_trans = "identity",
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  facet_space = "fixed",
  facet_layout = NULL,
  caption = NULL,
  titles = snakecase::to_sentence_case,
  theme = gg_theme(),
  void = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{x}{Unquoted x aesthetic variable.}

\item{xmin}{Unquoted xmin aesthetic variable.}

\item{xmax}{Unquoted xmax aesthetic variable.}

\item{y}{Unquoted y aesthetic variable.}

\item{ymin}{Unquoted ymin aesthetic variable.}

\item{ymax}{Unquoted ymax aesthetic variable.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{facet2}{Unquoted second facet variable.}

\item{group}{Unquoted group aesthetic variable.}

\item{stat}{Statistical transformation. A character string (e.g. "identity").}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{coord}{A coordinate function from ggplot2 (e.g. ggplot2::coord_cartesian()).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{...}{Other arguments passed to the ggplot2::geom_pointrange function.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{x_breaks}{A function on the limits (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{x_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{x_grid}{TRUE or FALSE for vertical x gridlines. NULL guesses based on the classes of the x and y.}

\item{x_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{x_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{x_limits}{A vector of length 2 to determine the limits of the axis.}

\item{x_oob}{A scales::oob_* function that handles values outside of limits for continuous scales. Defaults to scales::oob_censor.}

\item{x_sec_axis}{A secondary axis using the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{x_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{x_trans}{For a numeric variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{y_breaks}{A function on the limits (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{y_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{y_grid}{TRUE or FALSE of horizontal y gridlines. NULL guesses based on the classes of the x and y.}

\item{y_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{y_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{y_limits}{A vector of length 2 to determine the limits of the axis.}

\item{y_oob}{A scales::oob_* function that handles values outside of limits for continuous scales. Defaults to scales::oob_censor.}

\item{y_sec_axis}{A secondary axis using the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{y_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{y_trans}{For a numeric variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{col_breaks}{A function on the limits (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{col_continuous}{Type of colouring for a continuous variable. Either "gradient" or "steps". Defaults to "steps" - or just the first letter of these e.g. "g".}

\item{col_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{col_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels. Note this does not affect where col_intervals is not NULL.}

\item{col_legend_place}{The place for the legend. Either "bottom", "right", "top" or "left" - or just the first letter of these e.g. "b".}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_legend_rev}{Reverse the elements of the legend. Defaults to FALSE.}

\item{col_limits}{A vector to determine the limits of the colour scale.}

\item{col_oob}{A scales::oob_* function that handles values outside of limits for continuous scales. Defaults to scales::oob_censor.}

\item{col_rescale}{For a continuous col variable, a vector to rescale the pal non-linearly.}

\item{col_title}{Legend title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{col_trans}{For a numeric variable, a transformation object (e.g. "log10", "sqrt" or "reverse").}

\item{facet_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a named vector of labels (e.g. c("value" = "label", ...)).}

\item{facet_ncol}{The number of columns of facets. Only applies to a facet layout of "wrap".}

\item{facet_nrow}{The number of rows of facets. Only applies to a facet layout of "wrap".}

\item{facet_scales}{Whether facet scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{facet_space}{Whether facet space should be "fixed" across facets, "free" to be proportional in both directions, or free to be proportional in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed". Only applies where the facet layout is "grid" and facet scales are not "fixed".}

\item{facet_layout}{Whether the layout is to be "wrap" or "grid". If NULL and a single facet (or facet2) argument is provided, then defaults to "wrap". If NULL and both facet and facet2 arguments are provided, defaults to "grid".}

\item{caption}{Caption title string.}

\item{titles}{A function to format the x, y and col titles. Defaults to snakecase::to_sentence_case.}

\item{theme}{A ggplot2 theme.}

\item{void}{TRUE or FALSE of whether to remove axis lines, ticks and x and y titles and labels.}
}
\value{
A ggplot object.
}
\description{
Create a pointrange ggplot with a wrapper around the ggplot2::geom_pointrange function.
}
\examples{
data.frame(
  trt = factor(c(1, 1, 2, 2)),
  resp = c(1, 5, 3, 4),
  group = factor(c(1, 2, 1, 2)),
  upper = c(1.1, 5.3, 3.3, 4.2),
  lower = c(0.8, 4.6, 2.4, 3.6)
) |>
  gg_pointrange(
    x = trt,
    y = resp,
    col = group,
    ymin = lower,
    ymax = upper,
    position = ggplot2::position_dodge(width = 0.2),
    size = 0.2,
    pal = c("#1B9E77", "#9E361B"),
    x_title = "Treatment",
    y_title = "Response"
  )

}
