% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_mode.R
\name{flex_mode_n}
\alias{flex_mode_n}
\title{Flexible mode with no legend}
\usage{
flex_mode_n(
  base_size = 11,
  base_family = "",
  base_face = "plain",
  base_colour = "#121b24ff",
  plot_title_size = ggplot2::rel(1.1),
  plot_title_family = base_family,
  plot_title_face = "bold",
  plot_title_colour = base_colour,
  plot_subtitle_size = ggplot2::rel(1),
  plot_subtitle_family = base_family,
  plot_subtitle_face = "plain",
  plot_subtitle_colour = base_colour,
  plot_caption_size = ggplot2::rel(0.85),
  plot_caption_family = base_family,
  plot_caption_face = "plain",
  plot_caption_colour = colorspace::lighten(base_colour, 0.1),
  plot_caption_hjust = 0,
  axis_line_colour = "#121b24ff",
  axis_line_linewidth = 0.33,
  axis_ticks_colour = axis_line_colour,
  axis_ticks_linewidth = axis_line_linewidth,
  axis_ticks_length_x = grid::unit(base_size/3, "pt"),
  axis_ticks_length_y = grid::unit(base_size/4, "pt"),
  panel_grid_colour = "#f6f8faff",
  panel_grid_linewidth = 1.33,
  panel_background_fill = "#ffffffff",
  plot_background_fill = "#ffffffff",
  legend_axis_line_colour = plot_background_fill,
  legend_axis_line_linewidth = 0.33,
  legend_background_fill = plot_background_fill,
  legend_key_fill = plot_background_fill,
  legend_ticks_colour = legend_axis_line_colour,
  legend_ticks_linewidth = legend_axis_line_linewidth,
  legend_ticks_length = ggplot2::rel(c(0.175, 0)),
  orientation = NULL,
  ...
)
}
\arguments{
\item{base_size}{The base size of the text theme element. Defaults to 11.}

\item{base_family}{The base family of the text theme element. Defaults to "".}

\item{base_face}{The base face of the text theme element. Defaults to "plain".}

\item{base_colour}{The base colour of the text theme element.}

\item{plot_title_size}{The size of the plot.title theme element.}

\item{plot_title_family}{The family of the plot.title theme element.}

\item{plot_title_face}{The face of the plot.title theme element.}

\item{plot_title_colour}{The colour of the plot.title theme element.}

\item{plot_subtitle_size}{The size of the plot.subtitle theme element.}

\item{plot_subtitle_family}{The family of the plot.subtitle theme element.}

\item{plot_subtitle_face}{The face of the plot.subtitle theme element.}

\item{plot_subtitle_colour}{The colour of the plot.subtitle theme element.}

\item{plot_caption_size}{The size of the plot.caption theme element.}

\item{plot_caption_family}{The family of the plot.caption theme element.}

\item{plot_caption_face}{The face of the plot.caption theme element.}

\item{plot_caption_colour}{The colour of the plot.caption theme element.}

\item{plot_caption_hjust}{The horizontal adjustment of the plot.caption theme element.}

\item{axis_line_colour}{The colour of the axis.line theme element.}

\item{axis_line_linewidth}{The linewidth of the axis.line theme element.}

\item{axis_ticks_colour}{The colour of the axis.ticks theme element.}

\item{axis_ticks_linewidth}{The linewidth of the axis.ticks theme element.}

\item{axis_ticks_length_x}{The length of the axis.ticks.length.x theme element.}

\item{axis_ticks_length_y}{The length of the axis.ticks.length.y theme element.}

\item{panel_grid_colour}{The colour of the panel.grid theme element.}

\item{panel_grid_linewidth}{The linewidth of the panel.grid theme element.}

\item{panel_background_fill}{The fill (and colour) of the panel.background theme element.}

\item{plot_background_fill}{The fill (and colour) of the plot.background theme element.}

\item{legend_axis_line_colour}{The colour of the legend.axis.line theme element.}

\item{legend_axis_line_linewidth}{The linewidth of the legend.axis.line theme element.}

\item{legend_background_fill}{The fill (and colour) of the legend.background theme element.}

\item{legend_key_fill}{The fill (and colour) of the legend.key theme element.}

\item{legend_ticks_colour}{The colour of the legend.ticks theme element.}

\item{legend_ticks_linewidth}{The linewidth of the legend.ticks theme element.}

\item{legend_ticks_length}{The legend.ticks.length theme element.}

\item{orientation}{The orientation of the plot. Either "x" or "y". Defaults to NULL. Not intended for use with the mode argument of gg_* functions.}

\item{...}{Provided to support trailing commas only.}
}
\value{
A ggplot theme.
}
\description{
Flexible mode with no legend.
}
\keyword{internal}
