% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_heatmap.R
\name{make_heatmap}
\alias{make_heatmap}
\title{Make main heatmap part of plot for gghm.}
\usage{
make_heatmap(
  x_long,
  plt = NULL,
  mode = "heatmap",
  include_diag = TRUE,
  invisible_diag = FALSE,
  border_lwd = 0.1,
  border_col = "grey",
  border_lty = 1,
  show_names_diag = TRUE,
  show_names_x = FALSE,
  show_names_y = FALSE,
  names_x_side = "top",
  names_y_side = "left",
  col_scale = NULL,
  size_scale = NULL,
  cell_labels = FALSE,
  cell_label_col = "black",
  cell_label_size = 3,
  cell_label_digits = 2,
  cell_bg_col = "white",
  cell_bg_alpha = 0
)
}
\arguments{
\item{x_long}{Long format data.}

\item{plt}{A ggplot object to build onto. If NULL, makes a new plot.}

\item{mode}{Plotting mode.}

\item{include_diag}{Logical indicating if diagonal should be included.}

\item{invisible_diag}{Logical indicating if an invisible diagonal should be included.}

\item{border_lwd}{Border linewidth.}

\item{border_col}{Border colour.}

\item{border_lty}{Border linetype.}

\item{show_names_diag}{Logical indicating if names should be displayed on the diagonal.}

\item{show_names_x}{Logical indicating if names should be displayed on the x axis.}

\item{show_names_y}{Logical indicating if names should be displayed on the y axis.}

\item{names_x_side}{X axis side.}

\item{names_y_side}{Y axis side.}

\item{col_scale}{Scale for colour/fill aesthetic.}

\item{size_scale}{Scale for size aesthetic.}

\item{cell_labels}{Logical indicating if cell labels should be written or a matrix or data frame (same shape as x_long) with values to write.}

\item{cell_label_col}{Colour of cell labels.}

\item{cell_label_size}{Size of cell labels.}

\item{cell_label_digits}{Number of digits for cell labels if numeric.}

\item{cell_bg_col}{Cell background colour (fill).}

\item{cell_bg_alpha}{Cell background alpha.}
}
\value{
ggplot object with heatmap component.
}
\description{
Make main heatmap part of plot for gghm.
}
\keyword{internal}
