% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-dice-ggproto.R, R/geom-dice.R
\docType{data}
\name{GeomDice}
\alias{GeomDice}
\alias{geom_dice}
\title{A ggplot2 layer for creating dice representations}
\usage{
geom_dice(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ndots = NULL,
  x_length = NULL,
  y_length = NULL,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{aes()}.
Must include:
\itemize{
\item \code{x}, \code{y}: Position of the dice.
\item \code{dots}: The categories present (usually as a string or factor).
}}

\item{data}{A data frame. If \code{NULL}, inherits from the plot.}

\item{stat}{The statistical transformation to use.}

\item{position}{Position adjustment.}

\item{ndots}{Integer (1–6): number of positions shown per dice.}

\item{x_length, }{x_length Numeric: used for aspect ratio.}

\item{y_length, }{y_length Numeric: used for aspect ratio.}

\item{na.rm}{Remove missing values if \code{TRUE}.}

\item{show.legend}{Whether to include in legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics.}

\item{...}{Additional arguments passed to \code{layer()}.}
}
\value{
A \code{ggplot2} layer that draws dice with categorical dot encodings.
}
\description{
\code{geom_dice()} creates a layer that displays dice-like symbols where each dot
represents a specific category. Dots are only shown when that categorical
variable is present in the data, allowing compact visual encoding.
}
\examples{
library(ggplot2)

df <- data.frame(
  x = 1:3,
  y = 1,
  dots = c("A,B", "A,C,E", "F")
)

ggplot(df, aes(x, y, dots = dots)) +
  geom_dice(ndots = 6, x_length = 3, y_length = 1)
}
\keyword{datasets}
