% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_dist_slabinterval.R
\name{stat_dist_slabinterval}
\alias{stat_dist_slabinterval}
\alias{stat_dist_halfeye}
\alias{stat_dist_eye}
\alias{stat_dist_ccdfinterval}
\alias{stat_dist_cdfinterval}
\alias{stat_dist_gradientinterval}
\alias{stat_dist_pointinterval}
\alias{stat_dist_interval}
\alias{stat_dist_slab}
\title{Distribution + interval plots (eye plots, half-eye plots, CCDF barplots, etc) for analytical distributions (ggplot stat)}
\usage{
stat_dist_slabinterval(
  mapping = NULL,
  data = NULL,
  geom = "slabinterval",
  position = "identity",
  ...,
  slab_type = c("pdf", "cdf", "ccdf"),
  p_limits = c(0.001, 0.999),
  orientation = NA,
  limits = NULL,
  n = 501,
  .width = c(0.66, 0.95),
  show_slab = TRUE,
  show_interval = TRUE,
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE
)

stat_dist_halfeye(...)

stat_dist_eye(..., side = "both")

stat_dist_ccdfinterval(
  ...,
  slab_type = "ccdf",
  justification = 0.5,
  side = "topleft",
  normalize = "none"
)

stat_dist_cdfinterval(
  ...,
  slab_type = "cdf",
  justification = 0.5,
  side = "topleft",
  normalize = "none"
)

stat_dist_gradientinterval(
  mapping = NULL,
  data = NULL,
  geom = "slabinterval",
  position = "identity",
  ...,
  justification = 0.5,
  thickness = 1,
  show.legend = c(size = FALSE, slab_alpha = FALSE),
  inherit.aes = TRUE
)

stat_dist_pointinterval(..., show_slab = FALSE)

stat_dist_interval(
  mapping = NULL,
  data = NULL,
  geom = "interval",
  position = "identity",
  ...,
  show_slab = FALSE,
  show_point = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_dist_slab(
  mapping = NULL,
  data = NULL,
  geom = "slab",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{slab_type}{The type of slab function to calculate: probability density (or mass) function (\code{"pdf"}),
cumulative distribution function (\code{"cdf"}), or complementary CDF (\code{"ccdf"}).}

\item{p_limits}{Probability limits (as a vector of size 2) used to determine the lower and upper
limits of the slab. E.g., if this is \code{c(.001, .999)} (the default), then a slab is drawn
for the distribution from the quantile at \code{p = .001} to the quantile at \code{p = .999}.}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{limits}{Manually-specified limits for the slab, as a vector of length two. These limits are combined with those
computed based on \code{p_limits} as well as the limits defined by the scales of the plot to determine the
limits used to draw the slab functions: these limits specify the maximal limits; i.e., if specified, the limits
will not be wider than these (but may be narrower).Use \code{NA} to leave a limit alone; e.g.
\code{limits = c(0, NA)} will ensure that the lower limit does not go below 0, but let the upper limit
be determined by either \code{p_limits} or the scale settings.}

\item{n}{Number of points at which to evaluate \code{slab_function}}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{show_interval}{Should the interval portion of the geom be drawn? Default \code{TRUE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{side}{Which side to draw the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}

\item{justification}{Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to
\code{0.5}.}

\item{normalize}{How to normalize heights of functions input to the \code{thickness} aesthetic. If \code{"all"}
(the default), normalize so that the maximum height across all data is \code{1}; if \code{"panels"}, normalize within
panels so that the maximum height in each panel is \code{1}; if \code{"xy"}, normalize within
the x/y axis opposite the \code{orientation} of this geom so that the maximum height at each value of the
opposite axis is \code{1}; if \code{"groups"}, normalize within values of the opposite axis and within
groups so that the maximum height in each group is \code{1}; if \code{"none"}, values are taken as is with no
normalization (this should probably only be used with functions whose values are in [0,1], such as CDFs).}

\item{thickness}{Override for the \code{thickness} aesthetic in \code{\link[=geom_slabinterval]{geom_slabinterval()}}: the thickness
of the slab at each x / y value of the slab (depending on \code{orientation}).}

\item{show_point}{Should the point portion of the geom be drawn? Default \code{TRUE}.}
}
\value{
A \link[ggplot2:Stat]{ggplot2::Stat} representing a slab or combined slab+interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Stats for computing distribution functions (densities or CDFs) + intervals for use with
\code{\link[=geom_slabinterval]{geom_slabinterval()}}. Uses \code{dist} aesthetic to specify a distribution name
and \code{arg1}, ... \code{arg9} aesthetics (or \code{args} as a list column) to specify distribution
arguments.
}
\details{
A highly configurable stat for generating a variety of plots that combine a "slab"
that describes a distribution plus an interval. Several "shortcut" stats are provided
which combine multiple options to create useful geoms, particularly \emph{eye plots}
(a combination of a violin plot and interval), \emph{half-eye plots} (a density plus interval),
and \emph{CCDF bar plots} (a complementary CDF plus interval).

The shortcut stat names follow the pattern \code{stat_dist_[name]}.

Stats include:

\itemize{
\item \code{stat_dist_eye}: Eye plots (violin + interval)
\item \code{stat_dist_halfeye}: Half-eye plots (density + interval)
\item \code{stat_dist_ccdfinterval}: CCDF bar plots (CCDF + interval)
\item \code{stat_dist_cdfinterval}: CDF bar plots (CDF + interval)
\item \code{stat_dist_gradientinterval}: Density gradient + interval plots
\item \code{stat_dist_pointinterval}: Point + interval plots
\item \code{stat_dist_interval}: Interval plots
}

These stats expect a \code{dist} aesthetic to specify a distribution name
and \code{arg1}, ... \code{arg9} aesthetics (or \code{args} as a list column) to specify distribution
arguments. Distribution names should correspond to R functions that have \code{"p"}, \code{"q"}, and
\code{"d"} functions; e.g. \code{"norm"} is a valid distribution name because R defines the
\code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, and \code{\link[=dnorm]{dnorm()}} functions for Normal distributions.

See the \code{\link[=parse_dist]{parse_dist()}} function for a useful way to generate \code{dist} and \code{args}
values from human-readable distribution specs (like \code{"normal(0,1)"}). Such specs are also
produced by other packages (like the \code{brms::get_prior} function in brms); thus,
\code{\link[=parse_dist]{parse_dist()}} combined with the stats described here can help you visualize the output
of those functions.
}
\section{Aesthetics}{

These stats support the following aesthetics:
\itemize{
\item \code{dist}
\item \code{args}
\item \code{arg1}
\item \code{arg2}
\item \code{arg3}
\item \code{arg4}
\item \code{arg5}
\item \code{arg6}
\item \code{arg7}
\item \code{arg8}
\item \code{arg9}
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{thickness}
\item \code{size}
\item \code{group}
}
In addition, in their default configuration (paired with \code{\link[=geom_slabinterval]{geom_slabinterval()}}) the following aesthetics are supported by the underlying geom:
\itemize{
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{y}
\item \code{ymin}
\item \code{ymax}
\item \code{x}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\section{Computed Variables}{

\itemize{
\item \code{x} or \code{y}: For slabs, the input values to the slab function.
For intervals, the point summary from the interval function. Whether it is \code{x} or \code{y} depends on \code{orientation}
\item \code{xmin} or \code{ymin}: For intervals, the lower end of the interval from the interval function.
\item \code{xmax} or \code{ymax}: For intervals, the upper end of the interval from the interval function.
\item \code{f}: For slabs, the output values from the slab function.
}
}

\examples{

library(dplyr)
library(ggplot2)

tribble(
  ~group, ~subgroup, ~mean, ~sd,
  "a",          "h",     5,   1,
  "b",          "h",     7,   1.5,
  "c",          "h",     8,   1,
  "c",          "i",     9,   1,
  "c",          "j",     7,   1
) \%>\%
  ggplot(aes(x = group, dist = "norm", arg1 = mean, arg2 = sd, fill = subgroup)) +
  stat_dist_eye(position = "dodge")

# the stat_dist_... family applies a Jacobian adjustment to densities
# when plotting on transformed scales in order to plot them correctly.
# For example, here is a log-Normal distribution plotted on the log
# scale, where it will appear Normal:
data.frame(dist = "lnorm") \%>\%
  ggplot(aes(y = 1, dist = dist, arg1 = log(10), arg2 = 2*log(10))) +
  stat_dist_halfeye() +
  scale_x_log10(breaks = 10^seq(-5,7, by = 2))

# see vignette("slabinterval") for many more examples.

}
\seealso{
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for more information on the geom these stats
use by default and some of the options they have. See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}}
for the versions of these stats that can be used on samples.
See \code{vignette("slabinterval")} for a variety of examples of use.
}
