% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_plotting.R
\name{profile.dmc}
\alias{profile.dmc}
\title{Profile a DMC Object}
\usage{
\method{profile}{dmc}(fitted, p.name, min.p, max.p, p.vector, n.point = 100,
  digits = 2, ...)
}
\arguments{
\item{fitted}{a DMC model data instance}

\item{p.name}{indicate which paramter in theta to plot. For example, in a
LBA model with a \code{pVec <- c(A="1",B="1",mean_v="M",sd_v="1",t0="1",
st0="1")}, one can assign \code{p.name <- "A"} to ask \code{profile.dmc} to
profile \emph{A} parameter}

\item{min.p}{minimal number of points to plot}

\item{max.p}{maximal number of points to plot}

\item{p.vector}{a parameter vector. Use Lognromal LBA model as an example,
\code{pVec <- c(A=.25, B=.35, meanlog_v.true=1, meanlog_v.false=.25,
sdlog_v.true=.5,t0=.2)}}

\item{n.point}{grid  resolution}

\item{digits}{print out how many digits}

\item{...}{other graphical parameters (see par)}
}
\description{
Profile a DMC model based a model data instance (ie \code{fitted}). For
the parameter \code{p.name}, e.g., the boundary separation \emph{a} in a DDM,
extract it our from a \code{p.vector} and draws the profile likelihood for
data and returns the maximum (on a grid of resolution \code{n.point})
}
\details{
Set a range for the x axis, which is the profiled parameter. Initiate a
log-likelihodd vector with 0 everywhere and length n.point. keep the other
parmaters value fixed and change only the target parameter value to ps[i],
and then calculate its sum of log-likelihood. Finally, store it in the i
position of ll vector. This function currently works for DDM density only.
}
\examples{
m1 <- model.dmc(
p.map=list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
constants=c(st0=0,d=0),
match.map=list(M=list(s1="r1",s2="r2")),
factors=list(S=c("s1","s2")),
responses=c("r1","r2"),
type="rd")

p.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1=c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2=c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower=c(0,-5, 0, 0, 0, 0),
  upper=c(5, 7, 2, 2, 2, 2))

pVec <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat1 <- simulate(m1, nsim=1e2, p.vector=pVec)
mdi1 <- data.model.dmc(dat1, m1)

## ---------------------------
par(mfrow=c(2,3));
profile(mdi1, "a",  .1,   2, pVec)
profile(mdi1, "v",  .1,   2, pVec)
profile(mdi1, "z",  .2,  .8, pVec)
profile(mdi1, "sz", .1,  .9, pVec)
profile(mdi1, "sv", .1,   2, pVec)
profile(mdi1, "t0", .01, .5, pVec)
par(mfrow=c(1,1));
}

