% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_model.R
\name{data.model.dmc}
\alias{data.model.dmc}
\title{Bind Data and Models}
\usage{
data.model.dmc(data, model)
}
\arguments{
\item{data}{a data frame stored choice-RT data}

\item{model}{a DMC model}
}
\description{
Binding a data frame and a DMC model description. This function also check
if they are compatible and adding a \code{cell.index} and many other
attributes to the data frame in order to speed likelihood computation.
}
\details{
\code{data.model.dmc} adds a \code{dmc} class.
}
\examples{
m1 <- model.dmc(
   p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
   constants = c(st0=0,d=0),
   match.map = list(M=list(s1="r1",s2="r2")),
   factors   = list(S=c("s1","s2")),
   responses = c("r1","r2"),
   type      = "rd")

pVec <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat1 <- simulate(m1, nsim=1e2, p.vector=pVec)
mdi1 <- data.model.dmc(dat1, m1)
class(mdi1)
## [1] "data.frame"        "dmc"
}

