% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gge.R
\name{rnipals}
\alias{rnipals}
\title{PCA by non-linear iterative partial least squares, coded in R.}
\usage{
rnipals(x, maxcomp = min(nrow(x), ncol(x) - 1), maxiter = 5000,
  tol = 1e-06, propvar = 1, center = TRUE, scale. = FALSE,
  verbose = FALSE)
}
\arguments{
\item{x}{Numerical matrix}

\item{maxcomp}{Maximum number of principal components to extract.}

\item{maxiter}{Maximum number of NIPALS iterations to perform.}

\item{tol}{Default 1e-6 tolerance for testing convergence of the algorithm.}

\item{propvar}{The proportion of variance that should be explained by the
returned principal components. If propvar < 1, then \code{maxcomp} is ignored.}

\item{center}{If TRUE, do center columns.}

\item{scale.}{If FALSE, do not scale columns.}

\item{verbose}{FALSE. If TRUE, show diagnostic output.}
}
\value{
A list with components.
}
\description{
PCA by non-linear iterative partial least squares, coded in R.
}
\author{
Kevin Wright
}
