% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm.R
\name{emm}
\alias{emm}
\title{Get marginal effects for model response}
\usage{
emm(model, ci.lvl = 0.95, type = c("fe", "re"), typical = "mean", ...)
}
\arguments{
\item{model}{A fitted model object, or a list of model objects. Any model
that supports common methods like \code{predict()}, \code{family()}
or \code{model.frame()} should work.}

\item{ci.lvl}{Numeric, the level of the confidence intervals. For \code{ggpredict()},
use \code{ci.lvl = NA}, if confidence intervals should not be calculated
(for instance, due to computation time).}

\item{type}{Character, only applies for mixed effects models. Indicates
whether predicted values should be conditioned on random effects
(\code{type = "re"}) or fixed effects only (\code{type = "fe"},
the default).}

\item{typical}{Character vector, naming the function to be applied to the
covariates over which the effect is "averaged". The default is "mean".
See \code{\link[sjstats]{typical_value}} for options.}

\item{...}{Further arguments passed down to \code{predict()}.}
}
\value{
A tibble with the marginal effect of the response (\code{predicted})
        and the confidence intervals \code{conf.low} and \code{conf.high}.
        For \code{polr}-objects, the marginal effect for each level of the
        response variable is returned.
}
\description{
\code{emm()} is a convenient shortcut to compute the estimated
             marginal mean, resp. the marginal effect of the model's response
             variable, with all independent variables held constant (at
             their \code{\link[sjstats]{typical_value}}).
}
\details{
For linear models, the predicted value is the estimated marginal
         mean. Else, the predicted value is on the scale of the inverse of
         link function.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
emm(fit)

# Example from ?MASS::polr
library(MASS)
options(contrasts = c("contr.treatment", "contr.poly"))
house.plr <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
emm(house.plr)

}
