% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggmca_initial_dims}
\alias{ggmca_initial_dims}
\title{Plot Initial Dimensions (Active Variables) of Multiple Correspondence Analysis}
\usage{
ggmca_initial_dims(
  res.mca = res.mca,
  data,
  proj_just = c(1.5, 2),
  cleannames = TRUE,
  keep = NULL
)
}
\arguments{
\item{res.mca}{An object created with \code{FactoMineR::\link[FactoMineR]{MCA}}.}

\item{data}{The data in which to find the supplementary variables, etc.}

\item{proj_just}{Horizontal justification of text of the coordinates on axes,
as a character vector of length 2 (x and y).}

\item{cleannames}{Set to \code{TRUE} to clean levels names, by removing
prefix numbers like \code{"1-"}, and text in parentheses.}

\item{keep}{A character vector of the name of active variables to keep.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object to be printed in the
`RStudio` Plots pane. Possibility to add other gg objects with \code{+}.
Sending the result through \code{\link{ggi}} will draw the
interactive graph in the Viewer pane using \code{\link[ggiraph]{ggiraph}}.
}
\description{
This function mostly have an educational value : it shows the
initial dimensions of the Multiple Correspondence Analysis (active variables)
in their initial reference frame. It shows the n dimensional space before the
analysis is done. To see initial dimensions axes in the space built by the
analysis (principal axes), use \code{\link[ggfacto]{ggmca_with_base_ref}}.
}
\examples{
\donttest{
data(tea, package = "FactoMineR")
res.mca <- MCA2(tea, active_vars = 1:18)
ggmca_initial_dims(res.mca, data = tea)
}
}
