% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_fields.r
\name{annotation_fields}
\alias{annotation_fields}
\title{Annotate a ggplot with vector fields}
\usage{
annotation_fields(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  max_radius = ggplot2::unit(0.5, "cm"),
  .angle_correction = angle_correction,
  arrow = grid::arrow(length = ggplot2::unit(0.2, "cm")),
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{Can be one of four things:
\itemize{
\item \code{NULL}: in that case data from the parent \link[ggplot2:ggplot]{ggplot} call is
inherited.
\item \code{data.frame}: you need to assign the \code{x} and \code{y} aesthetics.
\item \link[sf:st_as_sf]{sf object}: it should contain a \code{geometry} column with only \code{POINT} geometries.
\item \link[stars:st_as_stars]{stars object}: it will be converted automatically to an \code{sf} object.
}}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{max_radius}{Maximum radius to which the \code{radius} aesthetic is scaled in the plot.
You can use absolute ("e.g., "cm", "in", "pt") and relative ("npc") \link[ggplot2:reexports]{units} to set
its value. Default is \verb{0.5 cm}.}

\item{.angle_correction}{Function to correct the angle in the aesthetics for the projection and/or
aspect ratio used in the plot. When set to \code{NULL} the angle is not corrected and is treated as the angle
in the final plot. A custom function can be provided which should accept at least three arguments
(\code{data}, \code{panel_params} and \code{coord}). See \code{\link[=angle_correction]{angle_correction()}} and \code{vignette("angle_correction")} for
more details.}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
A \code{\link[ggplot2:layer_sf]{ggplot2::layer_sf()}}.
}
\description{
Functions exactly the same as \code{\link[=geom_fields]{geom_fields()}}, with that difference
that this function does not train the \code{x} and \code{y} scales. This
makes the data central, and uses this layer to support it. Consequently,
\code{annotation_fields()} does not accept a \code{stat} argument.
}
\examples{
if (requireNamespace("stars") && requireNamespace("ggplot2")) {
  library(stars)
  library(ggplot2)

  data("seawatervelocity")
  sw_sub <- seawatervelocity[,8:13,1:5]
  
  ## Note that the `seawatervelocity` spans a much larger area,
  ## but the plot only focuses on `sw_sub`
  ggplot() +
    geom_stars(data = sw_sub) +
    annotation_fields(data = seawatervelocity,
                      aes(angle = as.numeric(atan2(vo, uo)),
                          radius = as.numeric(pythagoras(uo, vo)))) +
    labs(radius = "v [m/s]")
}
}
\author{
Pepijn de Vries
}
