% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_qq}
\alias{gf_qq}
\alias{gf_qqline}
\alias{gf_qqstep}
\title{Formula interface to geom_qq()}
\usage{
gf_qq(object = NULL, gformula = NULL, data = NULL, geom = "point",
  stat = "qq", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(), xlab,
  ylab, title, subtitle, caption, ...)

gf_qqline(object = NULL, gformula = NULL, data = NULL, geom = "line",
  stat = "qqline", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(), xlab,
  ylab, title, subtitle, caption, ...)

gf_qqstep(object = NULL, gformula = NULL, data = NULL, geom = "step",
  stat = "qq", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(), xlab,
  ylab, title, subtitle, caption, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{group}, \code{x}, \code{y}, \code{distribution}, \code{dparams}}
}
\value{
a gg object
}
\description{
\code{gf_qq()} an \code{gf_qqstep()} both create quantile-quantile plots. They
differ in how they display the qq-plot.
\code{gf_qq()} uses points and \code{gf_qqstep()} plots a step function
through these points.
}
\details{
Positional aesthetics are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.

Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}
\examples{
gf_qq(~rnorm(100))
gf_qq(~Sepal.Length | Species, data = iris) \%>\% gf_qqline()
gf_qq(~Sepal.Length | Species, data = iris) \%>\% gf_qqline(tail = 0.10)
gf_qq(~Sepal.Length, color = ~Species, data = iris) \%>\%
gf_qqstep(~Sepal.Length, color = ~Species, data = iris)
}
\seealso{
\code{\link[ggplot2:geom_qq]{ggplot2::geom_qq()}}
}
