% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_sf}
\alias{gf_sf}
\title{Mapping with shape files}
\usage{
gf_sf(object = NULL, gformula = NULL, data = NULL, alpha, color, fill,
  group, linetype, size, geometry, xlab, ylab, title, subtitle, caption,
  stat = "sf", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{geometry}{A column of class sfc containg simple features data. (Another option
is that \code{data} may contain a column named \code{geometry}.)  \code{geometry} is never
inherited.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object
}
\description{
Mapping with shape files
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{

if (require(maps) && require(maptools) &&
  require(sf) && require(rgeos) &&
  utils::packageVersion("ggplot2") > "2.2.1") {
  US <- sf::st_as_sf(map('state', plot = FALSE, fill = TRUE))
  gf_sf( fill = ~ factor(nchar(ID)), data = US) \%>\%
  gf_refine(coord_sf())

  # We can specify shape data and external data separately using geometry
  MI <- sf::st_as_sf(map('county', 'michigan', plot = FALSE, fill = TRUE))
  gf_sf(fill = ~ log10(population), data = MIpop \%>\% dplyr::arrange(county),
        geometry = ~ MI$geometry, color = "white") \%>\%
  gf_refine(coord_sf(), theme_bw())

  # alternatively we can merge external data and shape data into one data frame.
  MI \%>\%
    dplyr::mutate(county = gsub("michigan,", "", ID)) \%>\%
    dplyr::left_join(MIpop \%>\% dplyr::mutate(county = tolower(county))) \%>\%
    gf_sf(fill = ~ population/1e3) \%>\%
  gf_refine(
    coord_sf(), theme_bw(),
    scale_fill_continuous(name = "population (thousands)", trans = "log10"))
}
}
\seealso{
\code{\link[ggplot2:geom_line]{ggplot2::geom_line()}}, \code{\link[=gf_point]{gf_point()}}
}
