% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-location.R
\name{raster_placement}
\alias{raster_placement}
\alias{ras_fill}
\alias{ras_fit}
\alias{ras_stretch}
\alias{ras_place}
\alias{ras_tile}
\title{Control placements of raster in the plot}
\usage{
ras_fill(raster, align_to = "canvas")

ras_fit(raster, align_to = "canvas")

ras_stretch(raster, align_to = "canvas")

ras_place(raster, align_to = "canvas", anchor = "topleft", offset = c(0, 0))

ras_tile(
  raster,
  align_to = "canvas",
  anchor = "topleft",
  offset = c(0, 0),
  flip = FALSE
)
}
\arguments{
\item{raster}{A \code{raster} or \code{nativeRaster} object or an object coercible to
a \code{raster} object}

\item{align_to}{Should the raster be positioned according to the canvas or
the current viewport}

\item{anchor}{Where should the raster be placed relative to the alignment
area}

\item{offset}{A unit or numeric vector giving an additional offset relative
to the anchor. Positive values moves right/down and negative values move
left/up}

\item{flip}{Should every other repetition be flipped}
}
\value{
The input with additional information attached
}
\description{
When using raster objects directly you need to somehow define how it should
be located in resized in the plot. These function can be used to inform the
filter on how it should be used. They only work on \code{raster} type object, so
cannot be used around functions or layer id's.
}
\examples{
library(ggplot2)
logo <- as.raster(magick::image_read(
  system.file('help', 'figures', 'logo.png', package = 'ggfx')
))

# Default is to fill the viewport area, preserving the aspect ratio of the
# raster
ggplot(mtcars) +
  with_blend(
    geom_point(aes(mpg, disp)),
    logo
  )

# But you can change that with these functions:
ggplot(mtcars) +
  with_blend(
    geom_point(aes(mpg, disp)),
    ras_place(logo, 'vp', 'bottomright')
  )

# Here we tile it with flipping, centering on the middle of the canvas
ggplot(mtcars) +
  with_blend(
    geom_point(aes(mpg, disp)),
    ras_tile(logo, anchor = 'center', flip = TRUE)
  )

}
