% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{with_kernel}
\alias{with_kernel}
\title{Apply a gaussian blur to your layer}
\usage{
with_kernel(
  x,
  kernel = "Gaussian:0x2",
  iterations = 1,
  scaling = NULL,
  bias = NULL,
  stack = FALSE,
  ...
)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{kernel}{either a square matrix or a string. The string can either be a
parameterized \link[magick:kernel_types]{kerneltype} such as: \code{"DoG:0,0,2"} or \code{"Diamond"}
or it can contain a custom matrix (see examples)}

\item{iterations}{number of iterations}

\item{scaling}{string with kernel scaling. The special flag \code{"!"} automatically scales to full
dynamic range, for example: \code{"50\%!"}}

\item{bias}{output bias string, for example \code{"50\%"}}

\item{stack}{Should the original layer be placed on top?}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter allows you to apply a custom kernel to your layer, thus giving
you more control than e.g. \code{\link[=with_blur]{with_blur()}} which is also applying a kernel.
}
\examples{
library(ggplot2)
# Add directional blur using the comet kernel
ggplot(mtcars, aes(mpg, disp)) +
  with_kernel(geom_point(size = 3), 'Comet:0,10')

}
