% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_nested.R
\name{facet_nested}
\alias{facet_nested}
\title{Layout panels in a grid with nested strips}
\usage{
facet_nested(
  rows = NULL,
  cols = NULL,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  margins = FALSE,
  facets = NULL,
  nest_line = FALSE,
  resect = unit(0, "mm"),
  bleed = FALSE
)
}
\arguments{
\item{rows}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{space}{If \code{"fixed"}, the default, all panels have the same size.
If \code{"free_y"} their height will be proportional to the length of the
y scale; if \code{"free_x"} their width will be proportional to the
length of the x scale; or if \code{"free"} both height and width will
vary.  This setting has no effect unless the appropriate scales also vary.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{facets}{This argument is soft-deprecated, please use \code{rows}
and \code{cols} instead.}

\item{nest_line}{a \code{logical} vector of length 1, indicating whether to
draw a nesting line to indicate the nesting of variables. Control the look
of the nesting line by setting the \code{ggh4x.facet.nestline} theme
element.}

\item{resect}{a \code{unit} vector of length 1, indicating how much the
nesting line should be shortened.}

\item{bleed}{a \code{logical} vector of length 1, indicating whether merging
of lower-level variables is allowed when the higher-level variables are
separate. See details.}
}
\value{
A \emph{FacetNested} ggproto object.
}
\description{
\code{facet_nested()} forms a matrix of panels defined by row
  and column faceting variables and nests grouped facets.
}
\details{
Unlike \code{facet_grid()}, this function only automatically expands
  missing variables when they have no variables in that direction, to allow
  for unnested variables. It still requires at least one layer to have all
  faceting variables.

  Hierarchies are inferred from the order of variables supplied to
  \code{rows} or \code{cols}. The first variable is interpreted to be the
  outermost variable, while the last variable is interpreted to be the
  innermost variable. They display order is always such that the outermost
  variable is placed the furthest away from the panels. Strips are
  automatically grouped when they span a nested variable.

  The \code{bleed} argument controls whether lower-level variables are allowed
  to be merged when higher-level are different, i.e. they can bleed over
  hierarchies. Suppose the \code{facet_grid()} behaviour would be the
  following:

  \code{[_1_][_2_][_2_]} \cr \code{[_3_][_3_][_4_]}

  In such case, the default \code{bleed = FALSE} argument would result in the
  following:

  \code{[_1_][___2____]} \cr \code{[_3_][_3_][_4_]}

  Whereas \code{bleed = TRUE} would allow the following:

  \code{[_1_][___2____]} \cr \code{[___3____][_4_]}
}
\examples{
df <- iris
df$nester <- ifelse(df$Species == "setosa",
                    "Short Leaves",
                    "Long Leaves")

ggplot(df, aes(Sepal.Length, Petal.Length)) +
  geom_point() +
  facet_nested(~ nester + Species)

# Controlling the nest line
ggplot(df, aes(Sepal.Length, Petal.Length)) +
  geom_point() +
  facet_nested(~ nester + Species, nest_line = TRUE) +
  theme(ggh4x.facet.nestline = element_line(linetype = 3))
}
\seealso{
See \code{\link[ggplot2]{facet_grid}} for descriptions of the
  original arguments. See \code{\link[grid]{unit}} for the construction of a
  \code{unit} vector.

Other facetting functions: 
\code{\link{facet_nested_wrap}()},
\code{\link{facet_wrap2}()}
}
\concept{facetting functions}
