% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_sf_interactive.R
\name{geom_sf_interactive}
\alias{geom_sf_interactive}
\alias{geom_sf_label_interactive}
\alias{geom_sf_text_interactive}
\title{Create interactive sf objects}
\usage{
geom_sf_interactive(...)

geom_sf_label_interactive(...)

geom_sf_text_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
These geometries are based on \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}, \code{\link[ggplot2:ggsf]{ggplot2::geom_sf_label()}}
and \code{\link[ggplot2:ggsf]{ggplot2::geom_sf_text()}}. See the documentation for those functions for
more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive sf objects to a ggplot -------
library(ggplot2)
library(ggiraph)

## original code: see section examples of ggplot2::geom_sf help file
if (requireNamespace("sf",
                     quietly = TRUE,
                     versionCheck = c(op = ">=", version = "0.7-3"))) {
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
  gg <- ggplot(nc) +
    geom_sf_interactive(aes(fill = AREA, tooltip = NAME, data_id = NAME))
  x <- girafe(ggobj = gg)
  if( interactive() ) print(x)

  nc_3857 <- sf::st_transform(nc, "+init=epsg:3857")

  # Unfortunately if you plot other types of feature you'll need to use
  # show.legend to tell ggplot2 what type of legend to use
  nc_3857$mid <- sf::st_centroid(nc_3857$geometry)
  gg <- ggplot(nc_3857) +
    geom_sf(colour = "white") +
    geom_sf_interactive(aes(geometry = mid,
        size = AREA, tooltip = NAME, data_id = NAME),
      show.legend = "point")
  x <- girafe( ggobj = gg)
  if( interactive() ) print(x)

  # Example with texts.
  gg <- ggplot(nc_3857[1:3, ]) +
    geom_sf(aes(fill = AREA)) +
    geom_sf_text_interactive(aes(label = NAME, tooltip = NAME), color="white")
  x <- girafe( ggobj = gg)
  if( interactive() ) print(x)

  # Example with labels.
  gg <- ggplot(nc_3857[1:3, ]) +
    geom_sf(aes(fill = AREA)) +
    geom_sf_label_interactive(aes(label = NAME, tooltip = NAME))
  x <- girafe( ggobj = gg)
  if( interactive() ) print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
