% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_quantile_interactive.R
\name{geom_quantile_interactive}
\alias{geom_quantile_interactive}
\title{Create interactive quantile regression}
\usage{
geom_quantile_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_quantile]{ggplot2::geom_quantile()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive quantiles to a ggplot -------
library(ggplot2)
library(ggiraph)

if (requireNamespace("quantreg", quietly = TRUE)) {
  m <- ggplot(mpg, aes(displ, 1 / hwy)) + geom_point()
  p <- m + geom_quantile_interactive(
    aes(
      tooltip = after_stat(quantile),
      data_id = after_stat(quantile),
      colour = after_stat(quantile)
    ),
    formula = y ~ x,
    size = 2,
    alpha = 0.5
  )
  x <- girafe(ggobj = p)
  x <- girafe_options(x = x,
                      opts_hover(css = "stroke:red;stroke-width:10px;") )
  if (interactive()) print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
