% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_smooth_interactive.R
\name{geom_smooth_interactive}
\alias{geom_smooth_interactive}
\title{Create interactive smoothed conditional means}
\usage{
geom_smooth_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometry is based on \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive bar -------
library(ggplot2)
library(ggiraph)

p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  geom_smooth_interactive(aes(tooltip = "smoothed line", data_id = "smooth"))
x <- girafe(ggobj = p)
x <- girafe_options(x = x, opts_hover(css = "stroke:orange;stroke-width:3px;"))
if (interactive()) {
  print(x)
}

p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  geom_smooth_interactive(
    method = lm,
    se = FALSE,
    tooltip = "smooth",
    data_id = "smooth"
  )
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

p <- ggplot(
  mpg,
  aes(displ, hwy, colour = class, tooltip = class, data_id = class)
) +
  geom_point_interactive() +
  geom_smooth_interactive(se = FALSE, method = lm)
x <- girafe(ggobj = p)
x <- girafe_options(x = x, opts_hover(css = "stroke:red;stroke-width:3px;"))
if (interactive()) {
  print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
