% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\docType{data}
\name{stat_joy}
\alias{stat_joy}
\alias{StatJoy}
\title{Stat for density joyplots}
\usage{
stat_joy(mapping = NULL, data = NULL, geom = "joy",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, bandwidth = NULL, from = NULL, to = NULL, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{geom}{The geometric object to use to display the data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{bandwidth}{Bandwidth used for density calculation. If not provided, is estimated from the data.}

\item{from, to}{The left and right-most points of the grid at which the density is to be estimated,
as in \code{\link[=density]{density()}}. If not provided, there are estimated from the data range and the bandwidth.}

\item{...}{other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This stat is the default stat used by \code{\link{geom_joy}}. It is very similar to \code{\link{stat_density}},
however there are a few differences. Most importantly, the density bandwidth is chosen across
the entire dataset.
}
\keyword{datasets}
