% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logliklasso}
\alias{logliklasso}
\alias{logliklasso.default}
\alias{logliklasso.fullrank}
\title{Estimation of Log-likelihood for Linear Mixed Model with Lasso Penalty}
\usage{
logliklasso(ggmix_object, ...)

\method{logliklasso}{default}(ggmix_object, ...)

\method{logliklasso}{fullrank}(ggmix_object, ..., eta, sigma2, beta, nt, x, y)
}
\arguments{
\item{ggmix_object}{A ggmix_object object of class \code{lowrank} or
\code{fullrank}}

\item{...}{Extra parameters. Currently ignored.}

\item{eta}{current estimate of the eta parameter}

\item{sigma2}{current estimate of the sigma2 parameter}

\item{beta}{current estimate of the beta parameter including the intercept.
this should be of length p+1, where p is the number of variables.}

\item{nt}{total number of observations}

\item{x}{input matrix, of dimension n x p; where n is the number of
observations and p are the number of predictors.}

\item{y}{response variable. must be a quantitative variable}
}
\value{
A decreasing sequence of tuning parameters
}
\description{
\code{sigma2lasso} estimates the value of the sigma2 for the
  linear mixed model with lasso penalty
}
\note{
This function isn't meant to be called directly by the user.
}
\seealso{
\code{\link{ggmix}}

\code{\link{ggmix_data_object}}
}
