\name{labs}
\alias{ggtitle}
\alias{labs}
\alias{xlab}
\alias{ylab}
\title{Change axis labels and legend titles}
\usage{
  labs(...)

  xlab(label)

  ylab(label)

  ggtitle(label)
}
\arguments{
  \item{label}{The text for the axis or plot title.}

  \item{...}{a list of new names in the form aesthetic =
  "new name"}
}
\description{
  Change axis labels and legend titles
}
\examples{
p <- qplot(mpg, wt, data = mtcars)
p + labs(title = "New plot title")
p + labs(x = "New x label")
p + xlab("New x label")
p + ylab("New y label")
p + ggtitle("New plot title")

# This should work indepdendently of other functions that modify the
# the scale names
p + ylab("New y label") + ylim(2, 4)
p + ylim(2, 4) + ylab("New y label")

# The labs function also modifies legend labels
p <- qplot(mpg, wt, data = mtcars, colour = cyl)
p + labs(colour = "Cylinders")

# Can also pass in a list, if that is more convenient
p + labs(list(title = "Title", x = "X", y = "Y"))
}

