% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge-to.R
\name{position_nudge_to}
\alias{position_nudge_to}
\title{Nudge labels to new positions}
\usage{
position_nudge_to(x = NULL, y = NULL)
}
\arguments{
\item{x, y}{Coordinates of the destination position. A numeric
vector of length 1, or of the same length as rows there are in `data`.
The default, `NULL`, leaves the original coordinates unchanged.}
}
\value{
A \code{"Position"} object.
}
\description{
`position_nudge_to()` is generally useful for adjusting the position of
labels or text, both on a discrete or continuous scale. This version from
package 'ggpmisc' differs from [ggplot2::position_nudge] in that the
coordinates of the new position is given directly, rather than as a
displacement from the original location. As other position functions in
this package, it preserves the original position to allow the text to
be linked back to its original position with a segment or arrow.
}
\details{
The new `x` or `y` replace the original ones, while the original
  coordinates are returned in `x_orig` and `y_orig`.
}
\examples{
df <- data.frame(
  x = c(1,3,2,5,4,2.5),
  y = c(2, 1, 2.5, 1.8, 2.8, 1.5),
  label = c("abc","cd","d","c","bcd","a")
)

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text(position = position_nudge_to(y = 3)
  )

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_linked(position = position_nudge_to(y = 3),
                   vjust = -0.2)

}
\seealso{
[ggplot::position_nudge()], [ggrepel::position_nudge_repel()].

Other position adjustments: 
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_line}()}
}
\concept{position adjustments}
