% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-linked.r, R/geom-text-linked.r
\name{geom_label_s}
\alias{geom_label_s}
\alias{geom_text_s}
\title{Linked Text}
\usage{
geom_label_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = grid::unit(0.25, "lines"),
  label.r = grid::unit(0.15, "lines"),
  label.size = 0.25,
  add.segments = TRUE,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_text_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  add.segments = TRUE,
  arrow = NULL,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by [ggplot2::aes]. If
specified and \code{inherit.aes = TRUE} (the default), is combined with the
default mapping at the top level of the plot. You only need to supply
\code{mapping} if there isn't a mapping defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{colour = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} takes place at draw
time and in the order of the data, thus its action depends of the size at
which the plot is drawn.}
}
\value{
A plot layer instance.
}
\description{
Text geoms are most useful for labelling plots. `geom_text_s()`
  adds text to the plot and for nudged positions links the original location
  to the nudged text with a segment.
}
\details{
Note that when you change the scale limits for x and/or y of a plot,
  text labels stay the same size, as determined by the \code{size} aesthetic.
  The actual size as seen in the plotted output is decided during the
  rendering of the plot to a graphics device. Limits are expanded only to
  include the anchor point of the labels because the "width" and "height" of
  a text element are 0 (as seen by ggplot2). For the same reason, stacking
  and dodging text will not work as they take place within 'ggplot2' before
  the rendered size of text is known. Text labels do have height and width,
  but in grid units, not data units.

  By default this geom uses \code{\link{position_nudge_center}} which is
  backwards compatible with \code{\link[ggplot2]{position_nudge}} but
  provides additional control on the direction of the nudging. In contrast to
  \code{\link[ggplot2]{position_nudge}}, \code{\link{position_nudge_center}}
  and all other position functions defined in packages 'ggpp' and 'ggrepel'
  keep the original coordinates thus allowing the plotting of connecting
  segments and arrows.
}
\note{
You can alternatively use \code{\link[ggrepel]{geom_label_repel}},
  possibly setting `max.iter = 0` to disable repulsion when needed.
}
\section{Under development}{
 This is preliminary version of the geom. I plan
  to add features like padding around text and points. I aim to make use of
  the new features of 'grid' in R >= 4.1.0 to keep the implementation as fast
  and simple as possible. Currently this geom does all drawing using at most
  two vectorized calls to 'grid' functions. As a temporary replacement of
  padding around text one can use 'slightly out-of-range' numeric values for
  justification as shown in the examples. Aesthetics `segment.colour` and
  `segment.alpha` are implemented, but `segment.linetype` not yet.
}

\section{Alignment}{
 You can modify text alignment with the `vjust` and
  `hjust` aesthetics. These can either be a number between 0 (right/bottom)
  and 1 (top/left) or a character (`"left"`, `"middle"`, `"right"`,
  `"bottom"`, `"center"`, `"top"`). There several two special alignments:
  `"inward"` and `"outward"`. Inward always aligns text towards the center of
  the plotting area, and outward aligns it away from the center of the
  plotting area. It tagged with `_mean` or `_median` the mean or median of
  the data in the panel along the corresponding axis is used as center.
}

\examples{

my.cars <- mtcars[c(TRUE, FALSE, FALSE, FALSE), ]
my.cars$name <- rownames(my.cars)
p <- ggplot(my.cars, aes(wt, mpg, label = name))

# default behavior is as for geon_text()
p + geom_text_s()
# Avoid overlaps
p + geom_text_s(check_overlap = TRUE)
# Change size of the label
p + geom_text_s(size = 2.5)

# default behavior is as for geon_label()
p + geom_label_s()
# Change size of the label
p + geom_label_s(size = 2.5)

# Use nudging
p +
  geom_point() +
  geom_text_s(hjust = -0.04, nudge_x = 0.12) +
  expand_limits(x = 6.2)
p +
  geom_point() +
  geom_text_s(hjust = -0.04, nudge_x = 0.12,
  arrow = arrow(length = grid::unit(1.5, "mm"))) +
  expand_limits(x = 6.2)
p +
  geom_point() +
  geom_text_s(vjust = -0.5, nudge_y = 0.5)
p +
  geom_point() +
  geom_text_s(angle = 90,
              hjust = -0.04, nudge_y = 1,
              arrow = arrow(length = grid::unit(1.5, "mm")),
              segment.colour = "red") +
  expand_limits(y = 30)

p +
  geom_point() +
  geom_label_s(hjust = 0, nudge_x = 0.12) +
  expand_limits(x = 6.2)

# Add aesthetic mappings and adjust arrows
p +
  geom_point() +
  geom_text_s(aes(colour = factor(cyl)),
              segment.colour = "black",
              angle = 90,
              hjust = -0.04, nudge_y = 1,
              arrow = arrow(angle = 20,
                            length = grid::unit(1.5, "mm"),
                            ends = "first",
                            type = "closed"),
              show.legend = FALSE) +
  scale_colour_discrete(l = 40) + # luminance, make colours darker
  expand_limits(y = 40)

# Add aesthetic mappings and adjust arrows
p +
  geom_point() +
  geom_label_s(aes(colour = factor(cyl)),
              hjust = 0, nudge_x = 0.3,
              arrow = arrow(angle = 20,
                            length = grid::unit(2/3, "lines"))) +
  scale_colour_discrete(l = 40) + # luminance, make colours darker
  expand_limits(x = 7)

# Scale height of text, rather than sqrt(height)
p +
  geom_point() +
  geom_text_s(aes(size = wt), nudge_x = -0.1, hjust = "right") +
  scale_radius(range = c(3,6)) + # override scale_area()
    expand_limits(x = c(1.8, 5.5))

}
