% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_shape_prism.R
\name{scale_shape_prism}
\alias{scale_shape_prism}
\title{Prism shape scales (discrete)}
\usage{
scale_shape_prism(palette = "default", ...)
}
\arguments{
\item{palette}{\code{string}. Palette name, one of: \code{default},
\code{filled}, or \code{complete}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\value{
Returns a ggproto object of class \emph{ScaleDiscrete} which works with
\emph{shape} aesthetics.
}
\description{
Shape scales that approximate those used in GraphPad Prism.
No unicode characters are used, only the default symbols available in R.
}
\details{
The \code{default} palette supports up to 9 values. It does not use
any symbols with a fill.

The \code{filled} palette supports up to 10 values. The first 5 symbols
have a fill.

The \code{complete} palette supports up to 14 values. Symbols 5 to 9
have a fill.
}
\examples{
library(ggplot2)

## list all available shape palettes
ggprism_data$shape_palettes

## define a base plot
base <- ggplot(mtcars, aes(x = wt, y = mpg,
                           shape = factor(cyl))) +
  geom_point(size = 3)

## works pretty much the same as ggplot2 scale_shape_manual
base +
  scale_shape_prism(palette = "complete")

## change shape scale title in legend
base +
  scale_shape_prism(
    palette = "default",
    name = "Cylinders"
  )

## change shape labels in legend
base +
  scale_shape_prism(
    palette = "default",
    name = "Cylinders",
    label = c("4 cyl", "6 cyl", "8 cyl")
  )

## change shape labels in legend with a function
base +
  scale_shape_prism(
    palette = "default",
    name = "Cylinders",
    label = function(x) paste(x, "cyl")
  )

## change order of shapes in legend
base +
  scale_shape_prism(
    palette = "default",
    name = "Cylinders",
    label = function(x) paste(x, "cyl"),
    breaks = c(8, 4, 6)
  )

## to change which shape is assigned to which cyl
## you need to change the factor levels in the underlying data
base <- ggplot(mtcars, aes(x = wt, y = mpg,
                           shape = factor(cyl, levels = c(6, 4, 8)))) +
  geom_point(size = 3)

base +
  scale_shape_prism(
    palette = "default",
    name = "Cylinders"
  )

## see all the shapes in a specific palette
# define a function for convenience
show_shapes <- function(palette) {
  df_shapes <- ggprism_data$shape_palettes[[palette]][, -1]
  df_shapes$pch_f <- factor(df_shapes$pch, levels = df_shapes$pch)

  ggplot(df_shapes, aes(x = 0, y = 0, shape = pch)) +
    geom_point(aes(shape = pch), size = 5, fill = 'red') +
    scale_shape_identity() +
    facet_wrap(~ pch_f) +
    theme_void()
}

# show the shapes in the palette "complete"
show_shapes("complete")
}
