% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quiver.r, R/stat-quiver.r
\docType{data}
\name{geom_quiver}
\alias{geom_quiver}
\alias{GeomQuiver}
\alias{stat_quiver}
\alias{StatQuiver}
\title{Quiver plots for ggplot2}
\format{
An object of class \code{GeomQuiver} (inherits from \code{GeomSegment}, \code{Geom}, \code{ggproto}, \code{gg}) of length 2.

An object of class \code{StatQuiver} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
geom_quiver(
  mapping = NULL,
  data = NULL,
  stat = "quiver",
  position = "identity",
  center = FALSE,
  rescale = FALSE,
  vecsize = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

GeomQuiver

stat_quiver(
  mapping = NULL,
  data = NULL,
  geom = "quiver",
  position = "identity",
  center = FALSE,
  rescale = FALSE,
  vecsize = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

StatQuiver
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{center}{If \code{FALSE} (the default), the vector lines will start at the specified x and y. If \code{TRUE}, the arrows will be centered about x and y.}

\item{rescale}{If \code{FALSE} (the default), the vectors will not be rescaled. If \code{TRUE}, the vectors given by (u, v) will be rescaled using the \code{scale} function.}

\item{vecsize}{By default (NULL), vectors sizing is automatically determined. If a grid can be identified, they will be scaled to the grid, if not, the vectors will not be scaled. By specifying a numeric input here, the length of all arrows can be adjusted. Setting vecsize to zero will prevent scaling the arrows.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}
}
\description{
Displays the direction and length of vectors on a graph.
}
\section{Computed variables}{

\describe{
\item{x}{centered x start position for velocity arrow}
\item{y}{centered y start position for velocity arrow}
\item{xend}{centered x end position for velocity arrow}
\item{yend}{centered y end position for velocity arrow}
}
}

\examples{
library(ggplot2)
# Quiver plots of mathematical functions
field <- expand.grid(x=seq(0,pi,pi/12), y=seq(0,pi,pi/12))
ggplot(field, aes(x=x,y=y,u=cos(x),v=sin(y))) +
  geom_quiver()

# Removing automatic scaling
ggplot(seals, aes(x=long, y=lat, u=delta_long, v=delta_lat)) +
  geom_quiver(vecsize=NULL) +
  borders("state")

}
\keyword{datasets}
