# Generated by tools/update_iterm_palettes.R: do not edit by hand
# Please run Rscript tools/update_iterm_palettes.R to regenerate this file

#' iTerm color palette names
#'
#' @return Character vector of palette names.
#'
#' @export iterm_palettes
#'
#' @examples
#' iterm_palettes()
iterm_palettes <- function() {
  c(
    "0x96f",
    "12-bit Rainbow",
    "3024 Day",
    "3024 Night",
    "Aardvark Blue",
    "Abernathy",
    "Adventure Time",
    "Adventure",
    "Adwaita Dark",
    "Adwaita",
    "Afterglow",
    "Alabaster",
    "Alien Blood",
    "Andromeda",
    "Apple Classic",
    "Apple System Colors Light",
    "Apple System Colors",
    "Arcoiris",
    "Ardoise",
    "Argonaut",
    "Arthur",
    "Atelier Sulphurpool",
    "Atom One Dark",
    "Atom One Light",
    "Atom",
    "Aura",
    "Aurora",
    "Ayu Light",
    "Ayu Mirage",
    "Ayu",
    "Banana Blueberry",
    "Batman",
    "Belafonte Day",
    "Belafonte Night",
    "Birds Of Paradise",
    "Black Metal (Bathory)",
    "Black Metal (Burzum)",
    "Black Metal (Dark Funeral)",
    "Black Metal (Gorgoroth)",
    "Black Metal (Immortal)",
    "Black Metal (Khold)",
    "Black Metal (Marduk)",
    "Black Metal (Mayhem)",
    "Black Metal (Nile)",
    "Black Metal (Venom)",
    "Black Metal",
    "Blazer",
    "Blue Berry Pie",
    "Blue Dolphin",
    "Blue Matrix",
    "Bluloco Dark",
    "Bluloco Light",
    "Borland",
    "Box",
    "Breadog",
    "Breeze",
    "Bright Lights",
    "Broadcast",
    "Brogrammer",
    "Builtin Dark",
    "Builtin Light",
    "Builtin Pastel Dark",
    "Builtin Solarized Dark",
    "Builtin Solarized Light",
    "Builtin Tango Dark",
    "Builtin Tango Light",
    "C64",
    "Calamity",
    "Carbonfox",
    "Catppuccin Frappe",
    "Catppuccin Latte",
    "Catppuccin Macchiato",
    "Catppuccin Mocha",
    "CGA",
    "Chalk",
    "Chalkboard",
    "Challenger Deep",
    "Chester",
    "Ciapre",
    "Citruszest",
    "CLRS",
    "Cobalt Neon",
    "Cobalt Next Dark",
    "Cobalt Next Minimal",
    "Cobalt Next",
    "Cobalt2",
    "Coffee Theme",
    "Crayon Pony Fish",
    "Cursor Dark",
    "Cutie Pro",
    "Cyberdyne",
    "Cyberpunk Scarlet Protocol",
    "Cyberpunk",
    "Dark Modern",
    "Dark Pastel",
    "Dark+",
    "Darkermatrix",
    "Darkmatrix",
    "Darkside",
    "Dawnfox",
    "Dayfox",
    "Deep",
    "Desert",
    "Detuned",
    "Dimidium",
    "Dimmed Monokai",
    "Django Reborn Again",
    "Django Smooth",
    "Django",
    "Doom One",
    "Doom Peacock",
    "Dot Gov",
    "Dracula",
    "Dracula+",
    "Duckbones",
    "Duotone Dark",
    "Duskfox",
    "Earthsong",
    "Electron Highlighter",
    "Elegant",
    "Elemental",
    "Elementary",
    "Embark",
    "Embers Dark",
    "ENCOM",
    "Espresso Libre",
    "Espresso",
    "Everblush",
    "Everforest Dark Hard",
    "Everforest Light Med",
    "Fahrenheit",
    "Fairyfloss",
    "Farmhouse Dark",
    "Farmhouse Light",
    "Fideloper",
    "Firefly Traditional",
    "Firefox Dev",
    "Firewatch",
    "Fish Tank",
    "Flat",
    "Flatland",
    "Flexoki Dark",
    "Flexoki Light",
    "Floraverse",
    "Forest Blue",
    "Framer",
    "Front End Delight",
    "Fun Forrest",
    "Galaxy",
    "Galizur",
    "Ghostty Default Style Dark",
    "GitHub Dark Colorblind",
    "GitHub Dark Default",
    "GitHub Dark Dimmed",
    "GitHub Dark High Contrast",
    "GitHub Dark",
    "GitHub Light Colorblind",
    "GitHub Light Default",
    "GitHub Light High Contrast",
    "GitHub",
    "GitLab Dark Grey",
    "GitLab Dark",
    "GitLab Light",
    "Glacier",
    "Grape",
    "Grass",
    "Grey Green",
    "Gruber Darker",
    "Gruvbox Dark Hard",
    "Gruvbox Dark",
    "Gruvbox Light Hard",
    "Gruvbox Light",
    "Gruvbox Material Dark",
    "Gruvbox Material Light",
    "Gruvbox Material",
    "Guezwhoz",
    "Hacktober",
    "Hardcore",
    "Harper",
    "Havn Daggry",
    "Havn Skumring",
    "HaX0R Blue",
    "HaX0R Gr33N",
    "HaX0R R3D",
    "Heeler",
    "Highway",
    "Hipster Green",
    "Hivacruz",
    "Homebrew",
    "Hopscotch.256",
    "Hopscotch",
    "Horizon Bright",
    "Horizon",
    "Hurtado",
    "Hybrid",
    "IBM 5153 CGA (Black)",
    "IBM 5153 CGA",
    "IC Green PPL",
    "IC Orange PPL",
    "Iceberg Dark",
    "Iceberg Light",
    "Idea",
    "Idle Toes",
    "IR Black",
    "IRIX Console",
    "IRIX Terminal",
    "iTerm2 Dark Background",
    "iTerm2 Default",
    "iTerm2 Light Background",
    "iTerm2 Pastel Dark Background",
    "iTerm2 Smoooooth",
    "iTerm2 Solarized Dark",
    "iTerm2 Solarized Light",
    "iTerm2 Tango Dark",
    "iTerm2 Tango Light",
    "Jackie Brown",
    "Japanesque",
    "Jellybeans",
    "JetBrains Darcula",
    "Jubi",
    "Kanagawa Dragon",
    "Kanagawa Wave",
    "Kanagawabones",
    "Kibble",
    "Kitty Default",
    "Kitty Low Contrast",
    "Kolorit",
    "Konsolas",
    "Kurokula",
    "Lab Fox",
    "Laser",
    "Later This Evening",
    "Lavandula",
    "Light Owl",
    "Liquid Carbon Transparent",
    "Liquid Carbon",
    "Lovelace",
    "Man Page",
    "Mariana",
    "Material Dark",
    "Material Darker",
    "Material Design Colors",
    "Material Ocean",
    "Material",
    "Mathias",
    "Matrix",
    "Medallion",
    "Melange Dark",
    "Melange Light",
    "Mellifluous",
    "Mellow",
    "Miasma",
    "Midnight In Mojave",
    "Mirage",
    "Misterioso",
    "Molokai",
    "Mona Lisa",
    "Monokai Classic",
    "Monokai Pro Light Sun",
    "Monokai Pro Light",
    "Monokai Pro Machine",
    "Monokai Pro Octagon",
    "Monokai Pro Ristretto",
    "Monokai Pro Spectrum",
    "Monokai Pro",
    "Monokai Remastered",
    "Monokai Soda",
    "Monokai Vivid",
    "Moonfly",
    "N0Tch2K",
    "Neobones Dark",
    "Neobones Light",
    "Neon",
    "Neopolitan",
    "Neutron",
    "Night Lion V1",
    "Night Lion V2",
    "Night Owl",
    "Night Owlish Light",
    "Nightfox",
    "Niji",
    "Nocturnal Winter",
    "Nord Light",
    "Nord Wave",
    "Nord",
    "Nordfox",
    "Novel",
    "Nvim Dark",
    "Nvim Light",
    "Obsidian",
    "Ocean",
    "Oceanic Material",
    "Oceanic Next",
    "Ollie",
    "One Double Dark",
    "One Double Light",
    "One Half Dark",
    "One Half Light",
    "Operator Mono Dark",
    "Overnight Slumber",
    "Oxocarbon",
    "Pale Night Hc",
    "Pandora",
    "Paraiso Dark",
    "Paul Millr",
    "Pencil Dark",
    "Pencil Light",
    "Peppermint",
    "Phala Green Dark",
    "Piatto Light",
    "Pnevma",
    "Popping And Locking",
    "Powershell",
    "Primary",
    "Pro Light",
    "Pro",
    "Purple Rain",
    "Purplepeter",
    "Rapture",
    "Raycast Dark",
    "Raycast Light",
    "Rebecca",
    "Red Alert",
    "Red Planet",
    "Red Sands",
    "Relaxed",
    "Retro Legends",
    "Retro",
    "Rippedcasts",
    "Rose Pine Dawn",
    "Rose Pine Moon",
    "Rose Pine",
    "Rouge 2",
    "Royal",
    "Ryuuko",
    "Sakura",
    "Scarlet Protocol",
    "Sea Shells",
    "Seafoam Pastel",
    "Selenized Dark",
    "Selenized Light",
    "Seoulbones Dark",
    "Seoulbones Light",
    "Seti",
    "Shades Of Purple",
    "Shaman",
    "Slate",
    "Sleepy Hollow",
    "Smyck",
    "Snazzy Soft",
    "Snazzy",
    "Soft Server",
    "Solarized Darcula",
    "Solarized Dark Higher Contrast",
    "Solarized Dark Patched",
    "Solarized Osaka Night",
    "Sonokai",
    "Spacedust",
    "Spacegray Bright",
    "Spacegray Eighties Dull",
    "Spacegray Eighties",
    "Spacegray",
    "Spiderman",
    "Spring",
    "Square",
    "Squirrelsong Dark",
    "Srcery",
    "Starlight",
    "Sublette",
    "Subliminal",
    "Sugarplum",
    "Sundried",
    "Symfonic",
    "Synthwave Alpha",
    "Synthwave Everything",
    "Synthwave",
    "Tango Adapted",
    "Tango Half Adapted",
    "Tearout",
    "Teerb",
    "Terafox",
    "Terminal Basic Dark",
    "Terminal Basic",
    "Thayer Bright",
    "The Hulk",
    "Tinacious Design Dark",
    "Tinacious Design Light",
    "TokyoNight Day",
    "TokyoNight Moon",
    "TokyoNight Night",
    "TokyoNight Storm",
    "TokyoNight",
    "Tomorrow Night Blue",
    "Tomorrow Night Bright",
    "Tomorrow Night Burns",
    "Tomorrow Night Eighties",
    "Tomorrow Night",
    "Tomorrow",
    "Toy Chest",
    "Treehouse",
    "Twilight",
    "Ubuntu",
    "Ultra Dark",
    "Ultra Violent",
    "Under The Sea",
    "Unikitty",
    "Urple",
    "Vague",
    "Vaughn",
    "Vercel",
    "Vesper",
    "Vibrant Ink",
    "Vimbones",
    "Violet Dark",
    "Violet Light",
    "Violite",
    "Warm Neon",
    "Wez",
    "Whimsy",
    "Wild Cherry",
    "Wilmersdorf",
    "Wombat",
    "Wryan",
    "Xcode Dark hc",
    "Xcode Dark",
    "Xcode Light hc",
    "Xcode Light",
    "Xcode WWDC",
    "Zenbones Dark",
    "Zenbones Light",
    "Zenbones",
    "Zenburn",
    "Zenburned",
    "Zenwritten Dark",
    "Zenwritten Light"
  )
}

ggsci_db_iterm <- vector("list")

ggsci_db_iterm$"0x96f"$"normal" <- c(
  "Blue" = "#00CDE8",
  "Yellow" = "#FFC739",
  "Red" = "#FF666D",
  "Cyan" = "#9DEAF6",
  "Green" = "#B3E03A",
  "Magenta" = "#A392E8"
)

ggsci_db_iterm$"0x96f"$"bright" <- c(
  "Blue" = "#1BD5EB",
  "Yellow" = "#FFD05E",
  "Red" = "#FF7E83",
  "Cyan" = "#ACEDF8",
  "Green" = "#BEE55E",
  "Magenta" = "#B0A3EB"
)

ggsci_db_iterm$"12-bit Rainbow"$"normal" <- c(
  "Blue" = "#3060B0",
  "Yellow" = "#E09040",
  "Red" = "#A03050",
  "Cyan" = "#0090C0",
  "Green" = "#40D080",
  "Magenta" = "#603090"
)

ggsci_db_iterm$"12-bit Rainbow"$"bright" <- c(
  "Blue" = "#00B0C0",
  "Yellow" = "#E0D000",
  "Red" = "#C06060",
  "Cyan" = "#20B0C0",
  "Green" = "#90D050",
  "Magenta" = "#801070"
)

ggsci_db_iterm$"3024 Day"$"normal" <- c(
  "Blue" = "#01A0E4",
  "Yellow" = "#FDED02",
  "Red" = "#DB2D20",
  "Cyan" = "#B5E4F4",
  "Green" = "#01A252",
  "Magenta" = "#A16A94"
)

ggsci_db_iterm$"3024 Day"$"bright" <- c(
  "Blue" = "#807D7C",
  "Yellow" = "#4A4543",
  "Red" = "#E8BBD0",
  "Cyan" = "#CDAB53",
  "Green" = "#3A3432",
  "Magenta" = "#D6D5D4"
)

ggsci_db_iterm$"3024 Night"$"normal" <- c(
  "Blue" = "#01A0E4",
  "Yellow" = "#FDED02",
  "Red" = "#DB2D20",
  "Cyan" = "#B5E4F4",
  "Green" = "#01A252",
  "Magenta" = "#A16A94"
)

ggsci_db_iterm$"3024 Night"$"bright" <- c(
  "Blue" = "#807D7C",
  "Yellow" = "#4A4543",
  "Red" = "#E8BBD0",
  "Cyan" = "#CDAB53",
  "Green" = "#3A3432",
  "Magenta" = "#D6D5D4"
)

ggsci_db_iterm$"Aardvark Blue"$"normal" <- c(
  "Blue" = "#1370D3",
  "Yellow" = "#DBBA00",
  "Red" = "#AA342E",
  "Cyan" = "#008EB0",
  "Green" = "#4B8C0F",
  "Magenta" = "#C43AC3"
)

ggsci_db_iterm$"Aardvark Blue"$"bright" <- c(
  "Blue" = "#60A4EC",
  "Yellow" = "#FFE763",
  "Red" = "#F05B50",
  "Cyan" = "#60B6CB",
  "Green" = "#95DC55",
  "Magenta" = "#E26BE2"
)

ggsci_db_iterm$"Abernathy"$"normal" <- c(
  "Blue" = "#1093F5",
  "Yellow" = "#CDCD00",
  "Red" = "#CD0000",
  "Cyan" = "#00CDCD",
  "Green" = "#00CD00",
  "Magenta" = "#CD00CD"
)

ggsci_db_iterm$"Abernathy"$"bright" <- c(
  "Blue" = "#11B5F6",
  "Yellow" = "#FFFF00",
  "Red" = "#FF0000",
  "Cyan" = "#00FFFF",
  "Green" = "#00FF00",
  "Magenta" = "#FF00FF"
)

ggsci_db_iterm$"Adventure Time"$"normal" <- c(
  "Blue" = "#0F4AC6",
  "Yellow" = "#E7741E",
  "Red" = "#BD0013",
  "Cyan" = "#70A598",
  "Green" = "#4AB118",
  "Magenta" = "#665993"
)

ggsci_db_iterm$"Adventure Time"$"bright" <- c(
  "Blue" = "#1997C6",
  "Yellow" = "#EFC11A",
  "Red" = "#FC5F5A",
  "Cyan" = "#C8FAF4",
  "Green" = "#9EFF6E",
  "Magenta" = "#9B5953"
)

ggsci_db_iterm$"Adventure"$"normal" <- c(
  "Blue" = "#417AB3",
  "Yellow" = "#EEBB6E",
  "Red" = "#D84A33",
  "Cyan" = "#BDCFE5",
  "Green" = "#5DA602",
  "Magenta" = "#E5C499"
)

ggsci_db_iterm$"Adventure"$"bright" <- c(
  "Blue" = "#97D7EF",
  "Yellow" = "#FFB670",
  "Red" = "#D76B42",
  "Cyan" = "#BDCFE5",
  "Green" = "#99B52C",
  "Magenta" = "#AA7900"
)

ggsci_db_iterm$"Adwaita Dark"$"normal" <- c(
  "Blue" = "#1E78E4",
  "Yellow" = "#F5C211",
  "Red" = "#C01C28",
  "Cyan" = "#0AB9DC",
  "Green" = "#2EC27E",
  "Magenta" = "#9841BB"
)

ggsci_db_iterm$"Adwaita Dark"$"bright" <- c(
  "Blue" = "#51A1FF",
  "Yellow" = "#F8E45C",
  "Red" = "#ED333B",
  "Cyan" = "#4FD2FD",
  "Green" = "#57E389",
  "Magenta" = "#C061CB"
)

ggsci_db_iterm$"Adwaita"$"normal" <- c(
  "Blue" = "#1E78E4",
  "Yellow" = "#F5C211",
  "Red" = "#C01C28",
  "Cyan" = "#0AB9DC",
  "Green" = "#2EC27E",
  "Magenta" = "#9841BB"
)

ggsci_db_iterm$"Adwaita"$"bright" <- c(
  "Blue" = "#51A1FF",
  "Yellow" = "#F8E45C",
  "Red" = "#ED333B",
  "Cyan" = "#4FD2FD",
  "Green" = "#57E389",
  "Magenta" = "#C061CB"
)

ggsci_db_iterm$"Afterglow"$"normal" <- c(
  "Blue" = "#6C99BB",
  "Yellow" = "#E5B567",
  "Red" = "#AC4142",
  "Cyan" = "#7DD6CF",
  "Green" = "#7E8E50",
  "Magenta" = "#9F4E85"
)

ggsci_db_iterm$"Afterglow"$"bright" <- c(
  "Blue" = "#6C99BB",
  "Yellow" = "#E5B567",
  "Red" = "#AC4142",
  "Cyan" = "#7DD6CF",
  "Green" = "#7E8E50",
  "Magenta" = "#9F4E85"
)

ggsci_db_iterm$"Alabaster"$"normal" <- c(
  "Blue" = "#325CC0",
  "Yellow" = "#CB9000",
  "Red" = "#AA3731",
  "Cyan" = "#0083B2",
  "Green" = "#448C27",
  "Magenta" = "#7A3E9D"
)

ggsci_db_iterm$"Alabaster"$"bright" <- c(
  "Blue" = "#007ACC",
  "Yellow" = "#FFBC5D",
  "Red" = "#F05050",
  "Cyan" = "#00AACB",
  "Green" = "#60CB00",
  "Magenta" = "#E64CE6"
)

ggsci_db_iterm$"Alien Blood"$"normal" <- c(
  "Blue" = "#2F6A7F",
  "Yellow" = "#717F24",
  "Red" = "#7F2B27",
  "Cyan" = "#327F77",
  "Green" = "#2F7E25",
  "Magenta" = "#47587F"
)

ggsci_db_iterm$"Alien Blood"$"bright" <- c(
  "Blue" = "#00AAE0",
  "Yellow" = "#BDE000",
  "Red" = "#E08009",
  "Cyan" = "#00E0C4",
  "Green" = "#18E000",
  "Magenta" = "#0058E0"
)

ggsci_db_iterm$"Andromeda"$"normal" <- c(
  "Blue" = "#2472C8",
  "Yellow" = "#E5E512",
  "Red" = "#CD3131",
  "Cyan" = "#0FA8CD",
  "Green" = "#05BC79",
  "Magenta" = "#BC3FBC"
)

ggsci_db_iterm$"Andromeda"$"bright" <- c(
  "Blue" = "#2472C8",
  "Yellow" = "#E5E512",
  "Red" = "#CD3131",
  "Cyan" = "#0FA8CD",
  "Green" = "#05BC79",
  "Magenta" = "#BC3FBC"
)

ggsci_db_iterm$"Apple Classic"$"normal" <- c(
  "Blue" = "#0225C7",
  "Yellow" = "#C7C400",
  "Red" = "#C91B00",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"Apple Classic"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"Apple System Colors Light"$"normal" <- c(
  "Blue" = "#0869CB",
  "Yellow" = "#CDAC08",
  "Red" = "#CC372E",
  "Cyan" = "#479EC2",
  "Green" = "#26A439",
  "Magenta" = "#9647BF"
)

ggsci_db_iterm$"Apple System Colors Light"$"bright" <- c(
  "Blue" = "#0A84FF",
  "Yellow" = "#FFD60A",
  "Red" = "#FF453A",
  "Cyan" = "#76D6FF",
  "Green" = "#32D74B",
  "Magenta" = "#BF5AF2"
)

ggsci_db_iterm$"Apple System Colors"$"normal" <- c(
  "Blue" = "#0869CB",
  "Yellow" = "#CDAC08",
  "Red" = "#CC372E",
  "Cyan" = "#479EC2",
  "Green" = "#26A439",
  "Magenta" = "#9647BF"
)

ggsci_db_iterm$"Apple System Colors"$"bright" <- c(
  "Blue" = "#0A84FF",
  "Yellow" = "#FFD60A",
  "Red" = "#FF453A",
  "Cyan" = "#76D6FF",
  "Green" = "#32D74B",
  "Magenta" = "#BF5AF2"
)

ggsci_db_iterm$"Arcoiris"$"normal" <- c(
  "Blue" = "#518BFC",
  "Yellow" = "#FFC656",
  "Red" = "#DA2700",
  "Cyan" = "#63FAD5",
  "Green" = "#12C258",
  "Magenta" = "#E37BD9"
)

ggsci_db_iterm$"Arcoiris"$"bright" <- c(
  "Blue" = "#B3E8F3",
  "Yellow" = "#FFDDAA",
  "Red" = "#FFB9B9",
  "Cyan" = "#BCFFC7",
  "Green" = "#E3F6AA",
  "Magenta" = "#CBBAF9"
)

ggsci_db_iterm$"Ardoise"$"normal" <- c(
  "Blue" = "#2465C2",
  "Yellow" = "#FCA93A",
  "Red" = "#D3322D",
  "Cyan" = "#64E1B8",
  "Green" = "#588B35",
  "Magenta" = "#7332B4"
)

ggsci_db_iterm$"Ardoise"$"bright" <- c(
  "Blue" = "#6AB5F8",
  "Yellow" = "#FFEA51",
  "Red" = "#FA5852",
  "Cyan" = "#89FFDB",
  "Green" = "#8DC252",
  "Magenta" = "#BE68CA"
)

ggsci_db_iterm$"Argonaut"$"normal" <- c(
  "Blue" = "#008DF8",
  "Yellow" = "#FFB900",
  "Red" = "#FF000F",
  "Cyan" = "#00D8EB",
  "Green" = "#8CE10B",
  "Magenta" = "#6D43A6"
)

ggsci_db_iterm$"Argonaut"$"bright" <- c(
  "Blue" = "#0092FF",
  "Yellow" = "#FFD242",
  "Red" = "#FF2740",
  "Cyan" = "#67FFF0",
  "Green" = "#ABE15B",
  "Magenta" = "#9A5FEB"
)

ggsci_db_iterm$"Arthur"$"normal" <- c(
  "Blue" = "#6495ED",
  "Yellow" = "#E8AE5B",
  "Red" = "#CD5C5C",
  "Cyan" = "#B0C4DE",
  "Green" = "#86AF80",
  "Magenta" = "#DEB887"
)

ggsci_db_iterm$"Arthur"$"bright" <- c(
  "Blue" = "#87CEEB",
  "Yellow" = "#FFA75D",
  "Red" = "#CC5533",
  "Cyan" = "#B0C4DE",
  "Green" = "#88AA22",
  "Magenta" = "#996600"
)

ggsci_db_iterm$"Atelier Sulphurpool"$"normal" <- c(
  "Blue" = "#3D8FD1",
  "Yellow" = "#C08B30",
  "Red" = "#C94922",
  "Cyan" = "#22A2C9",
  "Green" = "#AC9739",
  "Magenta" = "#6679CC"
)

ggsci_db_iterm$"Atelier Sulphurpool"$"bright" <- c(
  "Blue" = "#898EA4",
  "Yellow" = "#5E6687",
  "Red" = "#C76B29",
  "Cyan" = "#9C637A",
  "Green" = "#293256",
  "Magenta" = "#DFE2F1"
)

ggsci_db_iterm$"Atom One Dark"$"normal" <- c(
  "Blue" = "#61AFEF",
  "Yellow" = "#E5C07B",
  "Red" = "#E06C75",
  "Cyan" = "#56B6C2",
  "Green" = "#98C379",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Atom One Dark"$"bright" <- c(
  "Blue" = "#61AFEF",
  "Yellow" = "#E5C07B",
  "Red" = "#E06C75",
  "Cyan" = "#56B6C2",
  "Green" = "#98C379",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Atom One Light"$"normal" <- c(
  "Blue" = "#2F5AF3",
  "Yellow" = "#D2B67C",
  "Red" = "#DE3E35",
  "Cyan" = "#3F953A",
  "Green" = "#3F953A",
  "Magenta" = "#950095"
)

ggsci_db_iterm$"Atom One Light"$"bright" <- c(
  "Blue" = "#2F5AF3",
  "Yellow" = "#D2B67C",
  "Red" = "#DE3E35",
  "Cyan" = "#3F953A",
  "Green" = "#3F953A",
  "Magenta" = "#A00095"
)

ggsci_db_iterm$"Atom"$"normal" <- c(
  "Blue" = "#85BEFD",
  "Yellow" = "#FFD7B1",
  "Red" = "#FD5FF1",
  "Cyan" = "#85BEFD",
  "Green" = "#87C38A",
  "Magenta" = "#B9B6FC"
)

ggsci_db_iterm$"Atom"$"bright" <- c(
  "Blue" = "#96CBFE",
  "Yellow" = "#F5FFA8",
  "Red" = "#FD5FF1",
  "Cyan" = "#85BEFD",
  "Green" = "#94FA36",
  "Magenta" = "#B9B6FC"
)

ggsci_db_iterm$"Aura"$"normal" <- c(
  "Blue" = "#A277FF",
  "Yellow" = "#FFCA85",
  "Red" = "#FF6767",
  "Cyan" = "#61FFCA",
  "Green" = "#61FFCA",
  "Magenta" = "#A277FF"
)

ggsci_db_iterm$"Aura"$"bright" <- c(
  "Blue" = "#A277FF",
  "Yellow" = "#FFCA85",
  "Red" = "#FFCA85",
  "Cyan" = "#61FFCA",
  "Green" = "#A277FF",
  "Magenta" = "#A277FF"
)

ggsci_db_iterm$"Aurora"$"normal" <- c(
  "Blue" = "#0321D7",
  "Yellow" = "#FFE66D",
  "Red" = "#F0266F",
  "Cyan" = "#03D6B8",
  "Green" = "#8FD46D",
  "Magenta" = "#EE5D43"
)

ggsci_db_iterm$"Aurora"$"bright" <- c(
  "Blue" = "#03D6B8",
  "Yellow" = "#FFE66D",
  "Red" = "#F92672",
  "Cyan" = "#03D6B8",
  "Green" = "#8FD46D",
  "Magenta" = "#EE5D43"
)

ggsci_db_iterm$"Ayu Light"$"normal" <- c(
  "Blue" = "#41A6D9",
  "Yellow" = "#F29718",
  "Red" = "#FF3333",
  "Cyan" = "#4DBF99",
  "Green" = "#86B300",
  "Magenta" = "#F07178"
)

ggsci_db_iterm$"Ayu Light"$"bright" <- c(
  "Blue" = "#73D8FF",
  "Yellow" = "#FFC94A",
  "Red" = "#FF6565",
  "Cyan" = "#7FF1CB",
  "Green" = "#B8E532",
  "Magenta" = "#FFA3AA"
)

ggsci_db_iterm$"Ayu Mirage"$"normal" <- c(
  "Blue" = "#6DCBFA",
  "Yellow" = "#FAD07B",
  "Red" = "#ED8274",
  "Cyan" = "#90E1C6",
  "Green" = "#A6CC70",
  "Magenta" = "#CFBAFA"
)

ggsci_db_iterm$"Ayu Mirage"$"bright" <- c(
  "Blue" = "#73D0FF",
  "Yellow" = "#FFD580",
  "Red" = "#F28779",
  "Cyan" = "#95E6CB",
  "Green" = "#BAE67E",
  "Magenta" = "#D4BFFF"
)

ggsci_db_iterm$"Ayu"$"normal" <- c(
  "Blue" = "#36A3D9",
  "Yellow" = "#E7C547",
  "Red" = "#FF3333",
  "Cyan" = "#95E6CB",
  "Green" = "#B8CC52",
  "Magenta" = "#F07178"
)

ggsci_db_iterm$"Ayu"$"bright" <- c(
  "Blue" = "#68D5FF",
  "Yellow" = "#FFF779",
  "Red" = "#FF6565",
  "Cyan" = "#C7FFFD",
  "Green" = "#EAFE84",
  "Magenta" = "#FFA3AA"
)

ggsci_db_iterm$"Banana Blueberry"$"normal" <- c(
  "Blue" = "#22E8DF",
  "Yellow" = "#E6C62F",
  "Red" = "#FF6B7F",
  "Cyan" = "#56B6C2",
  "Green" = "#00BD9C",
  "Magenta" = "#DC396A"
)

ggsci_db_iterm$"Banana Blueberry"$"bright" <- c(
  "Blue" = "#91FFF4",
  "Yellow" = "#F9E46B",
  "Red" = "#FE9EA1",
  "Cyan" = "#BCF3FF",
  "Green" = "#98C379",
  "Magenta" = "#DA70D6"
)

ggsci_db_iterm$"Batman"$"normal" <- c(
  "Blue" = "#737174",
  "Yellow" = "#F4FD22",
  "Red" = "#E6DC44",
  "Cyan" = "#62605F",
  "Green" = "#C8BE46",
  "Magenta" = "#747271"
)

ggsci_db_iterm$"Batman"$"bright" <- c(
  "Blue" = "#919495",
  "Yellow" = "#FEED6C",
  "Red" = "#FFF78E",
  "Cyan" = "#A3A3A6",
  "Green" = "#FFF27D",
  "Magenta" = "#9A9A9D"
)

ggsci_db_iterm$"Belafonte Day"$"normal" <- c(
  "Blue" = "#426A79",
  "Yellow" = "#EAA549",
  "Red" = "#BE100E",
  "Cyan" = "#989A9C",
  "Green" = "#858162",
  "Magenta" = "#97522C"
)

ggsci_db_iterm$"Belafonte Day"$"bright" <- c(
  "Blue" = "#426A79",
  "Yellow" = "#EAA549",
  "Red" = "#BE100E",
  "Cyan" = "#989A9C",
  "Green" = "#858162",
  "Magenta" = "#97522C"
)

ggsci_db_iterm$"Belafonte Night"$"normal" <- c(
  "Blue" = "#426A79",
  "Yellow" = "#EAA549",
  "Red" = "#BE100E",
  "Cyan" = "#989A9C",
  "Green" = "#858162",
  "Magenta" = "#97522C"
)

ggsci_db_iterm$"Belafonte Night"$"bright" <- c(
  "Blue" = "#426A79",
  "Yellow" = "#EAA549",
  "Red" = "#BE100E",
  "Cyan" = "#989A9C",
  "Green" = "#858162",
  "Magenta" = "#97522C"
)

ggsci_db_iterm$"Birds Of Paradise"$"normal" <- c(
  "Blue" = "#5A86AD",
  "Yellow" = "#E99D2A",
  "Red" = "#BE2D26",
  "Cyan" = "#74A6AD",
  "Green" = "#6BA18A",
  "Magenta" = "#AC80A6"
)

ggsci_db_iterm$"Birds Of Paradise"$"bright" <- c(
  "Blue" = "#B8D3ED",
  "Yellow" = "#D0D150",
  "Red" = "#E84627",
  "Cyan" = "#93CFD7",
  "Green" = "#95D8BA",
  "Magenta" = "#D19ECB"
)

ggsci_db_iterm$"Black Metal (Bathory)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#E78A53",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#FBCB97",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Bathory)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#E78A53",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#FBCB97",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Burzum)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#99BBAA",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#DDEECC",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Burzum)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#99BBAA",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#DDEECC",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Dark Funeral)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#5F81A5",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#D0DFEE",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Dark Funeral)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#5F81A5",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#D0DFEE",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Gorgoroth)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#8C7F70",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#9B8D7F",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Gorgoroth)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#8C7F70",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#9B8D7F",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Immortal)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#556677",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#7799BB",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Immortal)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#556677",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#7799BB",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Khold)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#974B46",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#ECEEE3",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Khold)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#974B46",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#ECEEE3",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Marduk)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#626B67",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#A5AAA7",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Marduk)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#626B67",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#A5AAA7",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Mayhem)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#EECC6C",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#F3ECD4",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Mayhem)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#EECC6C",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#F3ECD4",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Nile)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#777755",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#AA9988",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Nile)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#777755",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#AA9988",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Venom)"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#79241F",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#F8F7F2",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal (Venom)"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#79241F",
  "Red" = "#5F8787",
  "Cyan" = "#AAAAAA",
  "Green" = "#F8F7F2",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal"$"normal" <- c(
  "Blue" = "#888888",
  "Yellow" = "#A06666",
  "Red" = "#486E6F",
  "Cyan" = "#AAAAAA",
  "Green" = "#DD9999",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Black Metal"$"bright" <- c(
  "Blue" = "#888888",
  "Yellow" = "#A06666",
  "Red" = "#486E6F",
  "Cyan" = "#AAAAAA",
  "Green" = "#DD9999",
  "Magenta" = "#999999"
)

ggsci_db_iterm$"Blazer"$"normal" <- c(
  "Blue" = "#7A7AB8",
  "Yellow" = "#B8B87A",
  "Red" = "#B87A7A",
  "Cyan" = "#7AB8B8",
  "Green" = "#7AB87A",
  "Magenta" = "#B87AB8"
)

ggsci_db_iterm$"Blazer"$"bright" <- c(
  "Blue" = "#BDBDDB",
  "Yellow" = "#DBDBBD",
  "Red" = "#DBBDBD",
  "Cyan" = "#BDDBDB",
  "Green" = "#BDDBBD",
  "Magenta" = "#DBBDDB"
)

ggsci_db_iterm$"Blue Berry Pie"$"normal" <- c(
  "Blue" = "#90A5BD",
  "Yellow" = "#EAB9A8",
  "Red" = "#99246E",
  "Cyan" = "#7E83CC",
  "Green" = "#5CB1B3",
  "Magenta" = "#9D54A7"
)

ggsci_db_iterm$"Blue Berry Pie"$"bright" <- c(
  "Blue" = "#39173D",
  "Yellow" = "#7A3188",
  "Red" = "#C87272",
  "Cyan" = "#5E6071",
  "Green" = "#0A6C7E",
  "Magenta" = "#BC94B7"
)

ggsci_db_iterm$"Blue Dolphin"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#F4D69F",
  "Red" = "#FF8288",
  "Cyan" = "#89EBFF",
  "Green" = "#B4E88D",
  "Magenta" = "#E9C1FF"
)

ggsci_db_iterm$"Blue Dolphin"$"bright" <- c(
  "Blue" = "#9CC4FF",
  "Yellow" = "#FFE585",
  "Red" = "#FF8B92",
  "Cyan" = "#A3F7FF",
  "Green" = "#DDFFA7",
  "Magenta" = "#DDB0F6"
)

ggsci_db_iterm$"Blue Matrix"$"normal" <- c(
  "Blue" = "#00B0FF",
  "Yellow" = "#FFFC58",
  "Red" = "#FF5680",
  "Cyan" = "#76C1FF",
  "Green" = "#00FF9C",
  "Magenta" = "#D57BFF"
)

ggsci_db_iterm$"Blue Matrix"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#D682EC"
)

ggsci_db_iterm$"Bluloco Dark"$"normal" <- c(
  "Blue" = "#3476FF",
  "Yellow" = "#FF936A",
  "Red" = "#FC2F52",
  "Cyan" = "#4483AA",
  "Green" = "#25A45C",
  "Magenta" = "#7A82DA"
)

ggsci_db_iterm$"Bluloco Dark"$"bright" <- c(
  "Blue" = "#10B1FE",
  "Yellow" = "#F9C859",
  "Red" = "#FF6480",
  "Cyan" = "#5FB9BC",
  "Green" = "#3FC56B",
  "Magenta" = "#FF78F8"
)

ggsci_db_iterm$"Bluloco Light"$"normal" <- c(
  "Blue" = "#275FE4",
  "Yellow" = "#DF631C",
  "Red" = "#D52753",
  "Cyan" = "#27618D",
  "Green" = "#23974A",
  "Magenta" = "#823FF1"
)

ggsci_db_iterm$"Bluloco Light"$"bright" <- c(
  "Blue" = "#0099E1",
  "Yellow" = "#C5A332",
  "Red" = "#FF6480",
  "Cyan" = "#6D93BB",
  "Green" = "#3CBC66",
  "Magenta" = "#CE33C0"
)

ggsci_db_iterm$"Borland"$"normal" <- c(
  "Blue" = "#96CBFE",
  "Yellow" = "#FFFFB6",
  "Red" = "#FF6C60",
  "Cyan" = "#C6C5FE",
  "Green" = "#A8FF60",
  "Magenta" = "#FF73FD"
)

ggsci_db_iterm$"Borland"$"bright" <- c(
  "Blue" = "#B5DCFF",
  "Yellow" = "#FFFFCC",
  "Red" = "#FFB6B0",
  "Cyan" = "#DFDFFE",
  "Green" = "#CEFFAC",
  "Magenta" = "#FF9CFE"
)

ggsci_db_iterm$"Box"$"normal" <- c(
  "Blue" = "#0D73CC",
  "Yellow" = "#CECB00",
  "Red" = "#CC0403",
  "Cyan" = "#0DCDCD",
  "Green" = "#19CB00",
  "Magenta" = "#CB1ED1"
)

ggsci_db_iterm$"Box"$"bright" <- c(
  "Blue" = "#1A8FFF",
  "Yellow" = "#FFFD00",
  "Red" = "#F2201F",
  "Cyan" = "#14FFFF",
  "Green" = "#23FD00",
  "Magenta" = "#FD28FF"
)

ggsci_db_iterm$"Breadog"$"normal" <- c(
  "Blue" = "#005CB4",
  "Yellow" = "#8B4C00",
  "Red" = "#B10B00",
  "Cyan" = "#006A78",
  "Green" = "#007232",
  "Magenta" = "#9B0097"
)

ggsci_db_iterm$"Breadog"$"bright" <- c(
  "Blue" = "#0074E1",
  "Yellow" = "#AE6000",
  "Red" = "#DE1100",
  "Cyan" = "#008697",
  "Green" = "#008F40",
  "Magenta" = "#C300BD"
)

ggsci_db_iterm$"Breeze"$"normal" <- c(
  "Blue" = "#1D99F3",
  "Yellow" = "#F67400",
  "Red" = "#ED1515",
  "Cyan" = "#1ABC9C",
  "Green" = "#11D116",
  "Magenta" = "#9B59B6"
)

ggsci_db_iterm$"Breeze"$"bright" <- c(
  "Blue" = "#3DAEE9",
  "Yellow" = "#FDBC4B",
  "Red" = "#C0392B",
  "Cyan" = "#16A085",
  "Green" = "#1CDC9A",
  "Magenta" = "#8E44AD"
)

ggsci_db_iterm$"Bright Lights"$"normal" <- c(
  "Blue" = "#76D4FF",
  "Yellow" = "#FFC251",
  "Red" = "#FF355B",
  "Cyan" = "#6CBFB5",
  "Green" = "#B7E876",
  "Magenta" = "#BA76E7"
)

ggsci_db_iterm$"Bright Lights"$"bright" <- c(
  "Blue" = "#76D5FF",
  "Yellow" = "#FFC251",
  "Red" = "#FF355B",
  "Cyan" = "#6CBFB5",
  "Green" = "#B7E876",
  "Magenta" = "#BA76E7"
)

ggsci_db_iterm$"Broadcast"$"normal" <- c(
  "Blue" = "#6D9CBE",
  "Yellow" = "#FFD24A",
  "Red" = "#DA4939",
  "Cyan" = "#6E9CBE",
  "Green" = "#519F50",
  "Magenta" = "#D0D0FF"
)

ggsci_db_iterm$"Broadcast"$"bright" <- c(
  "Blue" = "#9FCEF0",
  "Yellow" = "#FFFF7C",
  "Red" = "#FF7B6B",
  "Cyan" = "#A0CEF0",
  "Green" = "#83D182",
  "Magenta" = "#FFFFFF"
)

ggsci_db_iterm$"Brogrammer"$"normal" <- c(
  "Blue" = "#2A84D2",
  "Yellow" = "#ECBA0F",
  "Red" = "#F81118",
  "Cyan" = "#1081D6",
  "Green" = "#2DC55E",
  "Magenta" = "#4E5AB7"
)

ggsci_db_iterm$"Brogrammer"$"bright" <- c(
  "Blue" = "#1081D6",
  "Yellow" = "#F3BD09",
  "Red" = "#DE352E",
  "Cyan" = "#0F7DDB",
  "Green" = "#1DD361",
  "Magenta" = "#5350B9"
)

ggsci_db_iterm$"Builtin Dark"$"normal" <- c(
  "Blue" = "#0000BB",
  "Yellow" = "#BBBB00",
  "Red" = "#BB0000",
  "Cyan" = "#00BBBB",
  "Green" = "#00BB00",
  "Magenta" = "#BB00BB"
)

ggsci_db_iterm$"Builtin Dark"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Builtin Light"$"normal" <- c(
  "Blue" = "#0000BB",
  "Yellow" = "#BBBB00",
  "Red" = "#BB0000",
  "Cyan" = "#00BBBB",
  "Green" = "#00BB00",
  "Magenta" = "#BB00BB"
)

ggsci_db_iterm$"Builtin Light"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Builtin Pastel Dark"$"normal" <- c(
  "Blue" = "#96CBFE",
  "Yellow" = "#FFFFB6",
  "Red" = "#FF6C60",
  "Cyan" = "#C6C5FE",
  "Green" = "#A8FF60",
  "Magenta" = "#FF73FD"
)

ggsci_db_iterm$"Builtin Pastel Dark"$"bright" <- c(
  "Blue" = "#B5DCFF",
  "Yellow" = "#FFFFCC",
  "Red" = "#FFB6B0",
  "Cyan" = "#DFDFFE",
  "Green" = "#CEFFAC",
  "Magenta" = "#FF9CFE"
)

ggsci_db_iterm$"Builtin Solarized Dark"$"normal" <- c(
  "Blue" = "#268BD2",
  "Yellow" = "#B58900",
  "Red" = "#DC322F",
  "Cyan" = "#2AA198",
  "Green" = "#859900",
  "Magenta" = "#D33682"
)

ggsci_db_iterm$"Builtin Solarized Dark"$"bright" <- c(
  "Blue" = "#839496",
  "Yellow" = "#657B83",
  "Red" = "#CB4B16",
  "Cyan" = "#93A1A1",
  "Green" = "#586E75",
  "Magenta" = "#6C71C4"
)

ggsci_db_iterm$"Builtin Solarized Light"$"normal" <- c(
  "Blue" = "#268BD2",
  "Yellow" = "#B58900",
  "Red" = "#DC322F",
  "Cyan" = "#2AA198",
  "Green" = "#859900",
  "Magenta" = "#D33682"
)

ggsci_db_iterm$"Builtin Solarized Light"$"bright" <- c(
  "Blue" = "#839496",
  "Yellow" = "#657B83",
  "Red" = "#CB4B16",
  "Cyan" = "#93A1A1",
  "Green" = "#586E75",
  "Magenta" = "#6C71C4"
)

ggsci_db_iterm$"Builtin Tango Dark"$"normal" <- c(
  "Blue" = "#3465A4",
  "Yellow" = "#C4A000",
  "Red" = "#CC0000",
  "Cyan" = "#06989A",
  "Green" = "#4E9A06",
  "Magenta" = "#75507B"
)

ggsci_db_iterm$"Builtin Tango Dark"$"bright" <- c(
  "Blue" = "#729FCF",
  "Yellow" = "#FCE94F",
  "Red" = "#EF2929",
  "Cyan" = "#34E2E2",
  "Green" = "#8AE234",
  "Magenta" = "#AD7FA8"
)

ggsci_db_iterm$"Builtin Tango Light"$"normal" <- c(
  "Blue" = "#3465A4",
  "Yellow" = "#C4A000",
  "Red" = "#CC0000",
  "Cyan" = "#06989A",
  "Green" = "#4E9A06",
  "Magenta" = "#75507B"
)

ggsci_db_iterm$"Builtin Tango Light"$"bright" <- c(
  "Blue" = "#729FCF",
  "Yellow" = "#FCE94F",
  "Red" = "#EF2929",
  "Cyan" = "#34E2E2",
  "Green" = "#8AE234",
  "Magenta" = "#AD7FA8"
)

ggsci_db_iterm$"C64"$"normal" <- c(
  "Blue" = "#40318D",
  "Yellow" = "#BFCE72",
  "Red" = "#883932",
  "Cyan" = "#67B6BD",
  "Green" = "#55A049",
  "Magenta" = "#8B3F96"
)

ggsci_db_iterm$"C64"$"bright" <- c(
  "Blue" = "#40318D",
  "Yellow" = "#BFCE72",
  "Red" = "#883932",
  "Cyan" = "#67B6BD",
  "Green" = "#55A049",
  "Magenta" = "#8B3F96"
)

ggsci_db_iterm$"Calamity"$"normal" <- c(
  "Blue" = "#3B79C7",
  "Yellow" = "#E9D7A5",
  "Red" = "#FC644D",
  "Cyan" = "#74D3DE",
  "Green" = "#A5F69C",
  "Magenta" = "#F92672"
)

ggsci_db_iterm$"Calamity"$"bright" <- c(
  "Blue" = "#3B79C7",
  "Yellow" = "#E9D7A5",
  "Red" = "#FC644D",
  "Cyan" = "#74D3DE",
  "Green" = "#A5F69C",
  "Magenta" = "#F92672"
)

ggsci_db_iterm$"Carbonfox"$"normal" <- c(
  "Blue" = "#78A9FF",
  "Yellow" = "#08BDBA",
  "Red" = "#EE5396",
  "Cyan" = "#33B1FF",
  "Green" = "#25BE6A",
  "Magenta" = "#BE95FF"
)

ggsci_db_iterm$"Carbonfox"$"bright" <- c(
  "Blue" = "#8CB6FF",
  "Yellow" = "#2DC7C4",
  "Red" = "#F16DA6",
  "Cyan" = "#52BDFF",
  "Green" = "#46C880",
  "Magenta" = "#C8A5FF"
)

ggsci_db_iterm$"Catppuccin Frappe"$"normal" <- c(
  "Blue" = "#8CAAEE",
  "Yellow" = "#E5C890",
  "Red" = "#E78284",
  "Cyan" = "#81C8BE",
  "Green" = "#A6D189",
  "Magenta" = "#F4B8E4"
)

ggsci_db_iterm$"Catppuccin Frappe"$"bright" <- c(
  "Blue" = "#7B9EF0",
  "Yellow" = "#D9BA73",
  "Red" = "#E67172",
  "Cyan" = "#5ABFB5",
  "Green" = "#8EC772",
  "Magenta" = "#F2A4DB"
)

ggsci_db_iterm$"Catppuccin Latte"$"normal" <- c(
  "Blue" = "#1E66F5",
  "Yellow" = "#DF8E1D",
  "Red" = "#D20F39",
  "Cyan" = "#179299",
  "Green" = "#40A02B",
  "Magenta" = "#EA76CB"
)

ggsci_db_iterm$"Catppuccin Latte"$"bright" <- c(
  "Blue" = "#456EFF",
  "Yellow" = "#EEA02D",
  "Red" = "#DE293E",
  "Cyan" = "#2D9FA8",
  "Green" = "#49AF3D",
  "Magenta" = "#FE85D8"
)

ggsci_db_iterm$"Catppuccin Macchiato"$"normal" <- c(
  "Blue" = "#8AADF4",
  "Yellow" = "#EED49F",
  "Red" = "#ED8796",
  "Cyan" = "#8BD5CA",
  "Green" = "#A6DA95",
  "Magenta" = "#F5BDE6"
)

ggsci_db_iterm$"Catppuccin Macchiato"$"bright" <- c(
  "Blue" = "#78A1F6",
  "Yellow" = "#E1C682",
  "Red" = "#EC7486",
  "Cyan" = "#63CBC0",
  "Green" = "#8CCF7F",
  "Magenta" = "#F2A9DD"
)

ggsci_db_iterm$"Catppuccin Mocha"$"normal" <- c(
  "Blue" = "#89B4FA",
  "Yellow" = "#F9E2AF",
  "Red" = "#F38BA8",
  "Cyan" = "#94E2D5",
  "Green" = "#A6E3A1",
  "Magenta" = "#F5C2E7"
)

ggsci_db_iterm$"Catppuccin Mocha"$"bright" <- c(
  "Blue" = "#74A8FC",
  "Yellow" = "#EBD391",
  "Red" = "#F37799",
  "Cyan" = "#6BD7CA",
  "Green" = "#89D88B",
  "Magenta" = "#F2AEDE"
)

ggsci_db_iterm$"CGA"$"normal" <- c(
  "Blue" = "#0000AA",
  "Yellow" = "#AA5500",
  "Red" = "#AA0000",
  "Cyan" = "#00AAAA",
  "Green" = "#00AA00",
  "Magenta" = "#AA00AA"
)

ggsci_db_iterm$"CGA"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Chalk"$"normal" <- c(
  "Blue" = "#2A7FAC",
  "Yellow" = "#B9AC4A",
  "Red" = "#B23A52",
  "Cyan" = "#44A799",
  "Green" = "#789B6A",
  "Magenta" = "#BD4F5A"
)

ggsci_db_iterm$"Chalk"$"bright" <- c(
  "Blue" = "#4196FF",
  "Yellow" = "#FFEB62",
  "Red" = "#F24840",
  "Cyan" = "#53CDBD",
  "Green" = "#80C470",
  "Magenta" = "#FC5275"
)

ggsci_db_iterm$"Chalkboard"$"normal" <- c(
  "Blue" = "#7372C3",
  "Yellow" = "#C2C372",
  "Red" = "#C37372",
  "Cyan" = "#72C2C3",
  "Green" = "#72C373",
  "Magenta" = "#C372C2"
)

ggsci_db_iterm$"Chalkboard"$"bright" <- c(
  "Blue" = "#AAAADB",
  "Yellow" = "#DADBAA",
  "Red" = "#DBAAAA",
  "Cyan" = "#AADADB",
  "Green" = "#AADBAA",
  "Magenta" = "#DBAADA"
)

ggsci_db_iterm$"Challenger Deep"$"normal" <- c(
  "Blue" = "#65B2FF",
  "Yellow" = "#FFB378",
  "Red" = "#FF5458",
  "Cyan" = "#63F2F1",
  "Green" = "#62D196",
  "Magenta" = "#906CFF"
)

ggsci_db_iterm$"Challenger Deep"$"bright" <- c(
  "Blue" = "#91DDFF",
  "Yellow" = "#FFE9AA",
  "Red" = "#FF8080",
  "Cyan" = "#AAFFE4",
  "Green" = "#95FFA4",
  "Magenta" = "#C991E1"
)

ggsci_db_iterm$"Chester"$"normal" <- c(
  "Blue" = "#288AD6",
  "Yellow" = "#FFC83F",
  "Red" = "#FA5E5B",
  "Cyan" = "#28DDDE",
  "Green" = "#16C98D",
  "Magenta" = "#D34590"
)

ggsci_db_iterm$"Chester"$"bright" <- c(
  "Blue" = "#278AD6",
  "Yellow" = "#FEEF6D",
  "Red" = "#FA5E5B",
  "Cyan" = "#27DEDE",
  "Green" = "#16C98D",
  "Magenta" = "#D34590"
)

ggsci_db_iterm$"Ciapre"$"normal" <- c(
  "Blue" = "#576D8C",
  "Yellow" = "#CC8B3F",
  "Red" = "#810009",
  "Cyan" = "#5C4F4B",
  "Green" = "#48513B",
  "Magenta" = "#724D7C"
)

ggsci_db_iterm$"Ciapre"$"bright" <- c(
  "Blue" = "#3097C6",
  "Yellow" = "#DCDF7C",
  "Red" = "#AC3835",
  "Cyan" = "#F3DBB2",
  "Green" = "#A6A75D",
  "Magenta" = "#D33061"
)

ggsci_db_iterm$"Citruszest"$"normal" <- c(
  "Blue" = "#00BFFF",
  "Yellow" = "#FFD400",
  "Red" = "#FF5454",
  "Cyan" = "#48D1CC",
  "Green" = "#00CC7A",
  "Magenta" = "#FF90FE"
)

ggsci_db_iterm$"Citruszest"$"bright" <- c(
  "Blue" = "#33CFFF",
  "Yellow" = "#FFFF00",
  "Red" = "#FF1A75",
  "Cyan" = "#00FFF2",
  "Green" = "#1AFFA3",
  "Magenta" = "#FFB2FE"
)

ggsci_db_iterm$"CLRS"$"normal" <- c(
  "Blue" = "#135CD0",
  "Yellow" = "#FA701D",
  "Red" = "#F8282A",
  "Cyan" = "#33C3C1",
  "Green" = "#328A5D",
  "Magenta" = "#9F00BD"
)

ggsci_db_iterm$"CLRS"$"bright" <- c(
  "Blue" = "#1670FF",
  "Yellow" = "#FDD727",
  "Red" = "#FB0416",
  "Cyan" = "#3AD5CE",
  "Green" = "#2CC631",
  "Magenta" = "#E900B0"
)

ggsci_db_iterm$"Cobalt Neon"$"normal" <- c(
  "Blue" = "#8FF586",
  "Yellow" = "#E9E75C",
  "Red" = "#FF2320",
  "Cyan" = "#8FF586",
  "Green" = "#3BA5FF",
  "Magenta" = "#781AA0"
)

ggsci_db_iterm$"Cobalt Neon"$"bright" <- c(
  "Blue" = "#3C7DD2",
  "Yellow" = "#E9F06D",
  "Red" = "#D4312E",
  "Cyan" = "#6CBC67",
  "Green" = "#8FF586",
  "Magenta" = "#8230A7"
)

ggsci_db_iterm$"Cobalt Next Dark"$"normal" <- c(
  "Blue" = "#409DD4",
  "Yellow" = "#FFC64C",
  "Red" = "#F94967",
  "Cyan" = "#37B5B4",
  "Green" = "#8CC98F",
  "Magenta" = "#CBA3C7"
)

ggsci_db_iterm$"Cobalt Next Dark"$"bright" <- c(
  "Blue" = "#7AC0EB",
  "Yellow" = "#FFDC91",
  "Red" = "#E47E8B",
  "Cyan" = "#84E4E3",
  "Green" = "#BADDBB",
  "Magenta" = "#F3CCEF"
)

ggsci_db_iterm$"Cobalt Next Minimal"$"normal" <- c(
  "Blue" = "#409DD4",
  "Yellow" = "#FFC64C",
  "Red" = "#FF657A",
  "Cyan" = "#37B5B4",
  "Green" = "#8CC98F",
  "Magenta" = "#CBA3C7"
)

ggsci_db_iterm$"Cobalt Next Minimal"$"bright" <- c(
  "Blue" = "#7AC0EB",
  "Yellow" = "#FFDC91",
  "Red" = "#E47E8B",
  "Cyan" = "#84E4E3",
  "Green" = "#BADDBB",
  "Magenta" = "#F3CCEF"
)

ggsci_db_iterm$"Cobalt Next"$"normal" <- c(
  "Blue" = "#409DD4",
  "Yellow" = "#FFC64C",
  "Red" = "#FF527B",
  "Cyan" = "#37B5B4",
  "Green" = "#8CC98F",
  "Magenta" = "#CBA3C7"
)

ggsci_db_iterm$"Cobalt Next"$"bright" <- c(
  "Blue" = "#7AC0EB",
  "Yellow" = "#FFDC91",
  "Red" = "#E47E8B",
  "Cyan" = "#84E4E3",
  "Green" = "#BADDBB",
  "Magenta" = "#F3CCEF"
)

ggsci_db_iterm$"Cobalt2"$"normal" <- c(
  "Blue" = "#1460D2",
  "Yellow" = "#FFE50A",
  "Red" = "#FF0000",
  "Cyan" = "#00BBBB",
  "Green" = "#38DE21",
  "Magenta" = "#FF005D"
)

ggsci_db_iterm$"Cobalt2"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#EDC809",
  "Red" = "#F40E17",
  "Cyan" = "#6AE3FA",
  "Green" = "#3BD01D",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Coffee Theme"$"normal" <- c(
  "Blue" = "#0225C7",
  "Yellow" = "#C7C400",
  "Red" = "#C91B00",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"Coffee Theme"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"Crayon Pony Fish"$"normal" <- c(
  "Blue" = "#8C87B0",
  "Yellow" = "#AB311B",
  "Red" = "#91002B",
  "Cyan" = "#E8A866",
  "Green" = "#579524",
  "Magenta" = "#692F50"
)

ggsci_db_iterm$"Crayon Pony Fish"$"bright" <- c(
  "Blue" = "#CFC9FF",
  "Yellow" = "#C8381D",
  "Red" = "#C5255D",
  "Cyan" = "#FFCEAF",
  "Green" = "#8DFF57",
  "Magenta" = "#FC6CBA"
)

ggsci_db_iterm$"Cursor Dark"$"normal" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Cursor Dark"$"bright" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Cutie Pro"$"normal" <- c(
  "Blue" = "#42D9C5",
  "Yellow" = "#F58669",
  "Red" = "#F56E7F",
  "Cyan" = "#37CB8A",
  "Green" = "#BEC975",
  "Magenta" = "#D286B7"
)

ggsci_db_iterm$"Cutie Pro"$"bright" <- c(
  "Blue" = "#80C5DE",
  "Yellow" = "#F1BB79",
  "Red" = "#E5A1A3",
  "Cyan" = "#9DCCBB",
  "Green" = "#E8D6A7",
  "Magenta" = "#B294BB"
)

ggsci_db_iterm$"Cyberdyne"$"normal" <- c(
  "Blue" = "#0071CF",
  "Yellow" = "#D2A700",
  "Red" = "#FF8373",
  "Cyan" = "#6BFFDD",
  "Green" = "#00C172",
  "Magenta" = "#FF90FE"
)

ggsci_db_iterm$"Cyberdyne"$"bright" <- c(
  "Blue" = "#C2E3FF",
  "Yellow" = "#FFFED5",
  "Red" = "#FFC4BE",
  "Cyan" = "#E6E7FE",
  "Green" = "#D6FCBA",
  "Magenta" = "#FFB2FE"
)

ggsci_db_iterm$"Cyberpunk Scarlet Protocol"$"normal" <- c(
  "Blue" = "#0271B6",
  "Yellow" = "#FAF945",
  "Red" = "#FF0051",
  "Cyan" = "#00C5C7",
  "Green" = "#01DC84",
  "Magenta" = "#C930C7"
)

ggsci_db_iterm$"Cyberpunk Scarlet Protocol"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#60FA68",
  "Magenta" = "#BD35EC"
)

ggsci_db_iterm$"Cyberpunk"$"normal" <- c(
  "Blue" = "#00BFFF",
  "Yellow" = "#FFFA6A",
  "Red" = "#FF7092",
  "Cyan" = "#86CBFE",
  "Green" = "#00FBAC",
  "Magenta" = "#DF95FF"
)

ggsci_db_iterm$"Cyberpunk"$"bright" <- c(
  "Blue" = "#1BCCFD",
  "Yellow" = "#FFF787",
  "Red" = "#FF8AA4",
  "Cyan" = "#99D6FC",
  "Green" = "#21F6BC",
  "Magenta" = "#E6AEFE"
)

ggsci_db_iterm$"Dark Modern"$"normal" <- c(
  "Blue" = "#0078D4",
  "Yellow" = "#9E6A03",
  "Red" = "#F74949",
  "Cyan" = "#1DB4D6",
  "Green" = "#2EA043",
  "Magenta" = "#D01273"
)

ggsci_db_iterm$"Dark Modern"$"bright" <- c(
  "Blue" = "#3B8EEA",
  "Yellow" = "#F5F543",
  "Red" = "#DC5452",
  "Cyan" = "#29B8DB",
  "Green" = "#23D18B",
  "Magenta" = "#D670D6"
)

ggsci_db_iterm$"Dark Pastel"$"normal" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Dark Pastel"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Dark+"$"normal" <- c(
  "Blue" = "#2472C8",
  "Yellow" = "#E5E510",
  "Red" = "#CD3131",
  "Cyan" = "#11A8CD",
  "Green" = "#0DBC79",
  "Magenta" = "#BC3FBC"
)

ggsci_db_iterm$"Dark+"$"bright" <- c(
  "Blue" = "#3B8EEA",
  "Yellow" = "#F5F543",
  "Red" = "#F14C4C",
  "Cyan" = "#29B8DB",
  "Green" = "#23D18B",
  "Magenta" = "#D670D6"
)

ggsci_db_iterm$"Darkermatrix"$"normal" <- c(
  "Blue" = "#00CB6B",
  "Yellow" = "#595900",
  "Red" = "#002E18",
  "Cyan" = "#125459",
  "Green" = "#6FA64C",
  "Magenta" = "#412A4D"
)

ggsci_db_iterm$"Darkermatrix"$"bright" <- c(
  "Blue" = "#00FF87",
  "Yellow" = "#E2E500",
  "Red" = "#00381D",
  "Cyan" = "#176C73",
  "Green" = "#90D762",
  "Magenta" = "#412A4D"
)

ggsci_db_iterm$"Darkmatrix"$"normal" <- c(
  "Blue" = "#2C9A84",
  "Yellow" = "#7E8000",
  "Red" = "#006536",
  "Cyan" = "#114D53",
  "Green" = "#6FA64C",
  "Magenta" = "#452D53"
)

ggsci_db_iterm$"Darkmatrix"$"bright" <- c(
  "Blue" = "#46D8B8",
  "Yellow" = "#E2E500",
  "Red" = "#00733D",
  "Cyan" = "#12545A",
  "Green" = "#90D762",
  "Magenta" = "#4A3059"
)

ggsci_db_iterm$"Darkside"$"normal" <- c(
  "Blue" = "#1C98E8",
  "Yellow" = "#F2D42C",
  "Red" = "#E8341C",
  "Cyan" = "#1C98E8",
  "Green" = "#68C256",
  "Magenta" = "#8E69C9"
)

ggsci_db_iterm$"Darkside"$"bright" <- c(
  "Blue" = "#387CD3",
  "Yellow" = "#EFD64B",
  "Red" = "#E05A4F",
  "Cyan" = "#3D97E2",
  "Green" = "#77B869",
  "Magenta" = "#957BBE"
)

ggsci_db_iterm$"Dawnfox"$"normal" <- c(
  "Blue" = "#286983",
  "Yellow" = "#EA9D34",
  "Red" = "#B4637A",
  "Cyan" = "#56949F",
  "Green" = "#618774",
  "Magenta" = "#907AA9"
)

ggsci_db_iterm$"Dawnfox"$"bright" <- c(
  "Blue" = "#2D81A3",
  "Yellow" = "#EEA846",
  "Red" = "#C26D85",
  "Cyan" = "#5CA7B4",
  "Green" = "#629F81",
  "Magenta" = "#9A80B9"
)

ggsci_db_iterm$"Dayfox"$"normal" <- c(
  "Blue" = "#2848A9",
  "Yellow" = "#AC5402",
  "Red" = "#A5222F",
  "Cyan" = "#287980",
  "Green" = "#396847",
  "Magenta" = "#6E33CE"
)

ggsci_db_iterm$"Dayfox"$"bright" <- c(
  "Blue" = "#4863B6",
  "Yellow" = "#B86E28",
  "Red" = "#B3434E",
  "Cyan" = "#488D93",
  "Green" = "#577F63",
  "Magenta" = "#8452D5"
)

ggsci_db_iterm$"Deep"$"normal" <- c(
  "Blue" = "#5665FF",
  "Yellow" = "#D9BD26",
  "Red" = "#D70005",
  "Cyan" = "#50D2DA",
  "Green" = "#1CD915",
  "Magenta" = "#B052DA"
)

ggsci_db_iterm$"Deep"$"bright" <- c(
  "Blue" = "#9FA9FF",
  "Yellow" = "#FEDC2B",
  "Red" = "#FB0007",
  "Cyan" = "#8DF9FF",
  "Green" = "#22FF18",
  "Magenta" = "#E09AFF"
)

ggsci_db_iterm$"Desert"$"normal" <- c(
  "Blue" = "#CD853F",
  "Yellow" = "#F0E68C",
  "Red" = "#FF2B2B",
  "Cyan" = "#FFA0A0",
  "Green" = "#98FB98",
  "Magenta" = "#FFDEAD"
)

ggsci_db_iterm$"Desert"$"bright" <- c(
  "Blue" = "#87CEFF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#FFD700",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Detuned"$"normal" <- c(
  "Blue" = "#0094D9",
  "Yellow" = "#E6DA73",
  "Red" = "#FE4386",
  "Cyan" = "#50B7D9",
  "Green" = "#A6E32D",
  "Magenta" = "#9B37FF"
)

ggsci_db_iterm$"Detuned"$"bright" <- c(
  "Blue" = "#00BEFF",
  "Yellow" = "#FFF27F",
  "Red" = "#FA80AC",
  "Cyan" = "#5ED7FF",
  "Green" = "#BDE371",
  "Magenta" = "#BE9EFF"
)

ggsci_db_iterm$"Dimidium"$"normal" <- c(
  "Blue" = "#0575D8",
  "Yellow" = "#DB9C11",
  "Red" = "#CF494C",
  "Cyan" = "#1DB6BB",
  "Green" = "#60B442",
  "Magenta" = "#AF5ED2"
)

ggsci_db_iterm$"Dimidium"$"bright" <- c(
  "Blue" = "#688DFD",
  "Yellow" = "#FCCD1A",
  "Red" = "#FF643B",
  "Cyan" = "#32E0FB",
  "Green" = "#37E57B",
  "Magenta" = "#ED6FE9"
)

ggsci_db_iterm$"Dimmed Monokai"$"normal" <- c(
  "Blue" = "#4F76A1",
  "Yellow" = "#C5A635",
  "Red" = "#BE3F48",
  "Cyan" = "#578FA4",
  "Green" = "#879A3B",
  "Magenta" = "#855C8D"
)

ggsci_db_iterm$"Dimmed Monokai"$"bright" <- c(
  "Blue" = "#186DE3",
  "Yellow" = "#C47033",
  "Red" = "#FB001F",
  "Cyan" = "#2E706D",
  "Green" = "#0F722F",
  "Magenta" = "#FB0067"
)

ggsci_db_iterm$"Django Reborn Again"$"normal" <- c(
  "Blue" = "#245032",
  "Yellow" = "#FFE862",
  "Red" = "#FD6209",
  "Cyan" = "#9DF39F",
  "Green" = "#41A83E",
  "Magenta" = "#F8F8F8"
)

ggsci_db_iterm$"Django Reborn Again"$"bright" <- c(
  "Blue" = "#568264",
  "Yellow" = "#FFFF94",
  "Red" = "#FF943B",
  "Cyan" = "#CFFFD1",
  "Green" = "#73DA70",
  "Magenta" = "#FFFFFF"
)

ggsci_db_iterm$"Django Smooth"$"normal" <- c(
  "Blue" = "#989898",
  "Yellow" = "#FFE862",
  "Red" = "#FD6209",
  "Cyan" = "#9DF39F",
  "Green" = "#41A83E",
  "Magenta" = "#F8F8F8"
)

ggsci_db_iterm$"Django Smooth"$"bright" <- c(
  "Blue" = "#CACACA",
  "Yellow" = "#FFFF94",
  "Red" = "#FF943B",
  "Cyan" = "#CFFFD1",
  "Green" = "#73DA70",
  "Magenta" = "#FFFFFF"
)

ggsci_db_iterm$"Django"$"normal" <- c(
  "Blue" = "#245032",
  "Yellow" = "#FFE862",
  "Red" = "#FD6209",
  "Cyan" = "#9DF39F",
  "Green" = "#41A83E",
  "Magenta" = "#F8F8F8"
)

ggsci_db_iterm$"Django"$"bright" <- c(
  "Blue" = "#568264",
  "Yellow" = "#FFFF94",
  "Red" = "#FF943B",
  "Cyan" = "#CFFFD1",
  "Green" = "#73DA70",
  "Magenta" = "#FFFFFF"
)

ggsci_db_iterm$"Doom One"$"normal" <- c(
  "Blue" = "#A9A1E1",
  "Yellow" = "#ECBE7B",
  "Red" = "#FF6C6B",
  "Cyan" = "#51AFEF",
  "Green" = "#98BE65",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Doom One"$"bright" <- c(
  "Blue" = "#A9A1E1",
  "Yellow" = "#ECBE7B",
  "Red" = "#FF6655",
  "Cyan" = "#51AFEF",
  "Green" = "#99BB66",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Doom Peacock"$"normal" <- c(
  "Blue" = "#2A6CC6",
  "Yellow" = "#BCD42A",
  "Red" = "#CB4B16",
  "Cyan" = "#5699AF",
  "Green" = "#26A6A6",
  "Magenta" = "#A9A1E1"
)

ggsci_db_iterm$"Doom Peacock"$"bright" <- c(
  "Blue" = "#51AFEF",
  "Yellow" = "#E6F972",
  "Red" = "#FF5D38",
  "Cyan" = "#46D9FF",
  "Green" = "#98BE65",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Dot Gov"$"normal" <- c(
  "Blue" = "#17B2E0",
  "Yellow" = "#F6BB34",
  "Red" = "#BF091D",
  "Cyan" = "#8BD2ED",
  "Green" = "#3D9751",
  "Magenta" = "#7830B0"
)

ggsci_db_iterm$"Dot Gov"$"bright" <- c(
  "Blue" = "#17B2E0",
  "Yellow" = "#F6BB34",
  "Red" = "#BF091D",
  "Cyan" = "#8BD2ED",
  "Green" = "#3D9751",
  "Magenta" = "#7830B0"
)

ggsci_db_iterm$"Dracula"$"normal" <- c(
  "Blue" = "#BD93F9",
  "Yellow" = "#F1FA8C",
  "Red" = "#FF5555",
  "Cyan" = "#8BE9FD",
  "Green" = "#50FA7B",
  "Magenta" = "#FF79C6"
)

ggsci_db_iterm$"Dracula"$"bright" <- c(
  "Blue" = "#D6ACFF",
  "Yellow" = "#FFFFA5",
  "Red" = "#FF6E6E",
  "Cyan" = "#A4FFFF",
  "Green" = "#69FF94",
  "Magenta" = "#FF92DF"
)

ggsci_db_iterm$"Dracula+"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF5555",
  "Cyan" = "#8BE9FD",
  "Green" = "#50FA7B",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Dracula+"$"bright" <- c(
  "Blue" = "#D6ACFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF6E6E",
  "Cyan" = "#A4FFFF",
  "Green" = "#69FF94",
  "Magenta" = "#FF92DF"
)

ggsci_db_iterm$"Duckbones"$"normal" <- c(
  "Blue" = "#00A3CB",
  "Yellow" = "#E39500",
  "Red" = "#E03600",
  "Cyan" = "#00A3CB",
  "Green" = "#5DCD97",
  "Magenta" = "#795CCC"
)

ggsci_db_iterm$"Duckbones"$"bright" <- c(
  "Blue" = "#00B4E0",
  "Yellow" = "#F6A100",
  "Red" = "#FF4821",
  "Cyan" = "#00B4E0",
  "Green" = "#58DB9E",
  "Magenta" = "#B3A1E6"
)

ggsci_db_iterm$"Duotone Dark"$"normal" <- c(
  "Blue" = "#FFC284",
  "Yellow" = "#D9B76E",
  "Red" = "#D9393E",
  "Cyan" = "#2488FF",
  "Green" = "#2DCD73",
  "Magenta" = "#DE8D40"
)

ggsci_db_iterm$"Duotone Dark"$"bright" <- c(
  "Blue" = "#FFC284",
  "Yellow" = "#D9B76E",
  "Red" = "#D9393E",
  "Cyan" = "#2488FF",
  "Green" = "#2DCD73",
  "Magenta" = "#DE8D40"
)

ggsci_db_iterm$"Duskfox"$"normal" <- c(
  "Blue" = "#569FBA",
  "Yellow" = "#F6C177",
  "Red" = "#EB6F92",
  "Cyan" = "#9CCFD8",
  "Green" = "#A3BE8C",
  "Magenta" = "#C4A7E7"
)

ggsci_db_iterm$"Duskfox"$"bright" <- c(
  "Blue" = "#65B1CD",
  "Yellow" = "#F9CB8C",
  "Red" = "#F083A2",
  "Cyan" = "#A6DAE3",
  "Green" = "#B1D196",
  "Magenta" = "#CCB1ED"
)

ggsci_db_iterm$"Earthsong"$"normal" <- c(
  "Blue" = "#1398B9",
  "Yellow" = "#F5AE2E",
  "Red" = "#C94234",
  "Cyan" = "#509552",
  "Green" = "#85C54C",
  "Magenta" = "#D0633D"
)

ggsci_db_iterm$"Earthsong"$"bright" <- c(
  "Blue" = "#5FDAFF",
  "Yellow" = "#E0D561",
  "Red" = "#FF645A",
  "Cyan" = "#84F088",
  "Green" = "#98E036",
  "Magenta" = "#FF9269"
)

ggsci_db_iterm$"Electron Highlighter"$"normal" <- c(
  "Blue" = "#77ABFF",
  "Yellow" = "#FFD7A9",
  "Red" = "#FF6C8D",
  "Cyan" = "#00FDFF",
  "Green" = "#00FFC3",
  "Magenta" = "#DAA4F4"
)

ggsci_db_iterm$"Electron Highlighter"$"bright" <- c(
  "Blue" = "#77ABFF",
  "Yellow" = "#FFD7A9",
  "Red" = "#FF6C8D",
  "Cyan" = "#00FDFF",
  "Green" = "#00FFC3",
  "Magenta" = "#DAA4F4"
)

ggsci_db_iterm$"Elegant"$"normal" <- c(
  "Blue" = "#8DABE1",
  "Yellow" = "#FFCB8B",
  "Red" = "#FF0257",
  "Cyan" = "#78CCF0",
  "Green" = "#85CC95",
  "Magenta" = "#C792EB"
)

ggsci_db_iterm$"Elegant"$"bright" <- c(
  "Blue" = "#8DABE1",
  "Yellow" = "#FFCB8B",
  "Red" = "#FF0057",
  "Cyan" = "#3FACEF",
  "Green" = "#85CC95",
  "Magenta" = "#C792EB"
)

ggsci_db_iterm$"Elemental"$"normal" <- c(
  "Blue" = "#497F7D",
  "Yellow" = "#7F7111",
  "Red" = "#98290F",
  "Cyan" = "#387F58",
  "Green" = "#479A43",
  "Magenta" = "#7F4E2F"
)

ggsci_db_iterm$"Elemental"$"bright" <- c(
  "Blue" = "#79D9D9",
  "Yellow" = "#D69927",
  "Red" = "#E0502A",
  "Cyan" = "#59D599",
  "Green" = "#61E070",
  "Magenta" = "#CD7C54"
)

ggsci_db_iterm$"Elementary"$"normal" <- c(
  "Blue" = "#063B8C",
  "Yellow" = "#FDB40C",
  "Red" = "#D71C15",
  "Cyan" = "#2595E1",
  "Green" = "#5AA513",
  "Magenta" = "#E40038"
)

ggsci_db_iterm$"Elementary"$"bright" <- c(
  "Blue" = "#0955FF",
  "Yellow" = "#FEC80E",
  "Red" = "#FC1C18",
  "Cyan" = "#3EA8FC",
  "Green" = "#6BC219",
  "Magenta" = "#FB0050"
)

ggsci_db_iterm$"Embark"$"normal" <- c(
  "Blue" = "#57C7FF",
  "Yellow" = "#FFE9AA",
  "Red" = "#F0719B",
  "Cyan" = "#87DFEB",
  "Green" = "#A1EFD3",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Embark"$"bright" <- c(
  "Blue" = "#1DA0E2",
  "Yellow" = "#FFB378",
  "Red" = "#F02E6E",
  "Cyan" = "#63F2F1",
  "Green" = "#2CE592",
  "Magenta" = "#A742EA"
)

ggsci_db_iterm$"Embers Dark"$"normal" <- c(
  "Blue" = "#6D5782",
  "Yellow" = "#6D8257",
  "Red" = "#826D57",
  "Cyan" = "#576D82",
  "Green" = "#57826D",
  "Magenta" = "#82576D"
)

ggsci_db_iterm$"Embers Dark"$"bright" <- c(
  "Blue" = "#8A8075",
  "Yellow" = "#433B32",
  "Red" = "#828257",
  "Cyan" = "#825757",
  "Green" = "#2C2620",
  "Magenta" = "#BEB6AE"
)

ggsci_db_iterm$"ENCOM"$"normal" <- c(
  "Blue" = "#0081FF",
  "Yellow" = "#FFD000",
  "Red" = "#9F0000",
  "Cyan" = "#008B8B",
  "Green" = "#008B00",
  "Magenta" = "#BC00CA"
)

ggsci_db_iterm$"ENCOM"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#FFFF00",
  "Red" = "#FF0000",
  "Cyan" = "#00CDCD",
  "Green" = "#00EE00",
  "Magenta" = "#FF00FF"
)

ggsci_db_iterm$"Espresso Libre"$"normal" <- c(
  "Blue" = "#0066FF",
  "Yellow" = "#F0E53A",
  "Red" = "#CC0000",
  "Cyan" = "#06989A",
  "Green" = "#1A921C",
  "Magenta" = "#C5656B"
)

ggsci_db_iterm$"Espresso Libre"$"bright" <- c(
  "Blue" = "#43A8ED",
  "Yellow" = "#FFFB5C",
  "Red" = "#EF2929",
  "Cyan" = "#34E2E2",
  "Green" = "#9AFF87",
  "Magenta" = "#FF818A"
)

ggsci_db_iterm$"Espresso"$"normal" <- c(
  "Blue" = "#6C99BB",
  "Yellow" = "#FFC66D",
  "Red" = "#D25252",
  "Cyan" = "#BED6FF",
  "Green" = "#A5C261",
  "Magenta" = "#D197D9"
)

ggsci_db_iterm$"Espresso"$"bright" <- c(
  "Blue" = "#8AB7D9",
  "Yellow" = "#E1E48B",
  "Red" = "#F00C0C",
  "Cyan" = "#DCF4FF",
  "Green" = "#C2E075",
  "Magenta" = "#EFB5F7"
)

ggsci_db_iterm$"Everblush"$"normal" <- c(
  "Blue" = "#67B0E8",
  "Yellow" = "#E5C76B",
  "Red" = "#E57474",
  "Cyan" = "#6CBFBF",
  "Green" = "#8CCF7E",
  "Magenta" = "#C47FD5"
)

ggsci_db_iterm$"Everblush"$"bright" <- c(
  "Blue" = "#71BAF2",
  "Yellow" = "#F4D67A",
  "Red" = "#EF7E7E",
  "Cyan" = "#67CBE7",
  "Green" = "#96D988",
  "Magenta" = "#CE89DF"
)

ggsci_db_iterm$"Everforest Dark Hard"$"normal" <- c(
  "Blue" = "#7FBBB3",
  "Yellow" = "#DBBC7F",
  "Red" = "#E67E80",
  "Cyan" = "#83C092",
  "Green" = "#A7C080",
  "Magenta" = "#D699B6"
)

ggsci_db_iterm$"Everforest Dark Hard"$"bright" <- c(
  "Blue" = "#3A94C5",
  "Yellow" = "#DFA000",
  "Red" = "#F85552",
  "Cyan" = "#35A77C",
  "Green" = "#8DA101",
  "Magenta" = "#DF69BA"
)

ggsci_db_iterm$"Everforest Light Med"$"normal" <- c(
  "Blue" = "#7FBBB3",
  "Yellow" = "#DBBC7F",
  "Red" = "#E67E80",
  "Cyan" = "#83C092",
  "Green" = "#A7C080",
  "Magenta" = "#D699B6"
)

ggsci_db_iterm$"Everforest Light Med"$"bright" <- c(
  "Blue" = "#3A94C5",
  "Yellow" = "#DFA000",
  "Red" = "#F85552",
  "Cyan" = "#35A77C",
  "Green" = "#8DA101",
  "Magenta" = "#DF69BA"
)

ggsci_db_iterm$"Fahrenheit"$"normal" <- c(
  "Blue" = "#720102",
  "Yellow" = "#FECF75",
  "Red" = "#CDA074",
  "Cyan" = "#979797",
  "Green" = "#9E744D",
  "Magenta" = "#734C4D"
)

ggsci_db_iterm$"Fahrenheit"$"bright" <- c(
  "Blue" = "#CB4A05",
  "Yellow" = "#FD9F4D",
  "Red" = "#FECEA0",
  "Cyan" = "#FED04D",
  "Green" = "#CC734D",
  "Magenta" = "#4E739F"
)

ggsci_db_iterm$"Fairyfloss"$"normal" <- c(
  "Blue" = "#C2FFDF",
  "Yellow" = "#E6C000",
  "Red" = "#F92672",
  "Cyan" = "#C5A3FF",
  "Green" = "#C2FFDF",
  "Magenta" = "#FFB8D1"
)

ggsci_db_iterm$"Fairyfloss"$"bright" <- c(
  "Blue" = "#C2FFDF",
  "Yellow" = "#FFEA00",
  "Red" = "#FF857F",
  "Cyan" = "#C5A3FF",
  "Green" = "#C2FFDF",
  "Magenta" = "#FFB8D1"
)

ggsci_db_iterm$"Farmhouse Dark"$"normal" <- c(
  "Blue" = "#0049E6",
  "Yellow" = "#C87300",
  "Red" = "#BA0004",
  "Cyan" = "#1FB65C",
  "Green" = "#549D00",
  "Magenta" = "#9F1B61"
)

ggsci_db_iterm$"Farmhouse Dark"$"bright" <- c(
  "Blue" = "#006EFE",
  "Yellow" = "#EA9A00",
  "Red" = "#EB0009",
  "Cyan" = "#19E062",
  "Green" = "#7AC100",
  "Magenta" = "#BF3B7F"
)

ggsci_db_iterm$"Farmhouse Light"$"normal" <- c(
  "Blue" = "#092CCD",
  "Yellow" = "#A95600",
  "Red" = "#8D0003",
  "Cyan" = "#229256",
  "Green" = "#3A7D00",
  "Magenta" = "#820046"
)

ggsci_db_iterm$"Farmhouse Light"$"bright" <- c(
  "Blue" = "#006EFE",
  "Yellow" = "#EA9A00",
  "Red" = "#EB0009",
  "Cyan" = "#19E062",
  "Green" = "#7AC100",
  "Magenta" = "#BF3B7F"
)

ggsci_db_iterm$"Fideloper"$"normal" <- c(
  "Blue" = "#2E78C2",
  "Yellow" = "#B7AB9B",
  "Red" = "#CB1E2D",
  "Cyan" = "#309186",
  "Green" = "#EDB8AC",
  "Magenta" = "#C0236F"
)

ggsci_db_iterm$"Fideloper"$"bright" <- c(
  "Blue" = "#7C85C4",
  "Yellow" = "#A86671",
  "Red" = "#D4605A",
  "Cyan" = "#819090",
  "Green" = "#D4605A",
  "Magenta" = "#5C5DB2"
)

ggsci_db_iterm$"Firefly Traditional"$"normal" <- c(
  "Blue" = "#5A63FF",
  "Yellow" = "#AFAD24",
  "Red" = "#C23720",
  "Cyan" = "#33BBC7",
  "Green" = "#33BC26",
  "Magenta" = "#D53AD2"
)

ggsci_db_iterm$"Firefly Traditional"$"bright" <- c(
  "Blue" = "#838DFF",
  "Yellow" = "#ECEC16",
  "Red" = "#FF3B1E",
  "Cyan" = "#29F0F0",
  "Green" = "#2EE720",
  "Magenta" = "#FF5CFE"
)

ggsci_db_iterm$"Firefox Dev"$"normal" <- c(
  "Blue" = "#359DDF",
  "Yellow" = "#A57706",
  "Red" = "#E63853",
  "Cyan" = "#4B73A2",
  "Green" = "#5EB83C",
  "Magenta" = "#D75CFF"
)

ggsci_db_iterm$"Firefox Dev"$"bright" <- c(
  "Blue" = "#006FC0",
  "Yellow" = "#CD9409",
  "Red" = "#E1003F",
  "Cyan" = "#005794",
  "Green" = "#1D9000",
  "Magenta" = "#A200DA"
)

ggsci_db_iterm$"Firewatch"$"normal" <- c(
  "Blue" = "#4D89C4",
  "Yellow" = "#DFB563",
  "Red" = "#D95360",
  "Cyan" = "#44A8B6",
  "Green" = "#5AB977",
  "Magenta" = "#D55119"
)

ggsci_db_iterm$"Firewatch"$"bright" <- c(
  "Blue" = "#4C89C5",
  "Yellow" = "#DFB563",
  "Red" = "#D95360",
  "Cyan" = "#44A8B6",
  "Green" = "#5AB977",
  "Magenta" = "#D55119"
)

ggsci_db_iterm$"Fish Tank"$"normal" <- c(
  "Blue" = "#525FB8",
  "Yellow" = "#FECD5E",
  "Red" = "#C6004A",
  "Cyan" = "#968763",
  "Green" = "#ACF157",
  "Magenta" = "#986F82"
)

ggsci_db_iterm$"Fish Tank"$"bright" <- c(
  "Blue" = "#B2BEFA",
  "Yellow" = "#FEE6A9",
  "Red" = "#DA4B8A",
  "Cyan" = "#A5BD86",
  "Green" = "#DBFFA9",
  "Magenta" = "#FDA5CD"
)

ggsci_db_iterm$"Flat"$"normal" <- c(
  "Blue" = "#3167AC",
  "Yellow" = "#E58D11",
  "Red" = "#A82320",
  "Cyan" = "#2C9370",
  "Green" = "#32A548",
  "Magenta" = "#781AA0"
)

ggsci_db_iterm$"Flat"$"bright" <- c(
  "Blue" = "#3C7DD2",
  "Yellow" = "#E5BE0C",
  "Red" = "#D4312E",
  "Cyan" = "#35B387",
  "Green" = "#2D9440",
  "Magenta" = "#8230A7"
)

ggsci_db_iterm$"Flatland"$"normal" <- c(
  "Blue" = "#5096BE",
  "Yellow" = "#F4EF6D",
  "Red" = "#F18339",
  "Cyan" = "#D63865",
  "Green" = "#9FD364",
  "Magenta" = "#695ABC"
)

ggsci_db_iterm$"Flatland"$"bright" <- c(
  "Blue" = "#61B9D0",
  "Yellow" = "#FF8949",
  "Red" = "#D22A24",
  "Cyan" = "#D63865",
  "Green" = "#A7D42C",
  "Magenta" = "#695ABC"
)

ggsci_db_iterm$"Flexoki Dark"$"normal" <- c(
  "Blue" = "#4385BE",
  "Yellow" = "#D0A215",
  "Red" = "#D14D41",
  "Cyan" = "#3AA99F",
  "Green" = "#879A39",
  "Magenta" = "#CE5D97"
)

ggsci_db_iterm$"Flexoki Dark"$"bright" <- c(
  "Blue" = "#205EA6",
  "Yellow" = "#AD8301",
  "Red" = "#AF3029",
  "Cyan" = "#24837B",
  "Green" = "#66800B",
  "Magenta" = "#A02F6F"
)

ggsci_db_iterm$"Flexoki Light"$"normal" <- c(
  "Blue" = "#205EA6",
  "Yellow" = "#AD8301",
  "Red" = "#AF3029",
  "Cyan" = "#24837B",
  "Green" = "#66800B",
  "Magenta" = "#A02F6F"
)

ggsci_db_iterm$"Flexoki Light"$"bright" <- c(
  "Blue" = "#4385BE",
  "Yellow" = "#D0A215",
  "Red" = "#D14D41",
  "Cyan" = "#3AA99F",
  "Green" = "#879A39",
  "Magenta" = "#CE5D97"
)

ggsci_db_iterm$"Floraverse"$"normal" <- c(
  "Blue" = "#1D6DA1",
  "Yellow" = "#CD751C",
  "Red" = "#64002C",
  "Cyan" = "#42A38C",
  "Green" = "#5D731A",
  "Magenta" = "#B7077E"
)

ggsci_db_iterm$"Floraverse"$"bright" <- c(
  "Blue" = "#40A4CF",
  "Yellow" = "#FAC357",
  "Red" = "#D02063",
  "Cyan" = "#62CAA8",
  "Green" = "#B4CE59",
  "Magenta" = "#F12AAE"
)

ggsci_db_iterm$"Forest Blue"$"normal" <- c(
  "Blue" = "#8ED0CE",
  "Yellow" = "#1A8E63",
  "Red" = "#F8818E",
  "Cyan" = "#31658C",
  "Green" = "#92D3A2",
  "Magenta" = "#5E468C"
)

ggsci_db_iterm$"Forest Blue"$"bright" <- c(
  "Blue" = "#39A7A2",
  "Yellow" = "#30C85A",
  "Red" = "#FB3D66",
  "Cyan" = "#6096BF",
  "Green" = "#6BB48D",
  "Magenta" = "#7E62B3"
)

ggsci_db_iterm$"Framer"$"normal" <- c(
  "Blue" = "#00AAFF",
  "Yellow" = "#FFCC33",
  "Red" = "#FF5555",
  "Cyan" = "#88DDFF",
  "Green" = "#98EC65",
  "Magenta" = "#AA88FF"
)

ggsci_db_iterm$"Framer"$"bright" <- c(
  "Blue" = "#33BBFF",
  "Yellow" = "#FFD966",
  "Red" = "#FF8888",
  "Cyan" = "#BBECFF",
  "Green" = "#B6F292",
  "Magenta" = "#CEBBFF"
)

ggsci_db_iterm$"Front End Delight"$"normal" <- c(
  "Blue" = "#2C70B7",
  "Yellow" = "#FA771D",
  "Red" = "#F8511B",
  "Cyan" = "#3CA1A6",
  "Green" = "#565747",
  "Magenta" = "#F02E4F"
)

ggsci_db_iterm$"Front End Delight"$"bright" <- c(
  "Blue" = "#3393CA",
  "Yellow" = "#FDC325",
  "Red" = "#F74319",
  "Cyan" = "#4FBCE6",
  "Green" = "#74EC4C",
  "Magenta" = "#E75E4F"
)

ggsci_db_iterm$"Fun Forrest"$"normal" <- c(
  "Blue" = "#4699A3",
  "Yellow" = "#BE8A13",
  "Red" = "#D6262B",
  "Cyan" = "#DA8213",
  "Green" = "#919C00",
  "Magenta" = "#8D4331"
)

ggsci_db_iterm$"Fun Forrest"$"bright" <- c(
  "Blue" = "#7CC9CF",
  "Yellow" = "#FFCB1B",
  "Red" = "#E55A1C",
  "Cyan" = "#E6A96B",
  "Green" = "#BFC65A",
  "Magenta" = "#D26349"
)

ggsci_db_iterm$"Galaxy"$"normal" <- c(
  "Blue" = "#589DF6",
  "Yellow" = "#FEF02A",
  "Red" = "#F9555F",
  "Cyan" = "#1F9EE7",
  "Green" = "#21B089",
  "Magenta" = "#944D95"
)

ggsci_db_iterm$"Galaxy"$"bright" <- c(
  "Blue" = "#589DF6",
  "Yellow" = "#FFFF55",
  "Red" = "#FA8C8F",
  "Cyan" = "#3979BC",
  "Green" = "#35BB9A",
  "Magenta" = "#E75699"
)

ggsci_db_iterm$"Galizur"$"normal" <- c(
  "Blue" = "#2255CC",
  "Yellow" = "#CCAA22",
  "Red" = "#AA1122",
  "Cyan" = "#22BBDD",
  "Green" = "#33AA11",
  "Magenta" = "#7755AA"
)

ggsci_db_iterm$"Galizur"$"bright" <- c(
  "Blue" = "#3377FF",
  "Yellow" = "#FFDD33",
  "Red" = "#FF1133",
  "Cyan" = "#33DDFF",
  "Green" = "#33FF11",
  "Magenta" = "#AA77FF"
)

ggsci_db_iterm$"Ghostty Default Style Dark"$"normal" <- c(
  "Blue" = "#82A2BE",
  "Yellow" = "#F0C674",
  "Red" = "#CC6566",
  "Cyan" = "#8ABEB7",
  "Green" = "#B6BD68",
  "Magenta" = "#B294BB"
)

ggsci_db_iterm$"Ghostty Default Style Dark"$"bright" <- c(
  "Blue" = "#7AA6DA",
  "Yellow" = "#E7C547",
  "Red" = "#D54E53",
  "Cyan" = "#70C0B1",
  "Green" = "#B9CA4B",
  "Magenta" = "#C397D8"
)

ggsci_db_iterm$"GitHub Dark Colorblind"$"normal" <- c(
  "Blue" = "#58A6FF",
  "Yellow" = "#D29922",
  "Red" = "#EC8E2C",
  "Cyan" = "#39C5CF",
  "Green" = "#58A6FF",
  "Magenta" = "#BC8CFF"
)

ggsci_db_iterm$"GitHub Dark Colorblind"$"bright" <- c(
  "Blue" = "#79C0FF",
  "Yellow" = "#E3B341",
  "Red" = "#FDAC54",
  "Cyan" = "#56D4DD",
  "Green" = "#79C0FF",
  "Magenta" = "#D2A8FF"
)

ggsci_db_iterm$"GitHub Dark Default"$"normal" <- c(
  "Blue" = "#58A6FF",
  "Yellow" = "#D29922",
  "Red" = "#FF7B72",
  "Cyan" = "#39C5CF",
  "Green" = "#3FB950",
  "Magenta" = "#BC8CFF"
)

ggsci_db_iterm$"GitHub Dark Default"$"bright" <- c(
  "Blue" = "#79C0FF",
  "Yellow" = "#E3B341",
  "Red" = "#FFA198",
  "Cyan" = "#56D4DD",
  "Green" = "#56D364",
  "Magenta" = "#D2A8FF"
)

ggsci_db_iterm$"GitHub Dark Dimmed"$"normal" <- c(
  "Blue" = "#539BF5",
  "Yellow" = "#C69026",
  "Red" = "#F47067",
  "Cyan" = "#39C5CF",
  "Green" = "#57AB5A",
  "Magenta" = "#B083F0"
)

ggsci_db_iterm$"GitHub Dark Dimmed"$"bright" <- c(
  "Blue" = "#6CB6FF",
  "Yellow" = "#DAAA3F",
  "Red" = "#FF938A",
  "Cyan" = "#56D4DD",
  "Green" = "#6BC46D",
  "Magenta" = "#DCBDFB"
)

ggsci_db_iterm$"GitHub Dark High Contrast"$"normal" <- c(
  "Blue" = "#71B7FF",
  "Yellow" = "#F0B72F",
  "Red" = "#FF9492",
  "Cyan" = "#39C5CF",
  "Green" = "#26CD4D",
  "Magenta" = "#CB9EFF"
)

ggsci_db_iterm$"GitHub Dark High Contrast"$"bright" <- c(
  "Blue" = "#91CBFF",
  "Yellow" = "#F7C843",
  "Red" = "#FFB1AF",
  "Cyan" = "#56D4DD",
  "Green" = "#4AE168",
  "Magenta" = "#DBB7FF"
)

ggsci_db_iterm$"GitHub Dark"$"normal" <- c(
  "Blue" = "#6CA4F8",
  "Yellow" = "#E3B341",
  "Red" = "#F78166",
  "Cyan" = "#2B7489",
  "Green" = "#56D364",
  "Magenta" = "#DB61A2"
)

ggsci_db_iterm$"GitHub Dark"$"bright" <- c(
  "Blue" = "#6CA4F8",
  "Yellow" = "#E3B341",
  "Red" = "#F78166",
  "Cyan" = "#2B7489",
  "Green" = "#56D364",
  "Magenta" = "#DB61A2"
)

ggsci_db_iterm$"GitHub Light Colorblind"$"normal" <- c(
  "Blue" = "#0969DA",
  "Yellow" = "#4D2D00",
  "Red" = "#B35900",
  "Cyan" = "#1B7C83",
  "Green" = "#0550AE",
  "Magenta" = "#8250DF"
)

ggsci_db_iterm$"GitHub Light Colorblind"$"bright" <- c(
  "Blue" = "#218BFF",
  "Yellow" = "#633C01",
  "Red" = "#8A4600",
  "Cyan" = "#3192AA",
  "Green" = "#0969DA",
  "Magenta" = "#A475F9"
)

ggsci_db_iterm$"GitHub Light Default"$"normal" <- c(
  "Blue" = "#0969DA",
  "Yellow" = "#4D2D00",
  "Red" = "#CF222E",
  "Cyan" = "#1B7C83",
  "Green" = "#116329",
  "Magenta" = "#8250DF"
)

ggsci_db_iterm$"GitHub Light Default"$"bright" <- c(
  "Blue" = "#218BFF",
  "Yellow" = "#633C01",
  "Red" = "#A40E26",
  "Cyan" = "#3192AA",
  "Green" = "#1A7F37",
  "Magenta" = "#A475F9"
)

ggsci_db_iterm$"GitHub Light High Contrast"$"normal" <- c(
  "Blue" = "#0349B4",
  "Yellow" = "#3F2200",
  "Red" = "#A0111F",
  "Cyan" = "#1B7C83",
  "Green" = "#024C1A",
  "Magenta" = "#622CBC"
)

ggsci_db_iterm$"GitHub Light High Contrast"$"bright" <- c(
  "Blue" = "#1168E3",
  "Yellow" = "#4E2C00",
  "Red" = "#86061D",
  "Cyan" = "#3192AA",
  "Green" = "#055D20",
  "Magenta" = "#844AE7"
)

ggsci_db_iterm$"GitHub"$"normal" <- c(
  "Blue" = "#003E8A",
  "Yellow" = "#F8EEC7",
  "Red" = "#970B16",
  "Cyan" = "#89D1EC",
  "Green" = "#07962A",
  "Magenta" = "#E94691"
)

ggsci_db_iterm$"GitHub"$"bright" <- c(
  "Blue" = "#2E6CBA",
  "Yellow" = "#F1D007",
  "Red" = "#DE0000",
  "Cyan" = "#1CFAFE",
  "Green" = "#87D5A2",
  "Magenta" = "#FFA29F"
)

ggsci_db_iterm$"GitLab Dark Grey"$"normal" <- c(
  "Blue" = "#7FB6ED",
  "Yellow" = "#D99530",
  "Red" = "#F57F6C",
  "Cyan" = "#32C5D2",
  "Green" = "#52B87A",
  "Magenta" = "#F88AAF"
)

ggsci_db_iterm$"GitLab Dark Grey"$"bright" <- c(
  "Blue" = "#498DD1",
  "Yellow" = "#E9BE74",
  "Red" = "#FCB5AA",
  "Cyan" = "#5EDEE3",
  "Green" = "#91D4A8",
  "Magenta" = "#FCACC5"
)

ggsci_db_iterm$"GitLab Dark"$"normal" <- c(
  "Blue" = "#7FB6ED",
  "Yellow" = "#D99530",
  "Red" = "#F57F6C",
  "Cyan" = "#32C5D2",
  "Green" = "#52B87A",
  "Magenta" = "#F88AAF"
)

ggsci_db_iterm$"GitLab Dark"$"bright" <- c(
  "Blue" = "#498DD1",
  "Yellow" = "#E9BE74",
  "Red" = "#FCB5AA",
  "Cyan" = "#5EDEE3",
  "Green" = "#91D4A8",
  "Magenta" = "#FCACC5"
)

ggsci_db_iterm$"GitLab Light"$"normal" <- c(
  "Blue" = "#006CD8",
  "Yellow" = "#AF551D",
  "Red" = "#A31700",
  "Cyan" = "#00798A",
  "Green" = "#0A7F3D",
  "Magenta" = "#583CAC"
)

ggsci_db_iterm$"GitLab Light"$"bright" <- c(
  "Blue" = "#006CD8",
  "Yellow" = "#AF551D",
  "Red" = "#A31700",
  "Cyan" = "#00798A",
  "Green" = "#0A7F3D",
  "Magenta" = "#583CAC"
)

ggsci_db_iterm$"Glacier"$"normal" <- c(
  "Blue" = "#1F5872",
  "Yellow" = "#FB9435",
  "Red" = "#BD0F2F",
  "Cyan" = "#778397",
  "Green" = "#35A770",
  "Magenta" = "#BD2523"
)

ggsci_db_iterm$"Glacier"$"bright" <- c(
  "Blue" = "#2A8BC1",
  "Yellow" = "#FDDF6E",
  "Red" = "#BD0F2F",
  "Cyan" = "#A0B6D3",
  "Green" = "#49E998",
  "Magenta" = "#EA4727"
)

ggsci_db_iterm$"Grape"$"normal" <- c(
  "Blue" = "#487DF4",
  "Yellow" = "#8DDC20",
  "Red" = "#ED2261",
  "Cyan" = "#3BDEED",
  "Green" = "#1FA91B",
  "Magenta" = "#8D35C9"
)

ggsci_db_iterm$"Grape"$"bright" <- c(
  "Blue" = "#A9BCEC",
  "Yellow" = "#B2DC87",
  "Red" = "#F0729A",
  "Cyan" = "#9DE3EB",
  "Green" = "#53AA5E",
  "Magenta" = "#AD81C2"
)

ggsci_db_iterm$"Grass"$"normal" <- c(
  "Blue" = "#0000A3",
  "Yellow" = "#E7B000",
  "Red" = "#BB0000",
  "Cyan" = "#00BBBB",
  "Green" = "#00BB00",
  "Magenta" = "#950062"
)

ggsci_db_iterm$"Grass"$"bright" <- c(
  "Blue" = "#0000BB",
  "Yellow" = "#E7B000",
  "Red" = "#BB0000",
  "Cyan" = "#55FFFF",
  "Green" = "#00BB00",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Grey Green"$"normal" <- c(
  "Blue" = "#00DEFF",
  "Yellow" = "#F1FF01",
  "Red" = "#FE1414",
  "Cyan" = "#00FFBC",
  "Green" = "#74FF00",
  "Magenta" = "#FF00F0"
)

ggsci_db_iterm$"Grey Green"$"bright" <- c(
  "Blue" = "#00AFFF",
  "Yellow" = "#FFD100",
  "Red" = "#FF3939",
  "Cyan" = "#00FFD3",
  "Green" = "#00FF44",
  "Magenta" = "#FF008A"
)

ggsci_db_iterm$"Gruber Darker"$"normal" <- c(
  "Blue" = "#92A7CB",
  "Yellow" = "#FFDB00",
  "Red" = "#FF0A36",
  "Cyan" = "#90AA9E",
  "Green" = "#42DC00",
  "Magenta" = "#A095CB"
)

ggsci_db_iterm$"Gruber Darker"$"bright" <- c(
  "Blue" = "#92A7CB",
  "Yellow" = "#FFDB00",
  "Red" = "#FF3851",
  "Cyan" = "#90AA9E",
  "Green" = "#42DC00",
  "Magenta" = "#AFAFDA"
)

ggsci_db_iterm$"Gruvbox Dark Hard"$"normal" <- c(
  "Blue" = "#458588",
  "Yellow" = "#D79921",
  "Red" = "#CC241D",
  "Cyan" = "#689D6A",
  "Green" = "#98971A",
  "Magenta" = "#B16286"
)

ggsci_db_iterm$"Gruvbox Dark Hard"$"bright" <- c(
  "Blue" = "#83A598",
  "Yellow" = "#FABD2F",
  "Red" = "#FB4934",
  "Cyan" = "#8EC07C",
  "Green" = "#B8BB26",
  "Magenta" = "#D3869B"
)

ggsci_db_iterm$"Gruvbox Dark"$"normal" <- c(
  "Blue" = "#458588",
  "Yellow" = "#D79921",
  "Red" = "#CC241D",
  "Cyan" = "#689D6A",
  "Green" = "#98971A",
  "Magenta" = "#B16286"
)

ggsci_db_iterm$"Gruvbox Dark"$"bright" <- c(
  "Blue" = "#83A598",
  "Yellow" = "#FABD2F",
  "Red" = "#FB4934",
  "Cyan" = "#8EC07C",
  "Green" = "#B8BB26",
  "Magenta" = "#D3869B"
)

ggsci_db_iterm$"Gruvbox Light Hard"$"normal" <- c(
  "Blue" = "#458588",
  "Yellow" = "#D79921",
  "Red" = "#CC241D",
  "Cyan" = "#689D6A",
  "Green" = "#98971A",
  "Magenta" = "#B16286"
)

ggsci_db_iterm$"Gruvbox Light Hard"$"bright" <- c(
  "Blue" = "#076678",
  "Yellow" = "#B57614",
  "Red" = "#9D0006",
  "Cyan" = "#427B58",
  "Green" = "#79740E",
  "Magenta" = "#8F3F71"
)

ggsci_db_iterm$"Gruvbox Light"$"normal" <- c(
  "Blue" = "#458588",
  "Yellow" = "#D79921",
  "Red" = "#CC241D",
  "Cyan" = "#689D6A",
  "Green" = "#98971A",
  "Magenta" = "#B16286"
)

ggsci_db_iterm$"Gruvbox Light"$"bright" <- c(
  "Blue" = "#076678",
  "Yellow" = "#B57614",
  "Red" = "#9D0006",
  "Cyan" = "#427B58",
  "Green" = "#79740E",
  "Magenta" = "#8F3F71"
)

ggsci_db_iterm$"Gruvbox Material Dark"$"normal" <- c(
  "Blue" = "#7DAEA3",
  "Yellow" = "#D8A657",
  "Red" = "#EA6962",
  "Cyan" = "#89B482",
  "Green" = "#A9B665",
  "Magenta" = "#D3869B"
)

ggsci_db_iterm$"Gruvbox Material Dark"$"bright" <- c(
  "Blue" = "#7DAEA3",
  "Yellow" = "#D8A657",
  "Red" = "#EA6962",
  "Cyan" = "#89B482",
  "Green" = "#A9B665",
  "Magenta" = "#D3869B"
)

ggsci_db_iterm$"Gruvbox Material Light"$"normal" <- c(
  "Blue" = "#45707A",
  "Yellow" = "#B47109",
  "Red" = "#C14A4A",
  "Cyan" = "#4C7A5D",
  "Green" = "#6C782E",
  "Magenta" = "#945E80"
)

ggsci_db_iterm$"Gruvbox Material Light"$"bright" <- c(
  "Blue" = "#45707A",
  "Yellow" = "#B47109",
  "Red" = "#C14A4A",
  "Cyan" = "#4C7A5D",
  "Green" = "#6C782E",
  "Magenta" = "#945E80"
)

ggsci_db_iterm$"Gruvbox Material"$"normal" <- c(
  "Blue" = "#6DA3EC",
  "Yellow" = "#EECF75",
  "Red" = "#EA6926",
  "Cyan" = "#FE9D6E",
  "Green" = "#C1D041",
  "Magenta" = "#FD9BC1"
)

ggsci_db_iterm$"Gruvbox Material"$"bright" <- c(
  "Blue" = "#2C86FF",
  "Yellow" = "#EECF75",
  "Red" = "#D3573B",
  "Cyan" = "#92A5DF",
  "Green" = "#C1D041",
  "Magenta" = "#FD9BC1"
)

ggsci_db_iterm$"Guezwhoz"$"normal" <- c(
  "Blue" = "#5AA0D6",
  "Yellow" = "#B7D074",
  "Red" = "#E85181",
  "Cyan" = "#58D6CE",
  "Green" = "#7AD694",
  "Magenta" = "#9A90E0"
)

ggsci_db_iterm$"Guezwhoz"$"bright" <- c(
  "Blue" = "#64B2ED",
  "Yellow" = "#D1ED85",
  "Red" = "#E85181",
  "Cyan" = "#61EDE4",
  "Green" = "#AFD7AF",
  "Magenta" = "#A398ED"
)

ggsci_db_iterm$"Hacktober"$"normal" <- c(
  "Blue" = "#206EC5",
  "Yellow" = "#D08949",
  "Red" = "#B34538",
  "Cyan" = "#AC9166",
  "Green" = "#587744",
  "Magenta" = "#864651"
)

ggsci_db_iterm$"Hacktober"$"bright" <- c(
  "Blue" = "#5389C5",
  "Yellow" = "#C75A22",
  "Red" = "#B33323",
  "Cyan" = "#EBC587",
  "Green" = "#42824A",
  "Magenta" = "#E795A5"
)

ggsci_db_iterm$"Hardcore"$"normal" <- c(
  "Blue" = "#66D9EF",
  "Yellow" = "#FD971F",
  "Red" = "#F92672",
  "Cyan" = "#5E7175",
  "Green" = "#A6E22E",
  "Magenta" = "#9E6FFE"
)

ggsci_db_iterm$"Hardcore"$"bright" <- c(
  "Blue" = "#66D9EF",
  "Yellow" = "#E6DB74",
  "Red" = "#FF669D",
  "Cyan" = "#A3BABF",
  "Green" = "#BEED5F",
  "Magenta" = "#9E6FFE"
)

ggsci_db_iterm$"Harper"$"normal" <- c(
  "Blue" = "#489E48",
  "Yellow" = "#D6DA25",
  "Red" = "#F8B63F",
  "Cyan" = "#F5BFD7",
  "Green" = "#7FB5E1",
  "Magenta" = "#B296C6"
)

ggsci_db_iterm$"Harper"$"bright" <- c(
  "Blue" = "#489E48",
  "Yellow" = "#D6DA25",
  "Red" = "#F8B63F",
  "Cyan" = "#F5BFD7",
  "Green" = "#7FB5E1",
  "Magenta" = "#B296C6"
)

ggsci_db_iterm$"Havn Daggry"$"normal" <- c(
  "Blue" = "#3A577D",
  "Yellow" = "#BE6B00",
  "Red" = "#985248",
  "Cyan" = "#925780",
  "Green" = "#577159",
  "Magenta" = "#7C5C97"
)

ggsci_db_iterm$"Havn Daggry"$"bright" <- c(
  "Blue" = "#6089C0",
  "Yellow" = "#FEB234",
  "Red" = "#CC4A35",
  "Cyan" = "#AA869D",
  "Green" = "#719679",
  "Magenta" = "#7D7396"
)

ggsci_db_iterm$"Havn Skumring"$"normal" <- c(
  "Blue" = "#596CF7",
  "Yellow" = "#F8B330",
  "Red" = "#EA563E",
  "Cyan" = "#D588C1",
  "Green" = "#6EAD7B",
  "Magenta" = "#7C719E"
)

ggsci_db_iterm$"Havn Skumring"$"bright" <- c(
  "Blue" = "#5186CB",
  "Yellow" = "#EAC58C",
  "Red" = "#D17264",
  "Cyan" = "#D17AB6",
  "Green" = "#8C9E8F",
  "Magenta" = "#9B7CEE"
)

ggsci_db_iterm$"HaX0R Blue"$"normal" <- c(
  "Blue" = "#10B6FF",
  "Yellow" = "#10B6FF",
  "Red" = "#10B6FF",
  "Cyan" = "#10B6FF",
  "Green" = "#10B6FF",
  "Magenta" = "#10B6FF"
)

ggsci_db_iterm$"HaX0R Blue"$"bright" <- c(
  "Blue" = "#00B3F7",
  "Yellow" = "#00B3F7",
  "Red" = "#00B3F7",
  "Cyan" = "#00B3F7",
  "Green" = "#00B3F7",
  "Magenta" = "#00B3F7"
)

ggsci_db_iterm$"HaX0R Gr33N"$"normal" <- c(
  "Blue" = "#15D00D",
  "Yellow" = "#15D00D",
  "Red" = "#15D00D",
  "Cyan" = "#15D00D",
  "Green" = "#15D00D",
  "Magenta" = "#15D00D"
)

ggsci_db_iterm$"HaX0R Gr33N"$"bright" <- c(
  "Blue" = "#19E20E",
  "Yellow" = "#19E20E",
  "Red" = "#19E20E",
  "Cyan" = "#19E20E",
  "Green" = "#19E20E",
  "Magenta" = "#19E20E"
)

ggsci_db_iterm$"HaX0R R3D"$"normal" <- c(
  "Blue" = "#B00D0D",
  "Yellow" = "#B00D0D",
  "Red" = "#B00D0D",
  "Cyan" = "#B00D0D",
  "Green" = "#B00D0D",
  "Magenta" = "#B00D0D"
)

ggsci_db_iterm$"HaX0R R3D"$"bright" <- c(
  "Blue" = "#FF1010",
  "Yellow" = "#FF1010",
  "Red" = "#FF1111",
  "Cyan" = "#FF1010",
  "Green" = "#FF1010",
  "Magenta" = "#FF1010"
)

ggsci_db_iterm$"Heeler"$"normal" <- c(
  "Blue" = "#5BA5F2",
  "Yellow" = "#F4CE65",
  "Red" = "#E44C2E",
  "Cyan" = "#FF9763",
  "Green" = "#BDD100",
  "Magenta" = "#FF95C2"
)

ggsci_db_iterm$"Heeler"$"bright" <- c(
  "Blue" = "#0088FF",
  "Yellow" = "#F4CE65",
  "Red" = "#E44C2E",
  "Cyan" = "#8DA6E4",
  "Green" = "#BDD100",
  "Magenta" = "#FF95C2"
)

ggsci_db_iterm$"Highway"$"normal" <- c(
  "Blue" = "#006BB3",
  "Yellow" = "#FFCB3E",
  "Red" = "#D00E18",
  "Cyan" = "#384564",
  "Green" = "#138034",
  "Magenta" = "#6B2775"
)

ggsci_db_iterm$"Highway"$"bright" <- c(
  "Blue" = "#4FC2FD",
  "Yellow" = "#FFF120",
  "Red" = "#F07E18",
  "Cyan" = "#5D504A",
  "Green" = "#B1D130",
  "Magenta" = "#DE0071"
)

ggsci_db_iterm$"Hipster Green"$"normal" <- c(
  "Blue" = "#246EB2",
  "Yellow" = "#BFBF00",
  "Red" = "#B6214A",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Hipster Green"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#86A93E",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Hivacruz"$"normal" <- c(
  "Blue" = "#3D8FD1",
  "Yellow" = "#C08B30",
  "Red" = "#C94922",
  "Cyan" = "#22A2C9",
  "Green" = "#AC9739",
  "Magenta" = "#6679CC"
)

ggsci_db_iterm$"Hivacruz"$"bright" <- c(
  "Blue" = "#898EA4",
  "Yellow" = "#5E6687",
  "Red" = "#C76B29",
  "Cyan" = "#9C637A",
  "Green" = "#73AD43",
  "Magenta" = "#DFE2F1"
)

ggsci_db_iterm$"Homebrew"$"normal" <- c(
  "Blue" = "#0000B2",
  "Yellow" = "#999900",
  "Red" = "#990000",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Homebrew"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#00D900",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Hopscotch.256"$"normal" <- c(
  "Blue" = "#1290BF",
  "Yellow" = "#FDCC59",
  "Red" = "#DD464C",
  "Cyan" = "#149B93",
  "Green" = "#8FC13E",
  "Magenta" = "#C85E7C"
)

ggsci_db_iterm$"Hopscotch.256"$"bright" <- c(
  "Blue" = "#1290BF",
  "Yellow" = "#FDCC59",
  "Red" = "#DD464C",
  "Cyan" = "#149B93",
  "Green" = "#8FC13E",
  "Magenta" = "#C85E7C"
)

ggsci_db_iterm$"Hopscotch"$"normal" <- c(
  "Blue" = "#1290BF",
  "Yellow" = "#FDCC59",
  "Red" = "#DD464C",
  "Cyan" = "#149B93",
  "Green" = "#8FC13E",
  "Magenta" = "#C85E7C"
)

ggsci_db_iterm$"Hopscotch"$"bright" <- c(
  "Blue" = "#989498",
  "Yellow" = "#5C545B",
  "Red" = "#FD8B19",
  "Cyan" = "#B33508",
  "Green" = "#433B42",
  "Magenta" = "#D5D3D5"
)

ggsci_db_iterm$"Horizon Bright"$"normal" <- c(
  "Blue" = "#00BEDD",
  "Yellow" = "#FFB38F",
  "Red" = "#FC4777",
  "Cyan" = "#00E7E5",
  "Green" = "#00D793",
  "Magenta" = "#FF58B1"
)

ggsci_db_iterm$"Horizon Bright"$"bright" <- c(
  "Blue" = "#00C9E2",
  "Yellow" = "#FFC0A2",
  "Red" = "#FE5F87",
  "Cyan" = "#07E9E8",
  "Green" = "#00DEA0",
  "Magenta" = "#FF6CBA"
)

ggsci_db_iterm$"Horizon"$"normal" <- c(
  "Blue" = "#26BBD9",
  "Yellow" = "#FAB795",
  "Red" = "#E95678",
  "Cyan" = "#59E1E3",
  "Green" = "#29D398",
  "Magenta" = "#EE64AC"
)

ggsci_db_iterm$"Horizon"$"bright" <- c(
  "Blue" = "#3FC4DE",
  "Yellow" = "#FBC3A7",
  "Red" = "#EC6A88",
  "Cyan" = "#6BE4E6",
  "Green" = "#3FDAA4",
  "Magenta" = "#F075B5"
)

ggsci_db_iterm$"Hurtado"$"normal" <- c(
  "Blue" = "#496487",
  "Yellow" = "#FBE74A",
  "Red" = "#FF1B00",
  "Cyan" = "#86E9FE",
  "Green" = "#A5E055",
  "Magenta" = "#FD5FF1"
)

ggsci_db_iterm$"Hurtado"$"bright" <- c(
  "Blue" = "#89BEFF",
  "Yellow" = "#FBE84A",
  "Red" = "#D51D00",
  "Cyan" = "#86EAFE",
  "Green" = "#A5DF55",
  "Magenta" = "#C001C1"
)

ggsci_db_iterm$"Hybrid"$"normal" <- c(
  "Blue" = "#6E90B0",
  "Yellow" = "#E4B55E",
  "Red" = "#B84D51",
  "Cyan" = "#7FBFB4",
  "Green" = "#B3BF5A",
  "Magenta" = "#A17EAC"
)

ggsci_db_iterm$"Hybrid"$"bright" <- c(
  "Blue" = "#4B6B88",
  "Yellow" = "#E58A50",
  "Red" = "#8D2E32",
  "Cyan" = "#4D7B74",
  "Green" = "#798431",
  "Magenta" = "#6E5079"
)

ggsci_db_iterm$"IBM 5153 CGA (Black)"$"normal" <- c(
  "Blue" = "#0000C4",
  "Yellow" = "#C47E00",
  "Red" = "#C40000",
  "Cyan" = "#00C4C4",
  "Green" = "#00C400",
  "Magenta" = "#C400C4"
)

ggsci_db_iterm$"IBM 5153 CGA (Black)"$"bright" <- c(
  "Blue" = "#4E4EDC",
  "Yellow" = "#F3F34E",
  "Red" = "#DC4E4E",
  "Cyan" = "#4EF3F3",
  "Green" = "#4EDC4E",
  "Magenta" = "#F34EF3"
)

ggsci_db_iterm$"IBM 5153 CGA"$"normal" <- c(
  "Blue" = "#3333DB",
  "Yellow" = "#DB9833",
  "Red" = "#DB3333",
  "Cyan" = "#33DBDB",
  "Green" = "#33DB33",
  "Magenta" = "#DB33DB"
)

ggsci_db_iterm$"IBM 5153 CGA"$"bright" <- c(
  "Blue" = "#4E4EDC",
  "Yellow" = "#F3F34E",
  "Red" = "#DC4E4E",
  "Cyan" = "#4EF3F3",
  "Green" = "#4EDC4E",
  "Magenta" = "#F34EF3"
)

ggsci_db_iterm$"IC Green PPL"$"normal" <- c(
  "Blue" = "#2EC3B9",
  "Yellow" = "#76A831",
  "Red" = "#FF2736",
  "Cyan" = "#3CA078",
  "Green" = "#41A638",
  "Magenta" = "#50A096"
)

ggsci_db_iterm$"IC Green PPL"$"bright" <- c(
  "Blue" = "#2EFAEB",
  "Yellow" = "#DAFA87",
  "Red" = "#B4FA5C",
  "Cyan" = "#3CFAC8",
  "Green" = "#AEFB86",
  "Magenta" = "#50FAFA"
)

ggsci_db_iterm$"IC Orange PPL"$"normal" <- c(
  "Blue" = "#BD6D00",
  "Yellow" = "#CAAF00",
  "Red" = "#C13900",
  "Cyan" = "#F79500",
  "Green" = "#A4A900",
  "Magenta" = "#FC5E00"
)

ggsci_db_iterm$"IC Orange PPL"$"bright" <- c(
  "Blue" = "#FFBE55",
  "Yellow" = "#FFE36E",
  "Red" = "#FF8C68",
  "Cyan" = "#C69752",
  "Green" = "#F6FF40",
  "Magenta" = "#FC874F"
)

ggsci_db_iterm$"Iceberg Dark"$"normal" <- c(
  "Blue" = "#84A0C6",
  "Yellow" = "#E2A478",
  "Red" = "#E27878",
  "Cyan" = "#89B8C2",
  "Green" = "#B4BE82",
  "Magenta" = "#A093C7"
)

ggsci_db_iterm$"Iceberg Dark"$"bright" <- c(
  "Blue" = "#91ACD1",
  "Yellow" = "#E9B189",
  "Red" = "#E98989",
  "Cyan" = "#95C4CE",
  "Green" = "#C0CA8E",
  "Magenta" = "#ADA0D3"
)

ggsci_db_iterm$"Iceberg Light"$"normal" <- c(
  "Blue" = "#2D539E",
  "Yellow" = "#C57339",
  "Red" = "#CC517A",
  "Cyan" = "#3F83A6",
  "Green" = "#668E3D",
  "Magenta" = "#7759B4"
)

ggsci_db_iterm$"Iceberg Light"$"bright" <- c(
  "Blue" = "#22478E",
  "Yellow" = "#B6662D",
  "Red" = "#CC3768",
  "Cyan" = "#327698",
  "Green" = "#598030",
  "Magenta" = "#6845AD"
)

ggsci_db_iterm$"Idea"$"normal" <- c(
  "Blue" = "#437EE7",
  "Yellow" = "#CCB444",
  "Red" = "#FC5256",
  "Cyan" = "#248887",
  "Green" = "#98B61C",
  "Magenta" = "#9D74B0"
)

ggsci_db_iterm$"Idea"$"bright" <- c(
  "Blue" = "#6C9CED",
  "Yellow" = "#FFFF0B",
  "Red" = "#FC7072",
  "Cyan" = "#248887",
  "Green" = "#98B61C",
  "Magenta" = "#FC7EFF"
)

ggsci_db_iterm$"Idle Toes"$"normal" <- c(
  "Blue" = "#4099FF",
  "Yellow" = "#FFC66D",
  "Red" = "#D25252",
  "Cyan" = "#BED6FF",
  "Green" = "#7FE173",
  "Magenta" = "#F680FF"
)

ggsci_db_iterm$"Idle Toes"$"bright" <- c(
  "Blue" = "#5EB7F7",
  "Yellow" = "#FFE48B",
  "Red" = "#F07070",
  "Cyan" = "#DCF4FF",
  "Green" = "#9DFF91",
  "Magenta" = "#FF9DFF"
)

ggsci_db_iterm$"IR Black"$"normal" <- c(
  "Blue" = "#96CAFE",
  "Yellow" = "#FFFEB7",
  "Red" = "#FA6C60",
  "Cyan" = "#C6C5FE",
  "Green" = "#A8FF60",
  "Magenta" = "#FA73FD"
)

ggsci_db_iterm$"IR Black"$"bright" <- c(
  "Blue" = "#B5DCFF",
  "Yellow" = "#FFFFCC",
  "Red" = "#FCB6B0",
  "Cyan" = "#E0E0FE",
  "Green" = "#CFFFAB",
  "Magenta" = "#FB9CFE"
)

ggsci_db_iterm$"IRIX Console"$"normal" <- c(
  "Blue" = "#0739E2",
  "Yellow" = "#C29D28",
  "Red" = "#D42426",
  "Cyan" = "#4497DF",
  "Green" = "#37A327",
  "Magenta" = "#911F9C"
)

ggsci_db_iterm$"IRIX Console"$"bright" <- c(
  "Blue" = "#4079FF",
  "Yellow" = "#F9F2A7",
  "Red" = "#F34F59",
  "Cyan" = "#6ED7D7",
  "Green" = "#45C731",
  "Magenta" = "#C31BA2"
)

ggsci_db_iterm$"IRIX Terminal"$"normal" <- c(
  "Blue" = "#0004FF",
  "Yellow" = "#FFFF44",
  "Red" = "#FF2B1E",
  "Cyan" = "#56FFFF",
  "Green" = "#57FF3D",
  "Magenta" = "#FF2CFF"
)

ggsci_db_iterm$"IRIX Terminal"$"bright" <- c(
  "Blue" = "#FFFF44",
  "Yellow" = "#FFFC72",
  "Red" = "#FFFF44",
  "Cyan" = "#FFFF44",
  "Green" = "#FFFF44",
  "Magenta" = "#FFFF44"
)

ggsci_db_iterm$"iTerm2 Dark Background"$"normal" <- c(
  "Blue" = "#0225C7",
  "Yellow" = "#C7C400",
  "Red" = "#C91B00",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"iTerm2 Dark Background"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"iTerm2 Default"$"normal" <- c(
  "Blue" = "#2225C4",
  "Yellow" = "#C7C400",
  "Red" = "#C91B00",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"iTerm2 Default"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"iTerm2 Light Background"$"normal" <- c(
  "Blue" = "#0225C7",
  "Yellow" = "#C7C400",
  "Red" = "#C91B00",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"iTerm2 Light Background"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"iTerm2 Pastel Dark Background"$"normal" <- c(
  "Blue" = "#A5D5FE",
  "Yellow" = "#FFFDC3",
  "Red" = "#FF8373",
  "Cyan" = "#D1D1FE",
  "Green" = "#B4FB73",
  "Magenta" = "#FF90FE"
)

ggsci_db_iterm$"iTerm2 Pastel Dark Background"$"bright" <- c(
  "Blue" = "#C2E3FF",
  "Yellow" = "#FFFED5",
  "Red" = "#FFC4BE",
  "Cyan" = "#E6E6FE",
  "Green" = "#D6FCBA",
  "Magenta" = "#FFB2FE"
)

ggsci_db_iterm$"iTerm2 Smoooooth"$"normal" <- c(
  "Blue" = "#2744C7",
  "Yellow" = "#C7C400",
  "Red" = "#B43C2A",
  "Cyan" = "#00C5C7",
  "Green" = "#00C200",
  "Magenta" = "#C040BE"
)

ggsci_db_iterm$"iTerm2 Smoooooth"$"bright" <- c(
  "Blue" = "#A7ABF2",
  "Yellow" = "#ECE100",
  "Red" = "#DD7975",
  "Cyan" = "#60FDFF",
  "Green" = "#58E790",
  "Magenta" = "#E17EE1"
)

ggsci_db_iterm$"iTerm2 Solarized Dark"$"normal" <- c(
  "Blue" = "#268BD2",
  "Yellow" = "#B58900",
  "Red" = "#DC322F",
  "Cyan" = "#2AA198",
  "Green" = "#859900",
  "Magenta" = "#D33682"
)

ggsci_db_iterm$"iTerm2 Solarized Dark"$"bright" <- c(
  "Blue" = "#839496",
  "Yellow" = "#657B83",
  "Red" = "#CB4B16",
  "Cyan" = "#93A1A1",
  "Green" = "#586E75",
  "Magenta" = "#6C71C4"
)

ggsci_db_iterm$"iTerm2 Solarized Light"$"normal" <- c(
  "Blue" = "#268BD2",
  "Yellow" = "#B58900",
  "Red" = "#DC322F",
  "Cyan" = "#2AA198",
  "Green" = "#859900",
  "Magenta" = "#D33682"
)

ggsci_db_iterm$"iTerm2 Solarized Light"$"bright" <- c(
  "Blue" = "#839496",
  "Yellow" = "#657B83",
  "Red" = "#CB4B16",
  "Cyan" = "#93A1A1",
  "Green" = "#586E75",
  "Magenta" = "#6C71C4"
)

ggsci_db_iterm$"iTerm2 Tango Dark"$"normal" <- c(
  "Blue" = "#427AB3",
  "Yellow" = "#CFAE00",
  "Red" = "#D81E00",
  "Cyan" = "#00A7AA",
  "Green" = "#5EA702",
  "Magenta" = "#89658E"
)

ggsci_db_iterm$"iTerm2 Tango Dark"$"bright" <- c(
  "Blue" = "#84B0D8",
  "Yellow" = "#FDEB61",
  "Red" = "#F54235",
  "Cyan" = "#37E6E8",
  "Green" = "#99E343",
  "Magenta" = "#BC94B7"
)

ggsci_db_iterm$"iTerm2 Tango Light"$"normal" <- c(
  "Blue" = "#427AB3",
  "Yellow" = "#CFAE00",
  "Red" = "#D81E00",
  "Cyan" = "#00A7AA",
  "Green" = "#5EA702",
  "Magenta" = "#89658E"
)

ggsci_db_iterm$"iTerm2 Tango Light"$"bright" <- c(
  "Blue" = "#84B0D8",
  "Yellow" = "#FDEB61",
  "Red" = "#F54235",
  "Cyan" = "#37E6E8",
  "Green" = "#99E343",
  "Magenta" = "#BC94B7"
)

ggsci_db_iterm$"Jackie Brown"$"normal" <- c(
  "Blue" = "#246EB2",
  "Yellow" = "#BEBF00",
  "Red" = "#EF5734",
  "Cyan" = "#00ACEE",
  "Green" = "#2BAF2B",
  "Magenta" = "#D05EC1"
)

ggsci_db_iterm$"Jackie Brown"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#86A93E",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Japanesque"$"normal" <- c(
  "Blue" = "#4C9AD4",
  "Yellow" = "#E9B32A",
  "Red" = "#CF3F61",
  "Cyan" = "#389AAD",
  "Green" = "#7BB75B",
  "Magenta" = "#A57FC4"
)

ggsci_db_iterm$"Japanesque"$"bright" <- c(
  "Blue" = "#135979",
  "Yellow" = "#78592F",
  "Red" = "#D18FA6",
  "Cyan" = "#76BBCA",
  "Green" = "#767F2C",
  "Magenta" = "#604291"
)

ggsci_db_iterm$"Jellybeans"$"normal" <- c(
  "Blue" = "#97BEDC",
  "Yellow" = "#FFBA7B",
  "Red" = "#E27373",
  "Cyan" = "#00988E",
  "Green" = "#94B979",
  "Magenta" = "#E1C0FA"
)

ggsci_db_iterm$"Jellybeans"$"bright" <- c(
  "Blue" = "#B1D8F6",
  "Yellow" = "#FFDCA0",
  "Red" = "#FFA1A1",
  "Cyan" = "#1AB2A8",
  "Green" = "#BDDEAB",
  "Magenta" = "#FBDAFF"
)

ggsci_db_iterm$"JetBrains Darcula"$"normal" <- c(
  "Blue" = "#4581EB",
  "Yellow" = "#C2C300",
  "Red" = "#FA5355",
  "Cyan" = "#33C2C1",
  "Green" = "#126E00",
  "Magenta" = "#FA54FF"
)

ggsci_db_iterm$"JetBrains Darcula"$"bright" <- c(
  "Blue" = "#6D9DF1",
  "Yellow" = "#FFFF00",
  "Red" = "#FB7172",
  "Cyan" = "#60D3D1",
  "Green" = "#67FF4F",
  "Magenta" = "#FB82FF"
)

ggsci_db_iterm$"Jubi"$"normal" <- c(
  "Blue" = "#576EA6",
  "Yellow" = "#6EBFC0",
  "Red" = "#CF7B98",
  "Cyan" = "#75A7D2",
  "Green" = "#90A94B",
  "Magenta" = "#BC4F68"
)

ggsci_db_iterm$"Jubi"$"bright" <- c(
  "Blue" = "#8C9FCD",
  "Yellow" = "#87E9EA",
  "Red" = "#DE90AB",
  "Cyan" = "#B7C9EF",
  "Green" = "#BCDD61",
  "Magenta" = "#E16C87"
)

ggsci_db_iterm$"Kanagawa Dragon"$"normal" <- c(
  "Blue" = "#8BA4B0",
  "Yellow" = "#C4B28A",
  "Red" = "#C4746E",
  "Cyan" = "#8EA4A2",
  "Green" = "#8A9A7B",
  "Magenta" = "#A292A3"
)

ggsci_db_iterm$"Kanagawa Dragon"$"bright" <- c(
  "Blue" = "#7FB4CA",
  "Yellow" = "#E6C384",
  "Red" = "#E46876",
  "Cyan" = "#7AA89F",
  "Green" = "#87A987",
  "Magenta" = "#938AA9"
)

ggsci_db_iterm$"Kanagawa Wave"$"normal" <- c(
  "Blue" = "#7E9CD8",
  "Yellow" = "#C0A36E",
  "Red" = "#C34043",
  "Cyan" = "#6A9589",
  "Green" = "#76946A",
  "Magenta" = "#957FB8"
)

ggsci_db_iterm$"Kanagawa Wave"$"bright" <- c(
  "Blue" = "#7FB4CA",
  "Yellow" = "#E6C384",
  "Red" = "#E82424",
  "Cyan" = "#7AA89F",
  "Green" = "#98BB6C",
  "Magenta" = "#938AA9"
)

ggsci_db_iterm$"Kanagawabones"$"normal" <- c(
  "Blue" = "#7EB3C9",
  "Yellow" = "#E5C283",
  "Red" = "#E46A78",
  "Cyan" = "#7EB3C9",
  "Green" = "#98BC6D",
  "Magenta" = "#957FB8"
)

ggsci_db_iterm$"Kanagawabones"$"bright" <- c(
  "Blue" = "#7BC2DF",
  "Yellow" = "#F1C982",
  "Red" = "#EC818C",
  "Cyan" = "#7BC2DF",
  "Green" = "#9EC967",
  "Magenta" = "#A98FD2"
)

ggsci_db_iterm$"Kibble"$"normal" <- c(
  "Blue" = "#3449D1",
  "Yellow" = "#D8E30E",
  "Red" = "#C70031",
  "Cyan" = "#0798AB",
  "Green" = "#29CF13",
  "Magenta" = "#8400FF"
)

ggsci_db_iterm$"Kibble"$"bright" <- c(
  "Blue" = "#97A4F7",
  "Yellow" = "#F3F79E",
  "Red" = "#F01578",
  "Cyan" = "#68F2E0",
  "Green" = "#6CE05C",
  "Magenta" = "#C495F0"
)

ggsci_db_iterm$"Kitty Default"$"normal" <- c(
  "Blue" = "#0D73CC",
  "Yellow" = "#CECB00",
  "Red" = "#CC0403",
  "Cyan" = "#0DCDCD",
  "Green" = "#19CB00",
  "Magenta" = "#CB1ED1"
)

ggsci_db_iterm$"Kitty Default"$"bright" <- c(
  "Blue" = "#1A8FFF",
  "Yellow" = "#FFFD00",
  "Red" = "#F2201F",
  "Cyan" = "#14FFFF",
  "Green" = "#23FD00",
  "Magenta" = "#FD28FF"
)

ggsci_db_iterm$"Kitty Low Contrast"$"normal" <- c(
  "Blue" = "#0D73CC",
  "Yellow" = "#CECB00",
  "Red" = "#CC0403",
  "Cyan" = "#0DCDCD",
  "Green" = "#19CB00",
  "Magenta" = "#CB1ED1"
)

ggsci_db_iterm$"Kitty Low Contrast"$"bright" <- c(
  "Blue" = "#1A8FFF",
  "Yellow" = "#FFFD00",
  "Red" = "#F2201F",
  "Cyan" = "#14FFFF",
  "Green" = "#23FD00",
  "Magenta" = "#FD28FF"
)

ggsci_db_iterm$"Kolorit"$"normal" <- c(
  "Blue" = "#5DB4EE",
  "Yellow" = "#E8E562",
  "Red" = "#FF5B82",
  "Cyan" = "#57E9EB",
  "Green" = "#47D7A1",
  "Magenta" = "#DA6CDA"
)

ggsci_db_iterm$"Kolorit"$"bright" <- c(
  "Blue" = "#5DB4EE",
  "Yellow" = "#E8E562",
  "Red" = "#FF5B82",
  "Cyan" = "#57E9EB",
  "Green" = "#47D7A1",
  "Magenta" = "#DA6CDA"
)

ggsci_db_iterm$"Konsolas"$"normal" <- c(
  "Blue" = "#2323A5",
  "Yellow" = "#EBAE1F",
  "Red" = "#AA1717",
  "Cyan" = "#42B0C8",
  "Green" = "#18B218",
  "Magenta" = "#AD1EDC"
)

ggsci_db_iterm$"Konsolas"$"bright" <- c(
  "Blue" = "#4B4BFF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF4141",
  "Cyan" = "#69FFFF",
  "Green" = "#5FFF5F",
  "Magenta" = "#FF54FF"
)

ggsci_db_iterm$"Kurokula"$"normal" <- c(
  "Blue" = "#5C91DD",
  "Yellow" = "#E1B917",
  "Red" = "#C35A52",
  "Cyan" = "#867268",
  "Green" = "#78B3A9",
  "Magenta" = "#8B79A6"
)

ggsci_db_iterm$"Kurokula"$"bright" <- c(
  "Blue" = "#90DBFF",
  "Yellow" = "#FFF700",
  "Red" = "#FFC34C",
  "Cyan" = "#FFCDB6",
  "Green" = "#AFFFA5",
  "Magenta" = "#AD93FF"
)

ggsci_db_iterm$"Lab Fox"$"normal" <- c(
  "Blue" = "#DB3B21",
  "Yellow" = "#FCA121",
  "Red" = "#FC6D26",
  "Cyan" = "#6E49CB",
  "Green" = "#3EB383",
  "Magenta" = "#380D75"
)

ggsci_db_iterm$"Lab Fox"$"bright" <- c(
  "Blue" = "#DB501F",
  "Yellow" = "#FCA013",
  "Red" = "#FF6517",
  "Cyan" = "#7D53E7",
  "Green" = "#53EAA8",
  "Magenta" = "#441090"
)

ggsci_db_iterm$"Laser"$"normal" <- c(
  "Blue" = "#FED300",
  "Yellow" = "#09B4BD",
  "Red" = "#FF8373",
  "Cyan" = "#D1D1FE",
  "Green" = "#B4FB73",
  "Magenta" = "#FF90FE"
)

ggsci_db_iterm$"Laser"$"bright" <- c(
  "Blue" = "#F92883",
  "Yellow" = "#FFFED5",
  "Red" = "#FFC4BE",
  "Cyan" = "#E6E7FE",
  "Green" = "#D6FCBA",
  "Magenta" = "#FFB2FE"
)

ggsci_db_iterm$"Later This Evening"$"normal" <- c(
  "Blue" = "#A0BAD6",
  "Yellow" = "#E5D289",
  "Red" = "#D45A60",
  "Cyan" = "#91BFB7",
  "Green" = "#AFBA67",
  "Magenta" = "#C092D6"
)

ggsci_db_iterm$"Later This Evening"$"bright" <- c(
  "Blue" = "#6699D6",
  "Yellow" = "#E5BE39",
  "Red" = "#D3232F",
  "Cyan" = "#5FC0AE",
  "Green" = "#AABB39",
  "Magenta" = "#AB53D6"
)

ggsci_db_iterm$"Lavandula"$"normal" <- c(
  "Blue" = "#4F4A7F",
  "Yellow" = "#7F6F49",
  "Red" = "#7D1625",
  "Cyan" = "#58777F",
  "Green" = "#337E6F",
  "Magenta" = "#5A3F7F"
)

ggsci_db_iterm$"Lavandula"$"bright" <- c(
  "Blue" = "#8E87E0",
  "Yellow" = "#E0C386",
  "Red" = "#E05167",
  "Cyan" = "#9AD4E0",
  "Green" = "#52E0C4",
  "Magenta" = "#A776E0"
)

ggsci_db_iterm$"Light Owl"$"normal" <- c(
  "Blue" = "#288ED7",
  "Yellow" = "#E0AF02",
  "Red" = "#DE3D3B",
  "Cyan" = "#2AA298",
  "Green" = "#08916A",
  "Magenta" = "#D6438A"
)

ggsci_db_iterm$"Light Owl"$"bright" <- c(
  "Blue" = "#288ED7",
  "Yellow" = "#DAAA01",
  "Red" = "#DE3D3B",
  "Cyan" = "#2AA298",
  "Green" = "#08916A",
  "Magenta" = "#D6438A"
)

ggsci_db_iterm$"Liquid Carbon Transparent"$"normal" <- c(
  "Blue" = "#0099CC",
  "Yellow" = "#CCAC00",
  "Red" = "#FF3030",
  "Cyan" = "#7AC4CC",
  "Green" = "#559A70",
  "Magenta" = "#CC69C8"
)

ggsci_db_iterm$"Liquid Carbon Transparent"$"bright" <- c(
  "Blue" = "#0099CC",
  "Yellow" = "#CCAC00",
  "Red" = "#FF3030",
  "Cyan" = "#7AC4CC",
  "Green" = "#559A70",
  "Magenta" = "#CC69C8"
)

ggsci_db_iterm$"Liquid Carbon"$"normal" <- c(
  "Blue" = "#0099CC",
  "Yellow" = "#CCAC00",
  "Red" = "#FF3030",
  "Cyan" = "#7AC4CC",
  "Green" = "#559A70",
  "Magenta" = "#CC69C8"
)

ggsci_db_iterm$"Liquid Carbon"$"bright" <- c(
  "Blue" = "#0099CC",
  "Yellow" = "#CCAC00",
  "Red" = "#FF3030",
  "Cyan" = "#7AC4CC",
  "Green" = "#559A70",
  "Magenta" = "#CC69C8"
)

ggsci_db_iterm$"Lovelace"$"normal" <- c(
  "Blue" = "#8897F4",
  "Yellow" = "#F2A272",
  "Red" = "#F37F97",
  "Cyan" = "#79E6F3",
  "Green" = "#5ADECD",
  "Magenta" = "#C574DD"
)

ggsci_db_iterm$"Lovelace"$"bright" <- c(
  "Blue" = "#556FFF",
  "Yellow" = "#FF8037",
  "Red" = "#FF4971",
  "Cyan" = "#3FDCEE",
  "Green" = "#18E3C8",
  "Magenta" = "#B043D1"
)

ggsci_db_iterm$"Man Page"$"normal" <- c(
  "Blue" = "#0000B2",
  "Yellow" = "#999900",
  "Red" = "#CC0000",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Man Page"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#00D900",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Mariana"$"normal" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#F9AE58",
  "Red" = "#EC5F66",
  "Cyan" = "#5FB4B4",
  "Green" = "#99C794",
  "Magenta" = "#C695C6"
)

ggsci_db_iterm$"Mariana"$"bright" <- c(
  "Blue" = "#85ADD6",
  "Yellow" = "#FAC761",
  "Red" = "#F97B58",
  "Cyan" = "#82C4C4",
  "Green" = "#ACD1A8",
  "Magenta" = "#D8B6D8"
)

ggsci_db_iterm$"Material Dark"$"normal" <- c(
  "Blue" = "#134EB2",
  "Yellow" = "#F6981E",
  "Red" = "#B7141F",
  "Cyan" = "#0E717C",
  "Green" = "#457B24",
  "Magenta" = "#560088"
)

ggsci_db_iterm$"Material Dark"$"bright" <- c(
  "Blue" = "#54A4F3",
  "Yellow" = "#FFEA2E",
  "Red" = "#E83B3F",
  "Cyan" = "#26BBD1",
  "Green" = "#7ABA3A",
  "Magenta" = "#AA4DBC"
)

ggsci_db_iterm$"Material Darker"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF5370",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Material Darker"$"bright" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF5370",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Material Design Colors"$"normal" <- c(
  "Blue" = "#37B6FF",
  "Yellow" = "#FED032",
  "Red" = "#FC3841",
  "Cyan" = "#59FFD1",
  "Green" = "#5CF19E",
  "Magenta" = "#FC226E"
)

ggsci_db_iterm$"Material Design Colors"$"bright" <- c(
  "Blue" = "#70CFFF",
  "Yellow" = "#FEE16C",
  "Red" = "#FC746D",
  "Cyan" = "#9AFFE6",
  "Green" = "#ADF7BE",
  "Magenta" = "#FC669B"
)

ggsci_db_iterm$"Material Ocean"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF5370",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Material Ocean"$"bright" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#FF5370",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Material"$"normal" <- c(
  "Blue" = "#134EB2",
  "Yellow" = "#F6981E",
  "Red" = "#B7141F",
  "Cyan" = "#0E717C",
  "Green" = "#457B24",
  "Magenta" = "#560088"
)

ggsci_db_iterm$"Material"$"bright" <- c(
  "Blue" = "#54A4F3",
  "Yellow" = "#FFEA2E",
  "Red" = "#E83B3F",
  "Cyan" = "#26BBD1",
  "Green" = "#7ABA3A",
  "Magenta" = "#AA4DBC"
)

ggsci_db_iterm$"Mathias"$"normal" <- c(
  "Blue" = "#C48DFF",
  "Yellow" = "#FC951E",
  "Red" = "#E52222",
  "Cyan" = "#67D9F0",
  "Green" = "#A6E32D",
  "Magenta" = "#FA2573"
)

ggsci_db_iterm$"Mathias"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Matrix"$"normal" <- c(
  "Blue" = "#3F5242",
  "Yellow" = "#FFD700",
  "Red" = "#23755A",
  "Cyan" = "#50B45A",
  "Green" = "#82D967",
  "Magenta" = "#409931"
)

ggsci_db_iterm$"Matrix"$"bright" <- c(
  "Blue" = "#4F7E7E",
  "Yellow" = "#FAFF00",
  "Red" = "#2FC079",
  "Cyan" = "#C1FF8A",
  "Green" = "#90D762",
  "Magenta" = "#11FF25"
)

ggsci_db_iterm$"Medallion"$"normal" <- c(
  "Blue" = "#616BB0",
  "Yellow" = "#D3BD26",
  "Red" = "#B64C00",
  "Cyan" = "#916C25",
  "Green" = "#7C8B16",
  "Magenta" = "#8C5A90"
)

ggsci_db_iterm$"Medallion"$"bright" <- c(
  "Blue" = "#ACB8FF",
  "Yellow" = "#FFE54A",
  "Red" = "#FF9149",
  "Cyan" = "#FFBC51",
  "Green" = "#B2CA3B",
  "Magenta" = "#FFA0FF"
)

ggsci_db_iterm$"Melange Dark"$"normal" <- c(
  "Blue" = "#7F91B2",
  "Yellow" = "#E49B5D",
  "Red" = "#BD8183",
  "Cyan" = "#7B9695",
  "Green" = "#78997A",
  "Magenta" = "#B380B0"
)

ggsci_db_iterm$"Melange Dark"$"bright" <- c(
  "Blue" = "#A3A9CE",
  "Yellow" = "#EBC06D",
  "Red" = "#D47766",
  "Cyan" = "#89B3B6",
  "Green" = "#85B695",
  "Magenta" = "#CF9BC2"
)

ggsci_db_iterm$"Melange Light"$"normal" <- c(
  "Blue" = "#7892BD",
  "Yellow" = "#BC5C00",
  "Red" = "#C77B8B",
  "Cyan" = "#739797",
  "Green" = "#6E9B72",
  "Magenta" = "#BE79BB"
)

ggsci_db_iterm$"Melange Light"$"bright" <- c(
  "Blue" = "#465AA4",
  "Yellow" = "#A06D00",
  "Red" = "#BF0021",
  "Cyan" = "#3D6568",
  "Green" = "#3A684A",
  "Magenta" = "#904180"
)

ggsci_db_iterm$"Mellifluous"$"normal" <- c(
  "Blue" = "#A8A1BE",
  "Yellow" = "#CBAA89",
  "Red" = "#D29393",
  "Cyan" = "#C0AF8C",
  "Green" = "#B3B393",
  "Magenta" = "#B39FB0"
)

ggsci_db_iterm$"Mellifluous"$"bright" <- c(
  "Blue" = "#5A6599",
  "Yellow" = "#A6794C",
  "Red" = "#C95954",
  "Cyan" = "#74A39E",
  "Green" = "#828040",
  "Magenta" = "#9C6995"
)

ggsci_db_iterm$"Mellow"$"normal" <- c(
  "Blue" = "#ACA1CF",
  "Yellow" = "#E6B99D",
  "Red" = "#F5A191",
  "Cyan" = "#EA83A5",
  "Green" = "#90B99F",
  "Magenta" = "#E29ECA"
)

ggsci_db_iterm$"Mellow"$"bright" <- c(
  "Blue" = "#B9AEDA",
  "Yellow" = "#F0C5A9",
  "Red" = "#FFAE9F",
  "Cyan" = "#F591B2",
  "Green" = "#9DC6AC",
  "Magenta" = "#ECAAD6"
)

ggsci_db_iterm$"Miasma"$"normal" <- c(
  "Blue" = "#78824B",
  "Yellow" = "#B36D43",
  "Red" = "#685742",
  "Cyan" = "#C9A554",
  "Green" = "#5F875F",
  "Magenta" = "#BB7744"
)

ggsci_db_iterm$"Miasma"$"bright" <- c(
  "Blue" = "#78824B",
  "Yellow" = "#B36D43",
  "Red" = "#685742",
  "Cyan" = "#C9A554",
  "Green" = "#5F875F",
  "Magenta" = "#BB7744"
)

ggsci_db_iterm$"Midnight In Mojave"$"normal" <- c(
  "Blue" = "#0A84FF",
  "Yellow" = "#FFD60A",
  "Red" = "#FF453A",
  "Cyan" = "#5AC8FA",
  "Green" = "#32D74B",
  "Magenta" = "#BF5AF2"
)

ggsci_db_iterm$"Midnight In Mojave"$"bright" <- c(
  "Blue" = "#0A84FF",
  "Yellow" = "#FFD60A",
  "Red" = "#FF453A",
  "Cyan" = "#5AC8FA",
  "Green" = "#32D74B",
  "Magenta" = "#BF5AF2"
)

ggsci_db_iterm$"Mirage"$"normal" <- c(
  "Blue" = "#7FB5FF",
  "Yellow" = "#FFD700",
  "Red" = "#FF9999",
  "Cyan" = "#21C7A8",
  "Green" = "#85CC95",
  "Magenta" = "#DDB3FF"
)

ggsci_db_iterm$"Mirage"$"bright" <- c(
  "Blue" = "#7FB5FF",
  "Yellow" = "#FFD700",
  "Red" = "#FF9999",
  "Cyan" = "#85CC95",
  "Green" = "#85CC95",
  "Magenta" = "#DDB3FF"
)

ggsci_db_iterm$"Misterioso"$"normal" <- c(
  "Blue" = "#338F86",
  "Yellow" = "#FFAD29",
  "Red" = "#FF4242",
  "Cyan" = "#23D7D7",
  "Green" = "#74AF68",
  "Magenta" = "#9414E6"
)

ggsci_db_iterm$"Misterioso"$"bright" <- c(
  "Blue" = "#23D7D7",
  "Yellow" = "#FFB929",
  "Red" = "#FF3242",
  "Cyan" = "#00EDE1",
  "Green" = "#74CD68",
  "Magenta" = "#FF37FF"
)

ggsci_db_iterm$"Molokai"$"normal" <- c(
  "Blue" = "#1080D0",
  "Yellow" = "#DFD460",
  "Red" = "#FA2573",
  "Cyan" = "#43A8D0",
  "Green" = "#98E123",
  "Magenta" = "#8700FF"
)

ggsci_db_iterm$"Molokai"$"bright" <- c(
  "Blue" = "#00AFFF",
  "Yellow" = "#FFF26D",
  "Red" = "#F6669D",
  "Cyan" = "#51CEFF",
  "Green" = "#B1E05F",
  "Magenta" = "#AF87FF"
)

ggsci_db_iterm$"Mona Lisa"$"normal" <- c(
  "Blue" = "#515C5D",
  "Yellow" = "#C36E28",
  "Red" = "#9B291C",
  "Cyan" = "#588056",
  "Green" = "#636232",
  "Magenta" = "#9B1D29"
)

ggsci_db_iterm$"Mona Lisa"$"bright" <- c(
  "Blue" = "#9EB2B4",
  "Yellow" = "#FF9566",
  "Red" = "#FF4331",
  "Cyan" = "#8ACD8F",
  "Green" = "#B4B264",
  "Magenta" = "#FF5B6A"
)

ggsci_db_iterm$"Monokai Classic"$"normal" <- c(
  "Blue" = "#FD971F",
  "Yellow" = "#E6DB74",
  "Red" = "#F92672",
  "Cyan" = "#66D9EF",
  "Green" = "#A6E22E",
  "Magenta" = "#AE81FF"
)

ggsci_db_iterm$"Monokai Classic"$"bright" <- c(
  "Blue" = "#FD971F",
  "Yellow" = "#E6DB74",
  "Red" = "#F92672",
  "Cyan" = "#66D9EF",
  "Green" = "#A6E22E",
  "Magenta" = "#AE81FF"
)

ggsci_db_iterm$"Monokai Pro Light Sun"$"normal" <- c(
  "Blue" = "#D4572B",
  "Yellow" = "#B16803",
  "Red" = "#CE4770",
  "Cyan" = "#2473B6",
  "Green" = "#218871",
  "Magenta" = "#6851A2"
)

ggsci_db_iterm$"Monokai Pro Light Sun"$"bright" <- c(
  "Blue" = "#D4572B",
  "Yellow" = "#B16803",
  "Red" = "#CE4770",
  "Cyan" = "#2473B6",
  "Green" = "#218871",
  "Magenta" = "#6851A2"
)

ggsci_db_iterm$"Monokai Pro Light"$"normal" <- c(
  "Blue" = "#E16032",
  "Yellow" = "#CC7A0A",
  "Red" = "#E14775",
  "Cyan" = "#1C8CA8",
  "Green" = "#269D69",
  "Magenta" = "#7058BE"
)

ggsci_db_iterm$"Monokai Pro Light"$"bright" <- c(
  "Blue" = "#E16032",
  "Yellow" = "#CC7A0A",
  "Red" = "#E14775",
  "Cyan" = "#1C8CA8",
  "Green" = "#269D69",
  "Magenta" = "#7058BE"
)

ggsci_db_iterm$"Monokai Pro Machine"$"normal" <- c(
  "Blue" = "#FFB270",
  "Yellow" = "#FFED72",
  "Red" = "#FF6D7E",
  "Cyan" = "#7CD5F1",
  "Green" = "#A2E57B",
  "Magenta" = "#BAA0F8"
)

ggsci_db_iterm$"Monokai Pro Machine"$"bright" <- c(
  "Blue" = "#FFB270",
  "Yellow" = "#FFED72",
  "Red" = "#FF6D7E",
  "Cyan" = "#7CD5F1",
  "Green" = "#A2E57B",
  "Magenta" = "#BAA0F8"
)

ggsci_db_iterm$"Monokai Pro Octagon"$"normal" <- c(
  "Blue" = "#FF9B5E",
  "Yellow" = "#FFD76D",
  "Red" = "#FF657A",
  "Cyan" = "#9CD1BB",
  "Green" = "#BAD761",
  "Magenta" = "#C39AC9"
)

ggsci_db_iterm$"Monokai Pro Octagon"$"bright" <- c(
  "Blue" = "#FF9B5E",
  "Yellow" = "#FFD76D",
  "Red" = "#FF657A",
  "Cyan" = "#9CD1BB",
  "Green" = "#BAD761",
  "Magenta" = "#C39AC9"
)

ggsci_db_iterm$"Monokai Pro Ristretto"$"normal" <- c(
  "Blue" = "#F38D70",
  "Yellow" = "#F9CC6C",
  "Red" = "#FD6883",
  "Cyan" = "#85DACC",
  "Green" = "#ADDA78",
  "Magenta" = "#A8A9EB"
)

ggsci_db_iterm$"Monokai Pro Ristretto"$"bright" <- c(
  "Blue" = "#F38D70",
  "Yellow" = "#F9CC6C",
  "Red" = "#FD6883",
  "Cyan" = "#85DACC",
  "Green" = "#ADDA78",
  "Magenta" = "#A8A9EB"
)

ggsci_db_iterm$"Monokai Pro Spectrum"$"normal" <- c(
  "Blue" = "#FD9353",
  "Yellow" = "#FCE566",
  "Red" = "#FC618D",
  "Cyan" = "#5AD4E6",
  "Green" = "#7BD88F",
  "Magenta" = "#948AE3"
)

ggsci_db_iterm$"Monokai Pro Spectrum"$"bright" <- c(
  "Blue" = "#FD9353",
  "Yellow" = "#FCE566",
  "Red" = "#FC618D",
  "Cyan" = "#5AD4E6",
  "Green" = "#7BD88F",
  "Magenta" = "#948AE3"
)

ggsci_db_iterm$"Monokai Pro"$"normal" <- c(
  "Blue" = "#FC9867",
  "Yellow" = "#FFD866",
  "Red" = "#FF6188",
  "Cyan" = "#78DCE8",
  "Green" = "#A9DC76",
  "Magenta" = "#AB9DF2"
)

ggsci_db_iterm$"Monokai Pro"$"bright" <- c(
  "Blue" = "#FC9867",
  "Yellow" = "#FFD866",
  "Red" = "#FF6188",
  "Cyan" = "#78DCE8",
  "Green" = "#A9DC76",
  "Magenta" = "#AB9DF2"
)

ggsci_db_iterm$"Monokai Remastered"$"normal" <- c(
  "Blue" = "#9D65FF",
  "Yellow" = "#FD971F",
  "Red" = "#F4005F",
  "Cyan" = "#58D1EB",
  "Green" = "#98E024",
  "Magenta" = "#F4005F"
)

ggsci_db_iterm$"Monokai Remastered"$"bright" <- c(
  "Blue" = "#9D65FF",
  "Yellow" = "#E0D561",
  "Red" = "#F4005F",
  "Cyan" = "#58D1EB",
  "Green" = "#98E024",
  "Magenta" = "#F4005F"
)

ggsci_db_iterm$"Monokai Soda"$"normal" <- c(
  "Blue" = "#9D65FF",
  "Yellow" = "#FA8419",
  "Red" = "#F4005F",
  "Cyan" = "#58D1EB",
  "Green" = "#98E024",
  "Magenta" = "#F4005F"
)

ggsci_db_iterm$"Monokai Soda"$"bright" <- c(
  "Blue" = "#9D65FF",
  "Yellow" = "#E0D561",
  "Red" = "#F4005F",
  "Cyan" = "#58D1EB",
  "Green" = "#98E024",
  "Magenta" = "#F4005F"
)

ggsci_db_iterm$"Monokai Vivid"$"normal" <- c(
  "Blue" = "#0443FF",
  "Yellow" = "#FFF30A",
  "Red" = "#FA2934",
  "Cyan" = "#01B6ED",
  "Green" = "#98E123",
  "Magenta" = "#F800F8"
)

ggsci_db_iterm$"Monokai Vivid"$"bright" <- c(
  "Blue" = "#0443FF",
  "Yellow" = "#FFF26D",
  "Red" = "#F6669D",
  "Cyan" = "#51CEFF",
  "Green" = "#B1E05F",
  "Magenta" = "#F200F6"
)

ggsci_db_iterm$"Moonfly"$"normal" <- c(
  "Blue" = "#80A0FF",
  "Yellow" = "#E3C78A",
  "Red" = "#FF5454",
  "Cyan" = "#79DAC8",
  "Green" = "#8CC85F",
  "Magenta" = "#CF87E8"
)

ggsci_db_iterm$"Moonfly"$"bright" <- c(
  "Blue" = "#74B2FF",
  "Yellow" = "#C6C684",
  "Red" = "#FF5189",
  "Cyan" = "#85DC85",
  "Green" = "#36C692",
  "Magenta" = "#AE81FF"
)

ggsci_db_iterm$"N0Tch2K"$"normal" <- c(
  "Blue" = "#657D3E",
  "Yellow" = "#A98051",
  "Red" = "#A95551",
  "Cyan" = "#C9C9C9",
  "Green" = "#666666",
  "Magenta" = "#767676"
)

ggsci_db_iterm$"N0Tch2K"$"bright" <- c(
  "Blue" = "#98BD5E",
  "Yellow" = "#A99175",
  "Red" = "#A97775",
  "Cyan" = "#DCDCDC",
  "Green" = "#8C8C8C",
  "Magenta" = "#A3A3A3"
)

ggsci_db_iterm$"Neobones Dark"$"normal" <- c(
  "Blue" = "#8190D4",
  "Yellow" = "#B77E64",
  "Red" = "#DE6E7C",
  "Cyan" = "#66A5AD",
  "Green" = "#90FF6B",
  "Magenta" = "#B279A7"
)

ggsci_db_iterm$"Neobones Dark"$"bright" <- c(
  "Blue" = "#92A0E2",
  "Yellow" = "#D68C67",
  "Red" = "#E8838F",
  "Cyan" = "#65B8C1",
  "Green" = "#A0FF85",
  "Magenta" = "#CF86C1"
)

ggsci_db_iterm$"Neobones Light"$"normal" <- c(
  "Blue" = "#286486",
  "Yellow" = "#944927",
  "Red" = "#A8334C",
  "Cyan" = "#3B8992",
  "Green" = "#567A30",
  "Magenta" = "#88507D"
)

ggsci_db_iterm$"Neobones Light"$"bright" <- c(
  "Blue" = "#1D5573",
  "Yellow" = "#803D1C",
  "Red" = "#94253E",
  "Cyan" = "#2B747C",
  "Green" = "#3F5A22",
  "Magenta" = "#7B3B70"
)

ggsci_db_iterm$"Neon"$"normal" <- c(
  "Blue" = "#0208CB",
  "Yellow" = "#FFFC7E",
  "Red" = "#FF3045",
  "Cyan" = "#00FFFC",
  "Green" = "#5FFA74",
  "Magenta" = "#F924E7"
)

ggsci_db_iterm$"Neon"$"bright" <- c(
  "Blue" = "#3C40CB",
  "Yellow" = "#FFFD96",
  "Red" = "#FF5A5A",
  "Cyan" = "#88FFFE",
  "Green" = "#75FF88",
  "Magenta" = "#F15BE5"
)

ggsci_db_iterm$"Neopolitan"$"normal" <- c(
  "Blue" = "#253B76",
  "Yellow" = "#FBDE2D",
  "Red" = "#800000",
  "Cyan" = "#8DA6CE",
  "Green" = "#61CE3C",
  "Magenta" = "#FF0080"
)

ggsci_db_iterm$"Neopolitan"$"bright" <- c(
  "Blue" = "#253B76",
  "Yellow" = "#FBDE2D",
  "Red" = "#800000",
  "Cyan" = "#8DA6CE",
  "Green" = "#61CE3C",
  "Magenta" = "#FF0080"
)

ggsci_db_iterm$"Neutron"$"normal" <- c(
  "Blue" = "#6A7C93",
  "Yellow" = "#DEB566",
  "Red" = "#B54036",
  "Cyan" = "#3F94A8",
  "Green" = "#5AB977",
  "Magenta" = "#A4799D"
)

ggsci_db_iterm$"Neutron"$"bright" <- c(
  "Blue" = "#6A7C93",
  "Yellow" = "#DEB566",
  "Red" = "#B54036",
  "Cyan" = "#3F94A8",
  "Green" = "#5AB977",
  "Magenta" = "#A4799D"
)

ggsci_db_iterm$"Night Lion V1"$"normal" <- c(
  "Blue" = "#276BD8",
  "Yellow" = "#F3F167",
  "Red" = "#BB0000",
  "Cyan" = "#00DADF",
  "Green" = "#5FDE8F",
  "Magenta" = "#BB00BB"
)

ggsci_db_iterm$"Night Lion V1"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Night Lion V2"$"normal" <- c(
  "Blue" = "#64D0F0",
  "Yellow" = "#F3F167",
  "Red" = "#BB0000",
  "Cyan" = "#00DADF",
  "Green" = "#04F623",
  "Magenta" = "#CE6FDB"
)

ggsci_db_iterm$"Night Lion V2"$"bright" <- c(
  "Blue" = "#62CBE8",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#00CCD8",
  "Green" = "#7DF71D",
  "Magenta" = "#FF9BF5"
)

ggsci_db_iterm$"Night Owl"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#ADDB67",
  "Red" = "#EF5350",
  "Cyan" = "#21C7A8",
  "Green" = "#22DA6E",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Night Owl"$"bright" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFEB95",
  "Red" = "#EF5350",
  "Cyan" = "#7FDBCA",
  "Green" = "#22DA6E",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Night Owlish Light"$"normal" <- c(
  "Blue" = "#4876D6",
  "Yellow" = "#DAAA01",
  "Red" = "#D3423E",
  "Cyan" = "#08916A",
  "Green" = "#2AA298",
  "Magenta" = "#403F53"
)

ggsci_db_iterm$"Night Owlish Light"$"bright" <- c(
  "Blue" = "#5CA7E4",
  "Yellow" = "#DAC26B",
  "Red" = "#F76E6E",
  "Cyan" = "#00C990",
  "Green" = "#49D0C5",
  "Magenta" = "#697098"
)

ggsci_db_iterm$"Nightfox"$"normal" <- c(
  "Blue" = "#719CD6",
  "Yellow" = "#DBC074",
  "Red" = "#C94F6D",
  "Cyan" = "#63CDCF",
  "Green" = "#81B29A",
  "Magenta" = "#9D79D6"
)

ggsci_db_iterm$"Nightfox"$"bright" <- c(
  "Blue" = "#86ABDC",
  "Yellow" = "#E0C989",
  "Red" = "#D16983",
  "Cyan" = "#7AD5D6",
  "Green" = "#8EBAA4",
  "Magenta" = "#BAA1E2"
)

ggsci_db_iterm$"Niji"$"normal" <- c(
  "Blue" = "#2AB9FF",
  "Yellow" = "#FFF700",
  "Red" = "#D23E08",
  "Cyan" = "#1EF9F5",
  "Green" = "#54CA74",
  "Magenta" = "#FF50DA"
)

ggsci_db_iterm$"Niji"$"bright" <- c(
  "Blue" = "#8EFFF3",
  "Yellow" = "#FCFFB8",
  "Red" = "#FFB7B7",
  "Cyan" = "#BCFFC7",
  "Green" = "#C1FFAE",
  "Magenta" = "#FFA2ED"
)

ggsci_db_iterm$"Nocturnal Winter"$"normal" <- c(
  "Blue" = "#3182E0",
  "Yellow" = "#F5F17A",
  "Red" = "#F12D52",
  "Cyan" = "#09C87A",
  "Green" = "#09CD7E",
  "Magenta" = "#FF2B6D"
)

ggsci_db_iterm$"Nocturnal Winter"$"bright" <- c(
  "Blue" = "#6096FF",
  "Yellow" = "#FFFC67",
  "Red" = "#F16D86",
  "Cyan" = "#0AE78D",
  "Green" = "#0AE78D",
  "Magenta" = "#FF78A2"
)

ggsci_db_iterm$"Nord Light"$"normal" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nord Light"$"bright" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#8FBCBB",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nord Wave"$"normal" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nord Wave"$"bright" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#8FBCBB",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nord"$"normal" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nord"$"bright" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#8FBCBB",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nordfox"$"normal" <- c(
  "Blue" = "#81A1C1",
  "Yellow" = "#EBCB8B",
  "Red" = "#BF616A",
  "Cyan" = "#88C0D0",
  "Green" = "#A3BE8C",
  "Magenta" = "#B48EAD"
)

ggsci_db_iterm$"Nordfox"$"bright" <- c(
  "Blue" = "#8CAFD2",
  "Yellow" = "#F0D399",
  "Red" = "#D06F79",
  "Cyan" = "#93CCDC",
  "Green" = "#B1D196",
  "Magenta" = "#C895BF"
)

ggsci_db_iterm$"Novel"$"normal" <- c(
  "Blue" = "#0000CC",
  "Yellow" = "#D06B00",
  "Red" = "#CC0000",
  "Cyan" = "#0087CC",
  "Green" = "#009600",
  "Magenta" = "#CC00CC"
)

ggsci_db_iterm$"Novel"$"bright" <- c(
  "Blue" = "#0000CC",
  "Yellow" = "#D06B00",
  "Red" = "#CC0000",
  "Cyan" = "#0087CC",
  "Green" = "#009600",
  "Magenta" = "#CC00CC"
)

ggsci_db_iterm$"Nvim Dark"$"normal" <- c(
  "Blue" = "#A6DBFF",
  "Yellow" = "#FCE094",
  "Red" = "#FFC0B9",
  "Cyan" = "#8CF8F7",
  "Green" = "#B3F6C0",
  "Magenta" = "#FFCAFF"
)

ggsci_db_iterm$"Nvim Dark"$"bright" <- c(
  "Blue" = "#A6DBFF",
  "Yellow" = "#FCE094",
  "Red" = "#FFC0B9",
  "Cyan" = "#8CF8F7",
  "Green" = "#B3F6C0",
  "Magenta" = "#FFCAFF"
)

ggsci_db_iterm$"Nvim Light"$"normal" <- c(
  "Blue" = "#004C73",
  "Yellow" = "#6B5300",
  "Red" = "#590008",
  "Cyan" = "#007373",
  "Green" = "#005523",
  "Magenta" = "#470045"
)

ggsci_db_iterm$"Nvim Light"$"bright" <- c(
  "Blue" = "#004C73",
  "Yellow" = "#6B5300",
  "Red" = "#590008",
  "Cyan" = "#007373",
  "Green" = "#005523",
  "Magenta" = "#470045"
)

ggsci_db_iterm$"Obsidian"$"normal" <- c(
  "Blue" = "#3A9BDB",
  "Yellow" = "#FECD22",
  "Red" = "#A60001",
  "Cyan" = "#00BBBB",
  "Green" = "#00BB00",
  "Magenta" = "#BB00BB"
)

ggsci_db_iterm$"Obsidian"$"bright" <- c(
  "Blue" = "#A1D7FF",
  "Yellow" = "#FEF874",
  "Red" = "#FF0003",
  "Cyan" = "#55FFFF",
  "Green" = "#93C863",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Ocean"$"normal" <- c(
  "Blue" = "#0000B2",
  "Yellow" = "#999900",
  "Red" = "#990000",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Ocean"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#00D900",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Oceanic Material"$"normal" <- c(
  "Blue" = "#1E80F0",
  "Yellow" = "#FFEA2E",
  "Red" = "#EE2B2A",
  "Cyan" = "#16AFCA",
  "Green" = "#40A33F",
  "Magenta" = "#8800A0"
)

ggsci_db_iterm$"Oceanic Material"$"bright" <- c(
  "Blue" = "#54A4F3",
  "Yellow" = "#FFF163",
  "Red" = "#DC5C60",
  "Cyan" = "#42C7DA",
  "Green" = "#70BE71",
  "Magenta" = "#AA4DBC"
)

ggsci_db_iterm$"Oceanic Next"$"normal" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FAC863",
  "Red" = "#EC5F67",
  "Cyan" = "#5FB3B3",
  "Green" = "#99C794",
  "Magenta" = "#C594C5"
)

ggsci_db_iterm$"Oceanic Next"$"bright" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FAC863",
  "Red" = "#EC5F67",
  "Cyan" = "#5FB3B3",
  "Green" = "#99C794",
  "Magenta" = "#C594C5"
)

ggsci_db_iterm$"Ollie"$"normal" <- c(
  "Blue" = "#2D57AC",
  "Yellow" = "#AC4300",
  "Red" = "#AC2E31",
  "Cyan" = "#1FA6AC",
  "Green" = "#31AC61",
  "Magenta" = "#B08528"
)

ggsci_db_iterm$"Ollie"$"bright" <- c(
  "Blue" = "#4488FF",
  "Yellow" = "#FF5E1E",
  "Red" = "#FF3D48",
  "Cyan" = "#1FFAFF",
  "Green" = "#3BFF99",
  "Magenta" = "#FFC21D"
)

ggsci_db_iterm$"One Double Dark"$"normal" <- c(
  "Blue" = "#3FB1F5",
  "Yellow" = "#ECBE70",
  "Red" = "#F16372",
  "Cyan" = "#17B9C4",
  "Green" = "#8CC570",
  "Magenta" = "#D373E3"
)

ggsci_db_iterm$"One Double Dark"$"bright" <- c(
  "Blue" = "#6DCAFF",
  "Yellow" = "#F5C065",
  "Red" = "#FF777B",
  "Cyan" = "#00E5FB",
  "Green" = "#82D882",
  "Magenta" = "#FF7BF4"
)

ggsci_db_iterm$"One Double Light"$"normal" <- c(
  "Blue" = "#0087C1",
  "Yellow" = "#CC8100",
  "Red" = "#F74840",
  "Cyan" = "#009AB7",
  "Green" = "#25A343",
  "Magenta" = "#B50DA9"
)

ggsci_db_iterm$"One Double Light"$"bright" <- c(
  "Blue" = "#1065DE",
  "Yellow" = "#EC9900",
  "Red" = "#FF3711",
  "Cyan" = "#00B4DD",
  "Green" = "#00B90E",
  "Magenta" = "#E500D8"
)

ggsci_db_iterm$"One Half Dark"$"normal" <- c(
  "Blue" = "#61AFEF",
  "Yellow" = "#E5C07B",
  "Red" = "#E06C75",
  "Cyan" = "#56B6C2",
  "Green" = "#98C379",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"One Half Dark"$"bright" <- c(
  "Blue" = "#61AFEF",
  "Yellow" = "#E5C07B",
  "Red" = "#E06C75",
  "Cyan" = "#56B6C2",
  "Green" = "#98C379",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"One Half Light"$"normal" <- c(
  "Blue" = "#0184BC",
  "Yellow" = "#C18401",
  "Red" = "#E45649",
  "Cyan" = "#0997B3",
  "Green" = "#50A14F",
  "Magenta" = "#A626A4"
)

ggsci_db_iterm$"One Half Light"$"bright" <- c(
  "Blue" = "#61AFEF",
  "Yellow" = "#E5C07B",
  "Red" = "#E06C75",
  "Cyan" = "#56B6C2",
  "Green" = "#98C379",
  "Magenta" = "#C678DD"
)

ggsci_db_iterm$"Operator Mono Dark"$"normal" <- c(
  "Blue" = "#4387CF",
  "Yellow" = "#D4D697",
  "Red" = "#CA372D",
  "Cyan" = "#72D5C6",
  "Green" = "#4D7B3A",
  "Magenta" = "#B86CB4"
)

ggsci_db_iterm$"Operator Mono Dark"$"bright" <- c(
  "Blue" = "#89D3F6",
  "Yellow" = "#FDFDC5",
  "Red" = "#C37D62",
  "Cyan" = "#82EADA",
  "Green" = "#83D0A2",
  "Magenta" = "#FF2C7A"
)

ggsci_db_iterm$"Overnight Slumber"$"normal" <- c(
  "Blue" = "#8DABE1",
  "Yellow" = "#FFCB8B",
  "Red" = "#FFA7C4",
  "Cyan" = "#78CCF0",
  "Green" = "#85CC95",
  "Magenta" = "#C792EB"
)

ggsci_db_iterm$"Overnight Slumber"$"bright" <- c(
  "Blue" = "#8DABE1",
  "Yellow" = "#FFCB8B",
  "Red" = "#FFA7C4",
  "Cyan" = "#FFA7C4",
  "Green" = "#85CC95",
  "Magenta" = "#C792EB"
)

ggsci_db_iterm$"Oxocarbon"$"normal" <- c(
  "Blue" = "#00C15A",
  "Yellow" = "#FF4297",
  "Red" = "#00DFDB",
  "Cyan" = "#FF74B8",
  "Green" = "#00B4FF",
  "Magenta" = "#C693FF"
)

ggsci_db_iterm$"Oxocarbon"$"bright" <- c(
  "Blue" = "#00C15A",
  "Yellow" = "#FF4297",
  "Red" = "#00DFDB",
  "Cyan" = "#FF74B8",
  "Green" = "#00B4FF",
  "Magenta" = "#C693FF"
)

ggsci_db_iterm$"Pale Night Hc"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#F07178",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Pale Night Hc"$"bright" <- c(
  "Blue" = "#B4CCFF",
  "Yellow" = "#FFDFA6",
  "Red" = "#F6A9AE",
  "Cyan" = "#B8EAFF",
  "Green" = "#DBF1BA",
  "Magenta" = "#DDBDF2"
)

ggsci_db_iterm$"Pandora"$"normal" <- c(
  "Blue" = "#338F86",
  "Yellow" = "#FFAD29",
  "Red" = "#FF4242",
  "Cyan" = "#23D7D7",
  "Green" = "#74AF68",
  "Magenta" = "#9414E6"
)

ggsci_db_iterm$"Pandora"$"bright" <- c(
  "Blue" = "#23D7D7",
  "Yellow" = "#FFB929",
  "Red" = "#FF3242",
  "Cyan" = "#00EDE1",
  "Green" = "#74CD68",
  "Magenta" = "#FF37FF"
)

ggsci_db_iterm$"Paraiso Dark"$"normal" <- c(
  "Blue" = "#06B6EF",
  "Yellow" = "#FEC418",
  "Red" = "#EF6155",
  "Cyan" = "#5BC4BF",
  "Green" = "#48B685",
  "Magenta" = "#815BA4"
)

ggsci_db_iterm$"Paraiso Dark"$"bright" <- c(
  "Blue" = "#06B6EF",
  "Yellow" = "#FEC418",
  "Red" = "#EF6155",
  "Cyan" = "#5BC4BF",
  "Green" = "#48B685",
  "Magenta" = "#815BA4"
)

ggsci_db_iterm$"Paul Millr"$"normal" <- c(
  "Blue" = "#396BD7",
  "Yellow" = "#E7BF00",
  "Red" = "#FF0000",
  "Cyan" = "#66CCFF",
  "Green" = "#79FF0F",
  "Magenta" = "#B449BE"
)

ggsci_db_iterm$"Paul Millr"$"bright" <- c(
  "Blue" = "#709AED",
  "Yellow" = "#F3D64E",
  "Red" = "#FF0080",
  "Cyan" = "#7ADFF2",
  "Green" = "#66FF66",
  "Magenta" = "#DB67E6"
)

ggsci_db_iterm$"Pencil Dark"$"normal" <- c(
  "Blue" = "#008EC4",
  "Yellow" = "#A89C14",
  "Red" = "#C30771",
  "Cyan" = "#20A5BA",
  "Green" = "#10A778",
  "Magenta" = "#523C79"
)

ggsci_db_iterm$"Pencil Dark"$"bright" <- c(
  "Blue" = "#20BBFC",
  "Yellow" = "#F3E430",
  "Red" = "#FB007A",
  "Cyan" = "#4FB8CC",
  "Green" = "#5FD7AF",
  "Magenta" = "#6855DE"
)

ggsci_db_iterm$"Pencil Light"$"normal" <- c(
  "Blue" = "#008EC4",
  "Yellow" = "#A89C14",
  "Red" = "#C30771",
  "Cyan" = "#20A5BA",
  "Green" = "#10A778",
  "Magenta" = "#523C79"
)

ggsci_db_iterm$"Pencil Light"$"bright" <- c(
  "Blue" = "#20BBFC",
  "Yellow" = "#F3E430",
  "Red" = "#FB007A",
  "Cyan" = "#4FB8CC",
  "Green" = "#5FD7AF",
  "Magenta" = "#6855DE"
)

ggsci_db_iterm$"Peppermint"$"normal" <- c(
  "Blue" = "#449FD0",
  "Yellow" = "#DAB853",
  "Red" = "#E74669",
  "Cyan" = "#65AAAF",
  "Green" = "#89D287",
  "Magenta" = "#DA62DC"
)

ggsci_db_iterm$"Peppermint"$"bright" <- c(
  "Blue" = "#6FBCE2",
  "Yellow" = "#E1E487",
  "Red" = "#E4859B",
  "Cyan" = "#96DCDB",
  "Green" = "#A3CCA2",
  "Magenta" = "#E586E7"
)

ggsci_db_iterm$"Phala Green Dark"$"normal" <- c(
  "Blue" = "#0223C0",
  "Yellow" = "#A9A700",
  "Red" = "#AB1500",
  "Cyan" = "#00B4C0",
  "Green" = "#00B100",
  "Magenta" = "#C22EC0"
)

ggsci_db_iterm$"Phala Green Dark"$"bright" <- c(
  "Blue" = "#0433FF",
  "Yellow" = "#EAE700",
  "Red" = "#ED2200",
  "Cyan" = "#00E8EA",
  "Green" = "#00DB00",
  "Magenta" = "#ED3AEA"
)

ggsci_db_iterm$"Piatto Light"$"normal" <- c(
  "Blue" = "#3C5EA8",
  "Yellow" = "#CD6F34",
  "Red" = "#B23771",
  "Cyan" = "#66781E",
  "Green" = "#66781E",
  "Magenta" = "#A454B2"
)

ggsci_db_iterm$"Piatto Light"$"bright" <- c(
  "Blue" = "#3C5EA8",
  "Yellow" = "#CD6F34",
  "Red" = "#DB3365",
  "Cyan" = "#829429",
  "Green" = "#829429",
  "Magenta" = "#A454B2"
)

ggsci_db_iterm$"Pnevma"$"normal" <- c(
  "Blue" = "#7FA5BD",
  "Yellow" = "#D7AF87",
  "Red" = "#A36666",
  "Cyan" = "#8ADBB4",
  "Green" = "#90A57D",
  "Magenta" = "#C79EC4"
)

ggsci_db_iterm$"Pnevma"$"bright" <- c(
  "Blue" = "#A1BDCE",
  "Yellow" = "#E4C9AF",
  "Red" = "#D78787",
  "Cyan" = "#B1E7DD",
  "Green" = "#AFBEA2",
  "Magenta" = "#D7BEDA"
)

ggsci_db_iterm$"Popping And Locking"$"normal" <- c(
  "Blue" = "#458588",
  "Yellow" = "#D79921",
  "Red" = "#CC241D",
  "Cyan" = "#689D6A",
  "Green" = "#98971A",
  "Magenta" = "#B16286"
)

ggsci_db_iterm$"Popping And Locking"$"bright" <- c(
  "Blue" = "#99C6CA",
  "Yellow" = "#FABD2F",
  "Red" = "#F42C3E",
  "Cyan" = "#7EC16E",
  "Green" = "#B8BB26",
  "Magenta" = "#D3869B"
)

ggsci_db_iterm$"Powershell"$"normal" <- c(
  "Blue" = "#010083",
  "Yellow" = "#C4A000",
  "Red" = "#7E0008",
  "Cyan" = "#0E807F",
  "Green" = "#098003",
  "Magenta" = "#D33682"
)

ggsci_db_iterm$"Powershell"$"bright" <- c(
  "Blue" = "#268AD2",
  "Yellow" = "#FEFE45",
  "Red" = "#EF2929",
  "Cyan" = "#29FFFE",
  "Green" = "#1CFE3C",
  "Magenta" = "#FE13FA"
)

ggsci_db_iterm$"Primary"$"normal" <- c(
  "Blue" = "#4285F4",
  "Yellow" = "#F4B400",
  "Red" = "#DB4437",
  "Cyan" = "#4285F4",
  "Green" = "#0F9D58",
  "Magenta" = "#DB4437"
)

ggsci_db_iterm$"Primary"$"bright" <- c(
  "Blue" = "#4285F4",
  "Yellow" = "#F4B400",
  "Red" = "#DB4437",
  "Cyan" = "#0F9D58",
  "Green" = "#0F9D58",
  "Magenta" = "#4285F4"
)

ggsci_db_iterm$"Pro Light"$"normal" <- c(
  "Blue" = "#3B75FF",
  "Yellow" = "#C6C440",
  "Red" = "#E5492B",
  "Cyan" = "#4ED2DE",
  "Green" = "#50D148",
  "Magenta" = "#ED66E8"
)

ggsci_db_iterm$"Pro Light"$"bright" <- c(
  "Blue" = "#0082FF",
  "Yellow" = "#F2F156",
  "Red" = "#FF6640",
  "Cyan" = "#61F7F8",
  "Green" = "#61EF57",
  "Magenta" = "#FF7EFF"
)

ggsci_db_iterm$"Pro"$"normal" <- c(
  "Blue" = "#2009DB",
  "Yellow" = "#999900",
  "Red" = "#990000",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Pro"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#00D900",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Purple Rain"$"normal" <- c(
  "Blue" = "#00A2FA",
  "Yellow" = "#FFC400",
  "Red" = "#FF260E",
  "Cyan" = "#00DEEF",
  "Green" = "#9BE205",
  "Magenta" = "#815BB5"
)

ggsci_db_iterm$"Purple Rain"$"bright" <- c(
  "Blue" = "#00A6FF",
  "Yellow" = "#FFD852",
  "Red" = "#FF4250",
  "Cyan" = "#74FDF3",
  "Green" = "#B8E36E",
  "Magenta" = "#AC7BF0"
)

ggsci_db_iterm$"Purplepeter"$"normal" <- c(
  "Blue" = "#66D9EF",
  "Yellow" = "#EFDFAC",
  "Red" = "#FF796D",
  "Cyan" = "#BA8CFF",
  "Green" = "#99B481",
  "Magenta" = "#E78FCD"
)

ggsci_db_iterm$"Purplepeter"$"bright" <- c(
  "Blue" = "#79DAED",
  "Yellow" = "#F2E9BF",
  "Red" = "#F99F92",
  "Cyan" = "#A0A0D6",
  "Green" = "#B4BE8F",
  "Magenta" = "#BA91D4"
)

ggsci_db_iterm$"Rapture"$"normal" <- c(
  "Blue" = "#6C9BF5",
  "Yellow" = "#FFF09B",
  "Red" = "#FC644D",
  "Cyan" = "#64E0FF",
  "Green" = "#7AFDE1",
  "Magenta" = "#FF4FA1"
)

ggsci_db_iterm$"Rapture"$"bright" <- c(
  "Blue" = "#6C9BF5",
  "Yellow" = "#FFF09B",
  "Red" = "#FC644D",
  "Cyan" = "#64E0FF",
  "Green" = "#7AFDE1",
  "Magenta" = "#FF4FA1"
)

ggsci_db_iterm$"Raycast Dark"$"normal" <- c(
  "Blue" = "#56C2FF",
  "Yellow" = "#FFC531",
  "Red" = "#FF5360",
  "Cyan" = "#52EEE5",
  "Green" = "#59D499",
  "Magenta" = "#CF2F98"
)

ggsci_db_iterm$"Raycast Dark"$"bright" <- c(
  "Blue" = "#56C2FF",
  "Yellow" = "#FFC531",
  "Red" = "#FF6363",
  "Cyan" = "#52EEE5",
  "Green" = "#59D499",
  "Magenta" = "#CF2F98"
)

ggsci_db_iterm$"Raycast Light"$"normal" <- c(
  "Blue" = "#138AF2",
  "Yellow" = "#F8A300",
  "Red" = "#B12424",
  "Cyan" = "#3EB8BF",
  "Green" = "#006B4F",
  "Magenta" = "#9A1B6E"
)

ggsci_db_iterm$"Raycast Light"$"bright" <- c(
  "Blue" = "#138AF2",
  "Yellow" = "#F8A300",
  "Red" = "#B12424",
  "Cyan" = "#3EB8BF",
  "Green" = "#006B4F",
  "Magenta" = "#9A1B6E"
)

ggsci_db_iterm$"Rebecca"$"normal" <- c(
  "Blue" = "#7AA5FF",
  "Yellow" = "#F2E7B7",
  "Red" = "#DD7755",
  "Cyan" = "#56D3C2",
  "Green" = "#04DBB5",
  "Magenta" = "#BF9CF9"
)

ggsci_db_iterm$"Rebecca"$"bright" <- c(
  "Blue" = "#69C0FA",
  "Yellow" = "#FFFCA8",
  "Red" = "#FF92CD",
  "Cyan" = "#8BFDE1",
  "Green" = "#01EAC0",
  "Magenta" = "#C17FF8"
)

ggsci_db_iterm$"Red Alert"$"normal" <- c(
  "Blue" = "#489BEE",
  "Yellow" = "#BEB86B",
  "Red" = "#D62E4E",
  "Cyan" = "#6BBEB8",
  "Green" = "#71BE6B",
  "Magenta" = "#E979D7"
)

ggsci_db_iterm$"Red Alert"$"bright" <- c(
  "Blue" = "#65AAF1",
  "Yellow" = "#DFDDB7",
  "Red" = "#E02553",
  "Cyan" = "#B7DFDD",
  "Green" = "#AFF08C",
  "Magenta" = "#DDB7DF"
)

ggsci_db_iterm$"Red Planet"$"normal" <- c(
  "Blue" = "#69819E",
  "Yellow" = "#E8BF6A",
  "Red" = "#8C3432",
  "Cyan" = "#5B8390",
  "Green" = "#728271",
  "Magenta" = "#896492"
)

ggsci_db_iterm$"Red Planet"$"bright" <- c(
  "Blue" = "#60827E",
  "Yellow" = "#EBEB91",
  "Red" = "#B55242",
  "Cyan" = "#38ADD8",
  "Green" = "#869985",
  "Magenta" = "#DE4974"
)

ggsci_db_iterm$"Red Sands"$"normal" <- c(
  "Blue" = "#0072FF",
  "Yellow" = "#E7B000",
  "Red" = "#FF3F00",
  "Cyan" = "#00BBBB",
  "Green" = "#00BB00",
  "Magenta" = "#BB00BB"
)

ggsci_db_iterm$"Red Sands"$"bright" <- c(
  "Blue" = "#0072AE",
  "Yellow" = "#E7B000",
  "Red" = "#BB0000",
  "Cyan" = "#55FFFF",
  "Green" = "#00BB00",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Relaxed"$"normal" <- c(
  "Blue" = "#6A8799",
  "Yellow" = "#EBC17A",
  "Red" = "#BC5653",
  "Cyan" = "#C9DFFF",
  "Green" = "#909D63",
  "Magenta" = "#B06698"
)

ggsci_db_iterm$"Relaxed"$"bright" <- c(
  "Blue" = "#7EAAC7",
  "Yellow" = "#EBC17A",
  "Red" = "#BC5653",
  "Cyan" = "#ACBBD0",
  "Green" = "#A0AC77",
  "Magenta" = "#B06698"
)

ggsci_db_iterm$"Retro Legends"$"normal" <- c(
  "Blue" = "#4066F2",
  "Yellow" = "#F7BF2B",
  "Red" = "#DE5454",
  "Cyan" = "#40D9E6",
  "Green" = "#45EB45",
  "Magenta" = "#BF4CF2"
)

ggsci_db_iterm$"Retro Legends"$"bright" <- c(
  "Blue" = "#4C80FF",
  "Yellow" = "#FFD933",
  "Red" = "#FF6666",
  "Cyan" = "#59E6FF",
  "Green" = "#59FF59",
  "Magenta" = "#E666FF"
)

ggsci_db_iterm$"Retro"$"normal" <- c(
  "Blue" = "#13A10E",
  "Yellow" = "#13A10E",
  "Red" = "#13A10E",
  "Cyan" = "#13A10E",
  "Green" = "#13A10E",
  "Magenta" = "#13A10E"
)

ggsci_db_iterm$"Retro"$"bright" <- c(
  "Blue" = "#16BA10",
  "Yellow" = "#16BA10",
  "Red" = "#16BA10",
  "Cyan" = "#16BA10",
  "Green" = "#16BA10",
  "Magenta" = "#16BA10"
)

ggsci_db_iterm$"Rippedcasts"$"normal" <- c(
  "Blue" = "#75A5B0",
  "Yellow" = "#BFBB1F",
  "Red" = "#CDAF95",
  "Cyan" = "#5A647E",
  "Green" = "#A8FF60",
  "Magenta" = "#FF73FD"
)

ggsci_db_iterm$"Rippedcasts"$"bright" <- c(
  "Blue" = "#86BDC9",
  "Yellow" = "#E5E500",
  "Red" = "#EECBAD",
  "Cyan" = "#8C9BC4",
  "Green" = "#BCEE68",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Rose Pine Dawn"$"normal" <- c(
  "Blue" = "#56949F",
  "Yellow" = "#EA9D34",
  "Red" = "#B4637A",
  "Cyan" = "#D7827E",
  "Green" = "#286983",
  "Magenta" = "#907AA9"
)

ggsci_db_iterm$"Rose Pine Dawn"$"bright" <- c(
  "Blue" = "#56949F",
  "Yellow" = "#EA9D34",
  "Red" = "#B4637A",
  "Cyan" = "#D7827E",
  "Green" = "#286983",
  "Magenta" = "#907AA9"
)

ggsci_db_iterm$"Rose Pine Moon"$"normal" <- c(
  "Blue" = "#9CCFD8",
  "Yellow" = "#F6C177",
  "Red" = "#EB6F92",
  "Cyan" = "#EA9A97",
  "Green" = "#3E8FB0",
  "Magenta" = "#C4A7E7"
)

ggsci_db_iterm$"Rose Pine Moon"$"bright" <- c(
  "Blue" = "#9CCFD8",
  "Yellow" = "#F6C177",
  "Red" = "#EB6F92",
  "Cyan" = "#EA9A97",
  "Green" = "#3E8FB0",
  "Magenta" = "#C4A7E7"
)

ggsci_db_iterm$"Rose Pine"$"normal" <- c(
  "Blue" = "#9CCFD8",
  "Yellow" = "#F6C177",
  "Red" = "#EB6F92",
  "Cyan" = "#EBBCBA",
  "Green" = "#31748F",
  "Magenta" = "#C4A7E7"
)

ggsci_db_iterm$"Rose Pine"$"bright" <- c(
  "Blue" = "#9CCFD8",
  "Yellow" = "#F6C177",
  "Red" = "#EB6F92",
  "Cyan" = "#EBBCBA",
  "Green" = "#31748F",
  "Magenta" = "#C4A7E7"
)

ggsci_db_iterm$"Rouge 2"$"normal" <- c(
  "Blue" = "#6E94B9",
  "Yellow" = "#DBCDAB",
  "Red" = "#C6797E",
  "Cyan" = "#8AB6C1",
  "Green" = "#969E92",
  "Magenta" = "#4C4E78"
)

ggsci_db_iterm$"Rouge 2"$"bright" <- c(
  "Blue" = "#98B3CD",
  "Yellow" = "#E6DCC4",
  "Red" = "#C6797E",
  "Cyan" = "#ABCBD3",
  "Green" = "#E6DCC4",
  "Magenta" = "#8283A1"
)

ggsci_db_iterm$"Royal"$"normal" <- c(
  "Blue" = "#6580B0",
  "Yellow" = "#B49D27",
  "Red" = "#91284C",
  "Cyan" = "#8AAABE",
  "Green" = "#23801C",
  "Magenta" = "#674D96"
)

ggsci_db_iterm$"Royal"$"bright" <- c(
  "Blue" = "#90BAF9",
  "Yellow" = "#FDE83B",
  "Red" = "#D5356C",
  "Cyan" = "#ACD4EB",
  "Green" = "#2CD946",
  "Magenta" = "#A479E3"
)

ggsci_db_iterm$"Ryuuko"$"normal" <- c(
  "Blue" = "#6A8E95",
  "Yellow" = "#B1A990",
  "Red" = "#865F5B",
  "Cyan" = "#88B2AC",
  "Green" = "#66907D",
  "Magenta" = "#B18A73"
)

ggsci_db_iterm$"Ryuuko"$"bright" <- c(
  "Blue" = "#6A8E95",
  "Yellow" = "#B1A990",
  "Red" = "#865F5B",
  "Cyan" = "#88B2AC",
  "Green" = "#66907D",
  "Magenta" = "#B18A73"
)

ggsci_db_iterm$"Sakura"$"normal" <- c(
  "Blue" = "#6964AB",
  "Yellow" = "#BC7053",
  "Red" = "#D52370",
  "Cyan" = "#939393",
  "Green" = "#41AF1A",
  "Magenta" = "#C71FBF"
)

ggsci_db_iterm$"Sakura"$"bright" <- c(
  "Blue" = "#9892F1",
  "Yellow" = "#F59574",
  "Red" = "#F41D99",
  "Cyan" = "#EEEEEE",
  "Green" = "#22E529",
  "Magenta" = "#E90CDD"
)

ggsci_db_iterm$"Scarlet Protocol"$"normal" <- c(
  "Blue" = "#0271B6",
  "Yellow" = "#FAF945",
  "Red" = "#FF0051",
  "Cyan" = "#00C5C7",
  "Green" = "#00DC84",
  "Magenta" = "#CA30C7"
)

ggsci_db_iterm$"Scarlet Protocol"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#FFFC67",
  "Red" = "#FF6E67",
  "Cyan" = "#60FDFF",
  "Green" = "#5FFA68",
  "Magenta" = "#BD35EC"
)

ggsci_db_iterm$"Sea Shells"$"normal" <- c(
  "Blue" = "#1E4950",
  "Yellow" = "#FCA02F",
  "Red" = "#D15123",
  "Cyan" = "#50A3B5",
  "Green" = "#027C9B",
  "Magenta" = "#68D4F1"
)

ggsci_db_iterm$"Sea Shells"$"bright" <- c(
  "Blue" = "#1BBCDD",
  "Yellow" = "#FDD39F",
  "Red" = "#D48678",
  "Cyan" = "#87ACB4",
  "Green" = "#628D98",
  "Magenta" = "#BBE3EE"
)

ggsci_db_iterm$"Seafoam Pastel"$"normal" <- c(
  "Blue" = "#4D7B82",
  "Yellow" = "#ADA16D",
  "Red" = "#825D4D",
  "Cyan" = "#729494",
  "Green" = "#728C62",
  "Magenta" = "#8A7267"
)

ggsci_db_iterm$"Seafoam Pastel"$"bright" <- c(
  "Blue" = "#7AC3CF",
  "Yellow" = "#FAE79D",
  "Red" = "#CF937A",
  "Cyan" = "#ADE0E0",
  "Green" = "#98D9AA",
  "Magenta" = "#D6B2A1"
)

ggsci_db_iterm$"Selenized Dark"$"normal" <- c(
  "Blue" = "#4695F7",
  "Yellow" = "#DBB32D",
  "Red" = "#FA5750",
  "Cyan" = "#41C7B9",
  "Green" = "#75B938",
  "Magenta" = "#F275BE"
)

ggsci_db_iterm$"Selenized Dark"$"bright" <- c(
  "Blue" = "#58A3FF",
  "Yellow" = "#EBC13D",
  "Red" = "#FF665C",
  "Cyan" = "#53D6C7",
  "Green" = "#84C747",
  "Magenta" = "#FF84CD"
)

ggsci_db_iterm$"Selenized Light"$"normal" <- c(
  "Blue" = "#0072D4",
  "Yellow" = "#AD8900",
  "Red" = "#D2212D",
  "Cyan" = "#009C8F",
  "Green" = "#489100",
  "Magenta" = "#CA4898"
)

ggsci_db_iterm$"Selenized Light"$"bright" <- c(
  "Blue" = "#006DCE",
  "Yellow" = "#A78300",
  "Red" = "#CC1729",
  "Cyan" = "#00978A",
  "Green" = "#428B00",
  "Magenta" = "#C44392"
)

ggsci_db_iterm$"Seoulbones Dark"$"normal" <- c(
  "Blue" = "#97BDDE",
  "Yellow" = "#FFDF9B",
  "Red" = "#E388A3",
  "Cyan" = "#6FBDBE",
  "Green" = "#98BD99",
  "Magenta" = "#A5A6C5"
)

ggsci_db_iterm$"Seoulbones Dark"$"bright" <- c(
  "Blue" = "#A2C8E9",
  "Yellow" = "#FFE5B3",
  "Red" = "#EB99B1",
  "Cyan" = "#6BCACB",
  "Green" = "#8FCD92",
  "Magenta" = "#B2B3DA"
)

ggsci_db_iterm$"Seoulbones Light"$"normal" <- c(
  "Blue" = "#0084A3",
  "Yellow" = "#C48562",
  "Red" = "#DC5284",
  "Cyan" = "#008586",
  "Green" = "#628562",
  "Magenta" = "#896788"
)

ggsci_db_iterm$"Seoulbones Light"$"bright" <- c(
  "Blue" = "#006F89",
  "Yellow" = "#A76B48",
  "Red" = "#BE3C6D",
  "Cyan" = "#006F70",
  "Green" = "#487249",
  "Magenta" = "#7F4C7E"
)

ggsci_db_iterm$"Seti"$"normal" <- c(
  "Blue" = "#43A5D5",
  "Yellow" = "#E0C64F",
  "Red" = "#C22832",
  "Cyan" = "#8EC43D",
  "Green" = "#8EC43D",
  "Magenta" = "#8B57B5"
)

ggsci_db_iterm$"Seti"$"bright" <- c(
  "Blue" = "#43A5D5",
  "Yellow" = "#E0C64F",
  "Red" = "#C22832",
  "Cyan" = "#8EC43D",
  "Green" = "#8EC43D",
  "Magenta" = "#8B57B5"
)

ggsci_db_iterm$"Shades Of Purple"$"normal" <- c(
  "Blue" = "#6943FF",
  "Yellow" = "#FFE700",
  "Red" = "#D90429",
  "Cyan" = "#00C5C7",
  "Green" = "#3AD900",
  "Magenta" = "#FF2C70"
)

ggsci_db_iterm$"Shades Of Purple"$"bright" <- c(
  "Blue" = "#6871FF",
  "Yellow" = "#F1D000",
  "Red" = "#F92A1C",
  "Cyan" = "#79E8FB",
  "Green" = "#43D426",
  "Magenta" = "#FF77FF"
)

ggsci_db_iterm$"Shaman"$"normal" <- c(
  "Blue" = "#449A86",
  "Yellow" = "#5E8BAA",
  "Red" = "#B2302D",
  "Cyan" = "#5D7E19",
  "Green" = "#00A941",
  "Magenta" = "#00599D"
)

ggsci_db_iterm$"Shaman"$"bright" <- c(
  "Blue" = "#61D5BA",
  "Yellow" = "#8ED4FD",
  "Red" = "#FF4242",
  "Cyan" = "#98D028",
  "Green" = "#2AEA5E",
  "Magenta" = "#1298FF"
)

ggsci_db_iterm$"Slate"$"normal" <- c(
  "Blue" = "#264B49",
  "Yellow" = "#C4C9C0",
  "Red" = "#E2A8BF",
  "Cyan" = "#15AB9C",
  "Green" = "#81D778",
  "Magenta" = "#A481D3"
)

ggsci_db_iterm$"Slate"$"bright" <- c(
  "Blue" = "#7AB0D2",
  "Yellow" = "#D0CCCA",
  "Red" = "#FFCDD9",
  "Cyan" = "#8CDFE0",
  "Green" = "#BEFFA8",
  "Magenta" = "#C5A7D9"
)

ggsci_db_iterm$"Sleepy Hollow"$"normal" <- c(
  "Blue" = "#5F63B4",
  "Yellow" = "#B55600",
  "Red" = "#BA3934",
  "Cyan" = "#8FAEA9",
  "Green" = "#91773F",
  "Magenta" = "#A17C7B"
)

ggsci_db_iterm$"Sleepy Hollow"$"bright" <- c(
  "Blue" = "#8086EF",
  "Yellow" = "#F66813",
  "Red" = "#D9443F",
  "Cyan" = "#A4DCE7",
  "Green" = "#D6B04E",
  "Magenta" = "#E2C2BB"
)

ggsci_db_iterm$"Smyck"$"normal" <- c(
  "Blue" = "#62A3C4",
  "Yellow" = "#C4A500",
  "Red" = "#B84131",
  "Cyan" = "#207383",
  "Green" = "#7DA900",
  "Magenta" = "#BA8ACC"
)

ggsci_db_iterm$"Smyck"$"bright" <- c(
  "Blue" = "#8DCFF0",
  "Yellow" = "#FEE14D",
  "Red" = "#D6837C",
  "Cyan" = "#6AD9CF",
  "Green" = "#C4F137",
  "Magenta" = "#F79AFF"
)

ggsci_db_iterm$"Snazzy Soft"$"normal" <- c(
  "Blue" = "#57C7FF",
  "Yellow" = "#F3F99D",
  "Red" = "#FF5C57",
  "Cyan" = "#9AEDFE",
  "Green" = "#5AF78E",
  "Magenta" = "#FF6AC1"
)

ggsci_db_iterm$"Snazzy Soft"$"bright" <- c(
  "Blue" = "#57C7FF",
  "Yellow" = "#F3F99D",
  "Red" = "#FF5C57",
  "Cyan" = "#9AEDFE",
  "Green" = "#5AF78E",
  "Magenta" = "#FF6AC1"
)

ggsci_db_iterm$"Snazzy"$"normal" <- c(
  "Blue" = "#49BAFF",
  "Yellow" = "#F0FB8C",
  "Red" = "#FC4346",
  "Cyan" = "#8BE9FE",
  "Green" = "#50FB7C",
  "Magenta" = "#FC4CB4"
)

ggsci_db_iterm$"Snazzy"$"bright" <- c(
  "Blue" = "#49BAFF",
  "Yellow" = "#F0FB8C",
  "Red" = "#FC4346",
  "Cyan" = "#8BE9FE",
  "Green" = "#50FB7C",
  "Magenta" = "#FC4CB4"
)

ggsci_db_iterm$"Soft Server"$"normal" <- c(
  "Blue" = "#6B8FA3",
  "Yellow" = "#A3906A",
  "Red" = "#A2686A",
  "Cyan" = "#6BA58F",
  "Green" = "#9AA56A",
  "Magenta" = "#6A71A3"
)

ggsci_db_iterm$"Soft Server"$"bright" <- c(
  "Blue" = "#62B1DF",
  "Yellow" = "#DEB360",
  "Red" = "#DD5C60",
  "Cyan" = "#64E39C",
  "Green" = "#BFDF55",
  "Magenta" = "#606EDF"
)

ggsci_db_iterm$"Solarized Darcula"$"normal" <- c(
  "Blue" = "#2075C7",
  "Yellow" = "#B68800",
  "Red" = "#F24840",
  "Cyan" = "#15968D",
  "Green" = "#629655",
  "Magenta" = "#797FD4"
)

ggsci_db_iterm$"Solarized Darcula"$"bright" <- c(
  "Blue" = "#2075C7",
  "Yellow" = "#B68800",
  "Red" = "#F24840",
  "Cyan" = "#15968D",
  "Green" = "#629655",
  "Magenta" = "#797FD4"
)

ggsci_db_iterm$"Solarized Dark Higher Contrast"$"normal" <- c(
  "Blue" = "#2176C7",
  "Yellow" = "#A57706",
  "Red" = "#D11C24",
  "Cyan" = "#259286",
  "Green" = "#6CBE6C",
  "Magenta" = "#C61C6F"
)

ggsci_db_iterm$"Solarized Dark Higher Contrast"$"bright" <- c(
  "Blue" = "#178EC8",
  "Yellow" = "#B27E28",
  "Red" = "#F5163B",
  "Cyan" = "#00B39E",
  "Green" = "#51EF84",
  "Magenta" = "#E24D8E"
)

ggsci_db_iterm$"Solarized Dark Patched"$"normal" <- c(
  "Blue" = "#2176C7",
  "Yellow" = "#A57706",
  "Red" = "#D11C24",
  "Cyan" = "#259286",
  "Green" = "#738A05",
  "Magenta" = "#C61C6F"
)

ggsci_db_iterm$"Solarized Dark Patched"$"bright" <- c(
  "Blue" = "#708284",
  "Yellow" = "#536870",
  "Red" = "#BD3613",
  "Cyan" = "#819090",
  "Green" = "#475B62",
  "Magenta" = "#5956BA"
)

ggsci_db_iterm$"Solarized Osaka Night"$"normal" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"Solarized Osaka Night"$"bright" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"Sonokai"$"normal" <- c(
  "Blue" = "#76CCE0",
  "Yellow" = "#E7C664",
  "Red" = "#FC5D7C",
  "Cyan" = "#F39660",
  "Green" = "#9ED072",
  "Magenta" = "#B39DF3"
)

ggsci_db_iterm$"Sonokai"$"bright" <- c(
  "Blue" = "#76CCE0",
  "Yellow" = "#E7C664",
  "Red" = "#FC5D7C",
  "Cyan" = "#F39660",
  "Green" = "#9ED072",
  "Magenta" = "#B39DF3"
)

ggsci_db_iterm$"Spacedust"$"normal" <- c(
  "Blue" = "#0F548B",
  "Yellow" = "#E3CD7B",
  "Red" = "#E35B00",
  "Cyan" = "#06AFC7",
  "Green" = "#5CAB96",
  "Magenta" = "#E35B00"
)

ggsci_db_iterm$"Spacedust"$"bright" <- c(
  "Blue" = "#67A0CE",
  "Yellow" = "#FFC878",
  "Red" = "#FF8A3A",
  "Cyan" = "#83A7B4",
  "Green" = "#AECAB8",
  "Magenta" = "#FF8A3A"
)

ggsci_db_iterm$"Spacegray Bright"$"normal" <- c(
  "Blue" = "#7BAEC1",
  "Yellow" = "#F6C987",
  "Red" = "#BC5553",
  "Cyan" = "#85C9B8",
  "Green" = "#A0B56C",
  "Magenta" = "#B98AAE"
)

ggsci_db_iterm$"Spacegray Bright"$"bright" <- c(
  "Blue" = "#7BAEC1",
  "Yellow" = "#F6C987",
  "Red" = "#BC5553",
  "Cyan" = "#85C9B8",
  "Green" = "#A0B56C",
  "Magenta" = "#B98AAE"
)

ggsci_db_iterm$"Spacegray Eighties Dull"$"normal" <- c(
  "Blue" = "#7C8FA5",
  "Yellow" = "#C6735A",
  "Red" = "#B24A56",
  "Cyan" = "#80CDCB",
  "Green" = "#92B477",
  "Magenta" = "#A5789E"
)

ggsci_db_iterm$"Spacegray Eighties Dull"$"bright" <- c(
  "Blue" = "#5486C0",
  "Yellow" = "#FEC254",
  "Red" = "#EC5F67",
  "Cyan" = "#58C2C1",
  "Green" = "#89E986",
  "Magenta" = "#BF83C1"
)

ggsci_db_iterm$"Spacegray Eighties"$"normal" <- c(
  "Blue" = "#5486C0",
  "Yellow" = "#FEC254",
  "Red" = "#EC5F67",
  "Cyan" = "#57C2C1",
  "Green" = "#81A764",
  "Magenta" = "#BF83C1"
)

ggsci_db_iterm$"Spacegray Eighties"$"bright" <- c(
  "Blue" = "#4D84D1",
  "Yellow" = "#FFD256",
  "Red" = "#FF6973",
  "Cyan" = "#83E9E4",
  "Green" = "#93D493",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Spacegray"$"normal" <- c(
  "Blue" = "#7D8FA4",
  "Yellow" = "#E5C179",
  "Red" = "#B04B57",
  "Cyan" = "#85A7A5",
  "Green" = "#87B379",
  "Magenta" = "#A47996"
)

ggsci_db_iterm$"Spacegray"$"bright" <- c(
  "Blue" = "#7D8FA4",
  "Yellow" = "#E5C179",
  "Red" = "#B04B57",
  "Cyan" = "#85A7A5",
  "Green" = "#87B379",
  "Magenta" = "#A47996"
)

ggsci_db_iterm$"Spiderman"$"normal" <- c(
  "Blue" = "#2C3FFF",
  "Yellow" = "#E24756",
  "Red" = "#E60813",
  "Cyan" = "#3256FF",
  "Green" = "#E22928",
  "Magenta" = "#2435DB"
)

ggsci_db_iterm$"Spiderman"$"bright" <- c(
  "Blue" = "#1D50FF",
  "Yellow" = "#FE3A35",
  "Red" = "#FF0325",
  "Cyan" = "#6184FF",
  "Green" = "#FF3338",
  "Magenta" = "#747CFF"
)

ggsci_db_iterm$"Spring"$"normal" <- c(
  "Blue" = "#1DD3EE",
  "Yellow" = "#1FC95B",
  "Red" = "#FF4D83",
  "Cyan" = "#3E999F",
  "Green" = "#1F8C3B",
  "Magenta" = "#8959A8"
)

ggsci_db_iterm$"Spring"$"bright" <- c(
  "Blue" = "#15A9FD",
  "Yellow" = "#D5B807",
  "Red" = "#FF0021",
  "Cyan" = "#3E999F",
  "Green" = "#1FC231",
  "Magenta" = "#8959A8"
)

ggsci_db_iterm$"Square"$"normal" <- c(
  "Blue" = "#A9CDEB",
  "Yellow" = "#ECEBBE",
  "Red" = "#E9897C",
  "Cyan" = "#C9CAEC",
  "Green" = "#B6377D",
  "Magenta" = "#75507B"
)

ggsci_db_iterm$"Square"$"bright" <- c(
  "Blue" = "#B6DEFB",
  "Yellow" = "#FCFBCC",
  "Red" = "#F99286",
  "Cyan" = "#D7D9FC",
  "Green" = "#C3F786",
  "Magenta" = "#AD7FA8"
)

ggsci_db_iterm$"Squirrelsong Dark"$"normal" <- c(
  "Blue" = "#4395C6",
  "Yellow" = "#D4B139",
  "Red" = "#BA4138",
  "Cyan" = "#2F9794",
  "Green" = "#468336",
  "Magenta" = "#855FB8"
)

ggsci_db_iterm$"Squirrelsong Dark"$"bright" <- c(
  "Blue" = "#4CA4DB",
  "Yellow" = "#E8C23F",
  "Red" = "#DF4D43",
  "Cyan" = "#60ACA9",
  "Green" = "#659A4C",
  "Magenta" = "#9D70DA"
)

ggsci_db_iterm$"Srcery"$"normal" <- c(
  "Blue" = "#2C78BF",
  "Yellow" = "#FBB829",
  "Red" = "#EF2F27",
  "Cyan" = "#0AAEB3",
  "Green" = "#519F50",
  "Magenta" = "#E02C6D"
)

ggsci_db_iterm$"Srcery"$"bright" <- c(
  "Blue" = "#68A8E4",
  "Yellow" = "#FED06E",
  "Red" = "#F75341",
  "Cyan" = "#2BE4D0",
  "Green" = "#98BC37",
  "Magenta" = "#FF5C8F"
)

ggsci_db_iterm$"Starlight"$"normal" <- c(
  "Blue" = "#24ACD4",
  "Yellow" = "#E3C401",
  "Red" = "#F62B5A",
  "Cyan" = "#13C299",
  "Green" = "#47B413",
  "Magenta" = "#F2AFFD"
)

ggsci_db_iterm$"Starlight"$"bright" <- c(
  "Blue" = "#5DC5F8",
  "Yellow" = "#E9E836",
  "Red" = "#FF4D51",
  "Cyan" = "#24DFC4",
  "Green" = "#35D450",
  "Magenta" = "#FEABF2"
)

ggsci_db_iterm$"Sublette"$"normal" <- c(
  "Blue" = "#5588FF",
  "Yellow" = "#FFDD88",
  "Red" = "#EE5577",
  "Cyan" = "#44EEEE",
  "Green" = "#55EE77",
  "Magenta" = "#FF77CC"
)

ggsci_db_iterm$"Sublette"$"bright" <- c(
  "Blue" = "#77BBFF",
  "Yellow" = "#FFFF77",
  "Red" = "#EE6655",
  "Cyan" = "#55FFBB",
  "Green" = "#99EE77",
  "Magenta" = "#AA88FF"
)

ggsci_db_iterm$"Subliminal"$"normal" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FFE2A9",
  "Red" = "#E15A60",
  "Cyan" = "#5FB3B3",
  "Green" = "#A9CFA4",
  "Magenta" = "#F1A5AB"
)

ggsci_db_iterm$"Subliminal"$"bright" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FFE2A9",
  "Red" = "#E15A60",
  "Cyan" = "#5FB3B3",
  "Green" = "#A9CFA4",
  "Magenta" = "#F1A5AB"
)

ggsci_db_iterm$"Sugarplum"$"normal" <- c(
  "Blue" = "#DB7DDD",
  "Yellow" = "#249A84",
  "Red" = "#5CA8DC",
  "Cyan" = "#F9F3F9",
  "Green" = "#53B397",
  "Magenta" = "#D0BEEE"
)

ggsci_db_iterm$"Sugarplum"$"bright" <- c(
  "Blue" = "#FA5DFD",
  "Yellow" = "#01F5C7",
  "Red" = "#5CB5DC",
  "Cyan" = "#FFFFFF",
  "Green" = "#52DEB5",
  "Magenta" = "#C6A5FD"
)

ggsci_db_iterm$"Sundried"$"normal" <- c(
  "Blue" = "#485B98",
  "Yellow" = "#9D602A",
  "Red" = "#A7463D",
  "Cyan" = "#9C814F",
  "Green" = "#587744",
  "Magenta" = "#864651"
)

ggsci_db_iterm$"Sundried"$"bright" <- c(
  "Blue" = "#7999F7",
  "Yellow" = "#FC6A21",
  "Red" = "#AA000C",
  "Cyan" = "#FAD484",
  "Green" = "#128C21",
  "Magenta" = "#FD8AA1"
)

ggsci_db_iterm$"Symfonic"$"normal" <- c(
  "Blue" = "#0084D4",
  "Yellow" = "#FF8400",
  "Red" = "#DC322F",
  "Cyan" = "#CCCCFF",
  "Green" = "#56DB3A",
  "Magenta" = "#B729D9"
)

ggsci_db_iterm$"Symfonic"$"bright" <- c(
  "Blue" = "#0084D4",
  "Yellow" = "#FF8400",
  "Red" = "#DC322F",
  "Cyan" = "#CCCCFF",
  "Green" = "#56DB3A",
  "Magenta" = "#B729D9"
)

ggsci_db_iterm$"Synthwave Alpha"$"normal" <- c(
  "Blue" = "#6E29AD",
  "Yellow" = "#ADAD3E",
  "Red" = "#E60A70",
  "Cyan" = "#00B0B1",
  "Green" = "#00986C",
  "Magenta" = "#B300AD"
)

ggsci_db_iterm$"Synthwave Alpha"$"bright" <- c(
  "Blue" = "#AA54F9",
  "Yellow" = "#F9F972",
  "Red" = "#E60A70",
  "Cyan" = "#00FBFD",
  "Green" = "#0AE4A4",
  "Magenta" = "#FF00F6"
)

ggsci_db_iterm$"Synthwave Everything"$"normal" <- c(
  "Blue" = "#6D77B3",
  "Yellow" = "#FEDE5D",
  "Red" = "#F97E72",
  "Cyan" = "#F772E0",
  "Green" = "#72F1B8",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Synthwave Everything"$"bright" <- c(
  "Blue" = "#36F9F6",
  "Yellow" = "#FFF951",
  "Red" = "#F88414",
  "Cyan" = "#F92AAD",
  "Green" = "#72F1B8",
  "Magenta" = "#E1ACFF"
)

ggsci_db_iterm$"Synthwave"$"normal" <- c(
  "Blue" = "#2186EC",
  "Yellow" = "#FDF834",
  "Red" = "#F6188F",
  "Cyan" = "#12C3E2",
  "Green" = "#1EBB2B",
  "Magenta" = "#F85A21"
)

ggsci_db_iterm$"Synthwave"$"bright" <- c(
  "Blue" = "#2F9DED",
  "Yellow" = "#FDF454",
  "Red" = "#F841A0",
  "Cyan" = "#19CDE6",
  "Green" = "#25C141",
  "Magenta" = "#F97137"
)

ggsci_db_iterm$"Tango Adapted"$"normal" <- c(
  "Blue" = "#00A2FF",
  "Yellow" = "#F0CB00",
  "Red" = "#FF0000",
  "Cyan" = "#00D0D6",
  "Green" = "#59D600",
  "Magenta" = "#C17ECC"
)

ggsci_db_iterm$"Tango Adapted"$"bright" <- c(
  "Blue" = "#88C9FF",
  "Yellow" = "#FFF121",
  "Red" = "#FF0013",
  "Cyan" = "#00FEFF",
  "Green" = "#93FF00",
  "Magenta" = "#E9A7E1"
)

ggsci_db_iterm$"Tango Half Adapted"$"normal" <- c(
  "Blue" = "#008EF6",
  "Yellow" = "#E2C000",
  "Red" = "#FF0000",
  "Cyan" = "#00BDC3",
  "Green" = "#4CC300",
  "Magenta" = "#A96CB3"
)

ggsci_db_iterm$"Tango Half Adapted"$"bright" <- c(
  "Blue" = "#76BFFF",
  "Yellow" = "#FFEC00",
  "Red" = "#FF0013",
  "Cyan" = "#00F6FA",
  "Green" = "#8AF600",
  "Magenta" = "#D898D1"
)

ggsci_db_iterm$"Tearout"$"normal" <- c(
  "Blue" = "#B5955E",
  "Yellow" = "#6C9861",
  "Red" = "#CC967B",
  "Cyan" = "#D7C483",
  "Green" = "#97976D",
  "Magenta" = "#C9A554"
)

ggsci_db_iterm$"Tearout"$"bright" <- c(
  "Blue" = "#B5955E",
  "Yellow" = "#6C9861",
  "Red" = "#CC967B",
  "Cyan" = "#D7C483",
  "Green" = "#97976D",
  "Magenta" = "#C9A554"
)

ggsci_db_iterm$"Teerb"$"normal" <- c(
  "Blue" = "#86AED6",
  "Yellow" = "#D7AF87",
  "Red" = "#D68686",
  "Cyan" = "#8ADBB4",
  "Green" = "#AED686",
  "Magenta" = "#D6AED6"
)

ggsci_db_iterm$"Teerb"$"bright" <- c(
  "Blue" = "#86AED6",
  "Yellow" = "#E4C9AF",
  "Red" = "#D68686",
  "Cyan" = "#B1E7DD",
  "Green" = "#AED686",
  "Magenta" = "#D6AED6"
)

ggsci_db_iterm$"Terafox"$"normal" <- c(
  "Blue" = "#5A93AA",
  "Yellow" = "#FDA47F",
  "Red" = "#E85C51",
  "Cyan" = "#A1CDD8",
  "Green" = "#7AA4A1",
  "Magenta" = "#AD5C7C"
)

ggsci_db_iterm$"Terafox"$"bright" <- c(
  "Blue" = "#73A3B7",
  "Yellow" = "#FDB292",
  "Red" = "#EB746B",
  "Cyan" = "#AFD4DE",
  "Green" = "#8EB2AF",
  "Magenta" = "#B97490"
)

ggsci_db_iterm$"Terminal Basic Dark"$"normal" <- c(
  "Blue" = "#6444ED",
  "Yellow" = "#B8B74A",
  "Red" = "#C65339",
  "Cyan" = "#69C1CF",
  "Green" = "#6AC44B",
  "Magenta" = "#D357DB"
)

ggsci_db_iterm$"Terminal Basic Dark"$"bright" <- c(
  "Blue" = "#D09AF9",
  "Yellow" = "#EFEF53",
  "Red" = "#EB5A3A",
  "Cyan" = "#78F1F2",
  "Green" = "#77EA51",
  "Magenta" = "#EB5AF7"
)

ggsci_db_iterm$"Terminal Basic"$"normal" <- c(
  "Blue" = "#0000B2",
  "Yellow" = "#999900",
  "Red" = "#990000",
  "Cyan" = "#00A6B2",
  "Green" = "#00A600",
  "Magenta" = "#B200B2"
)

ggsci_db_iterm$"Terminal Basic"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#E5E500",
  "Red" = "#E50000",
  "Cyan" = "#00E5E5",
  "Green" = "#00D900",
  "Magenta" = "#E500E5"
)

ggsci_db_iterm$"Thayer Bright"$"normal" <- c(
  "Blue" = "#2757D6",
  "Yellow" = "#F4FD22",
  "Red" = "#F92672",
  "Cyan" = "#38C8B5",
  "Green" = "#4DF840",
  "Magenta" = "#8C54FE"
)

ggsci_db_iterm$"Thayer Bright"$"bright" <- c(
  "Blue" = "#3F78FF",
  "Yellow" = "#FEED6C",
  "Red" = "#FF5995",
  "Cyan" = "#23CFD5",
  "Green" = "#B6E354",
  "Magenta" = "#9E6FFE"
)

ggsci_db_iterm$"The Hulk"$"normal" <- c(
  "Blue" = "#2525F5",
  "Yellow" = "#63E457",
  "Red" = "#269D1B",
  "Cyan" = "#378CA9",
  "Green" = "#13CE30",
  "Magenta" = "#641F74"
)

ggsci_db_iterm$"The Hulk"$"bright" <- c(
  "Blue" = "#506B95",
  "Yellow" = "#3AFE16",
  "Red" = "#8DFF2A",
  "Cyan" = "#4085A6",
  "Green" = "#48FF77",
  "Magenta" = "#72589D"
)

ggsci_db_iterm$"Tinacious Design Dark"$"normal" <- c(
  "Blue" = "#00CBFF",
  "Yellow" = "#FFCC66",
  "Red" = "#FF3399",
  "Cyan" = "#00CECA",
  "Green" = "#00D364",
  "Magenta" = "#CC66FF"
)

ggsci_db_iterm$"Tinacious Design Dark"$"bright" <- c(
  "Blue" = "#00CBFF",
  "Yellow" = "#FFD479",
  "Red" = "#FF2F92",
  "Cyan" = "#00D5D4",
  "Green" = "#00D364",
  "Magenta" = "#D783FF"
)

ggsci_db_iterm$"Tinacious Design Light"$"normal" <- c(
  "Blue" = "#00CBFF",
  "Yellow" = "#FFCC66",
  "Red" = "#FF3399",
  "Cyan" = "#00CECA",
  "Green" = "#00D364",
  "Magenta" = "#CC66FF"
)

ggsci_db_iterm$"Tinacious Design Light"$"bright" <- c(
  "Blue" = "#00CBFF",
  "Yellow" = "#FFD479",
  "Red" = "#FF2F92",
  "Cyan" = "#00D5D4",
  "Green" = "#00D364",
  "Magenta" = "#D783FF"
)

ggsci_db_iterm$"TokyoNight Day"$"normal" <- c(
  "Blue" = "#2E7DE9",
  "Yellow" = "#8C6C3E",
  "Red" = "#F52A65",
  "Cyan" = "#007197",
  "Green" = "#587539",
  "Magenta" = "#9854F1"
)

ggsci_db_iterm$"TokyoNight Day"$"bright" <- c(
  "Blue" = "#2E7DE9",
  "Yellow" = "#8C6C3E",
  "Red" = "#F52A65",
  "Cyan" = "#007197",
  "Green" = "#587539",
  "Magenta" = "#9854F1"
)

ggsci_db_iterm$"TokyoNight Moon"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFC777",
  "Red" = "#FF757F",
  "Cyan" = "#86E1FC",
  "Green" = "#C3E88D",
  "Magenta" = "#C099FF"
)

ggsci_db_iterm$"TokyoNight Moon"$"bright" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFC777",
  "Red" = "#FF757F",
  "Cyan" = "#86E1FC",
  "Green" = "#C3E88D",
  "Magenta" = "#C099FF"
)

ggsci_db_iterm$"TokyoNight Night"$"normal" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"TokyoNight Night"$"bright" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"TokyoNight Storm"$"normal" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"TokyoNight Storm"$"bright" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"TokyoNight"$"normal" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"TokyoNight"$"bright" <- c(
  "Blue" = "#7AA2F7",
  "Yellow" = "#E0AF68",
  "Red" = "#F7768E",
  "Cyan" = "#7DCFFF",
  "Green" = "#9ECE6A",
  "Magenta" = "#BB9AF7"
)

ggsci_db_iterm$"Tomorrow Night Blue"$"normal" <- c(
  "Blue" = "#BBDAFF",
  "Yellow" = "#FFEEAD",
  "Red" = "#FF9DA4",
  "Cyan" = "#99FFFF",
  "Green" = "#D1F1A9",
  "Magenta" = "#EBBBFF"
)

ggsci_db_iterm$"Tomorrow Night Blue"$"bright" <- c(
  "Blue" = "#BBDAFF",
  "Yellow" = "#FFEEAD",
  "Red" = "#FF9DA4",
  "Cyan" = "#99FFFF",
  "Green" = "#D1F1A9",
  "Magenta" = "#EBBBFF"
)

ggsci_db_iterm$"Tomorrow Night Bright"$"normal" <- c(
  "Blue" = "#7AA6DA",
  "Yellow" = "#E7C547",
  "Red" = "#D54E53",
  "Cyan" = "#70C0B1",
  "Green" = "#B9CA4A",
  "Magenta" = "#C397D8"
)

ggsci_db_iterm$"Tomorrow Night Bright"$"bright" <- c(
  "Blue" = "#7AA6DA",
  "Yellow" = "#E7C547",
  "Red" = "#D54E53",
  "Cyan" = "#70C0B1",
  "Green" = "#B9CA4A",
  "Magenta" = "#C397D8"
)

ggsci_db_iterm$"Tomorrow Night Burns"$"normal" <- c(
  "Blue" = "#FC595F",
  "Yellow" = "#D3494E",
  "Red" = "#832E31",
  "Cyan" = "#BA8586",
  "Green" = "#A63C40",
  "Magenta" = "#DF9395"
)

ggsci_db_iterm$"Tomorrow Night Burns"$"bright" <- c(
  "Blue" = "#FC595F",
  "Yellow" = "#D2494E",
  "Red" = "#832E31",
  "Cyan" = "#BA8586",
  "Green" = "#A63C40",
  "Magenta" = "#DF9395"
)

ggsci_db_iterm$"Tomorrow Night Eighties"$"normal" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FFCC66",
  "Red" = "#F2777A",
  "Cyan" = "#66CCCC",
  "Green" = "#99CC99",
  "Magenta" = "#CC99CC"
)

ggsci_db_iterm$"Tomorrow Night Eighties"$"bright" <- c(
  "Blue" = "#6699CC",
  "Yellow" = "#FFCC66",
  "Red" = "#F2777A",
  "Cyan" = "#66CCCC",
  "Green" = "#99CC99",
  "Magenta" = "#CC99CC"
)

ggsci_db_iterm$"Tomorrow Night"$"normal" <- c(
  "Blue" = "#81A2BE",
  "Yellow" = "#F0C674",
  "Red" = "#CC6666",
  "Cyan" = "#8ABEB7",
  "Green" = "#B5BD68",
  "Magenta" = "#B294BB"
)

ggsci_db_iterm$"Tomorrow Night"$"bright" <- c(
  "Blue" = "#81A2BE",
  "Yellow" = "#F0C674",
  "Red" = "#CC6666",
  "Cyan" = "#8ABEB7",
  "Green" = "#B5BD68",
  "Magenta" = "#B294BB"
)

ggsci_db_iterm$"Tomorrow"$"normal" <- c(
  "Blue" = "#4271AE",
  "Yellow" = "#EAB700",
  "Red" = "#C82829",
  "Cyan" = "#3E999F",
  "Green" = "#718C00",
  "Magenta" = "#8959A8"
)

ggsci_db_iterm$"Tomorrow"$"bright" <- c(
  "Blue" = "#4271AE",
  "Yellow" = "#EAB700",
  "Red" = "#C82829",
  "Cyan" = "#3E999F",
  "Green" = "#718C00",
  "Magenta" = "#8959A8"
)

ggsci_db_iterm$"Toy Chest"$"normal" <- c(
  "Blue" = "#325D96",
  "Yellow" = "#DB8E27",
  "Red" = "#BE2D26",
  "Cyan" = "#35A08F",
  "Green" = "#1A9172",
  "Magenta" = "#8A5EDC"
)

ggsci_db_iterm$"Toy Chest"$"bright" <- c(
  "Blue" = "#34A6DA",
  "Yellow" = "#E7D84B",
  "Red" = "#DD5944",
  "Cyan" = "#42C3AE",
  "Green" = "#31D07B",
  "Magenta" = "#AE6BDC"
)

ggsci_db_iterm$"Treehouse"$"normal" <- c(
  "Blue" = "#58859A",
  "Yellow" = "#AA820C",
  "Red" = "#B2270E",
  "Cyan" = "#B25A1E",
  "Green" = "#44A900",
  "Magenta" = "#97363D"
)

ggsci_db_iterm$"Treehouse"$"bright" <- c(
  "Blue" = "#85CFED",
  "Yellow" = "#F2B732",
  "Red" = "#ED5D20",
  "Cyan" = "#F07D14",
  "Green" = "#55F238",
  "Magenta" = "#E14C5A"
)

ggsci_db_iterm$"Twilight"$"normal" <- c(
  "Blue" = "#44474A",
  "Yellow" = "#C2A86C",
  "Red" = "#C06D44",
  "Cyan" = "#778385",
  "Green" = "#AFB97A",
  "Magenta" = "#B4BE7C"
)

ggsci_db_iterm$"Twilight"$"bright" <- c(
  "Blue" = "#5A5E62",
  "Yellow" = "#E2C47E",
  "Red" = "#DE7C4C",
  "Cyan" = "#8A989B",
  "Green" = "#CCD88C",
  "Magenta" = "#D0DC8E"
)

ggsci_db_iterm$"Ubuntu"$"normal" <- c(
  "Blue" = "#3465A4",
  "Yellow" = "#C4A000",
  "Red" = "#CC0000",
  "Cyan" = "#06989A",
  "Green" = "#4E9A06",
  "Magenta" = "#75507B"
)

ggsci_db_iterm$"Ubuntu"$"bright" <- c(
  "Blue" = "#729FCF",
  "Yellow" = "#FCE94F",
  "Red" = "#EF2929",
  "Cyan" = "#34E2E2",
  "Green" = "#8AE234",
  "Magenta" = "#AD7FA8"
)

ggsci_db_iterm$"Ultra Dark"$"normal" <- c(
  "Blue" = "#82AAFF",
  "Yellow" = "#FFCB6B",
  "Red" = "#F07178",
  "Cyan" = "#89DDFF",
  "Green" = "#C3E88D",
  "Magenta" = "#C792EA"
)

ggsci_db_iterm$"Ultra Dark"$"bright" <- c(
  "Blue" = "#B4CCFF",
  "Yellow" = "#FFDFA6",
  "Red" = "#F6A9AE",
  "Cyan" = "#B8EAFF",
  "Green" = "#DBF1BA",
  "Magenta" = "#DDBDF2"
)

ggsci_db_iterm$"Ultra Violent"$"normal" <- c(
  "Blue" = "#47E0FB",
  "Yellow" = "#FFF727",
  "Red" = "#FF0090",
  "Cyan" = "#0EFFBB",
  "Green" = "#B6FF00",
  "Magenta" = "#D731FF"
)

ggsci_db_iterm$"Ultra Violent"$"bright" <- c(
  "Blue" = "#7FECFF",
  "Yellow" = "#EBE087",
  "Red" = "#FB58B4",
  "Cyan" = "#69FCD3",
  "Green" = "#DEFF8C",
  "Magenta" = "#E681FF"
)

ggsci_db_iterm$"Under The Sea"$"normal" <- c(
  "Blue" = "#459A86",
  "Yellow" = "#59819C",
  "Red" = "#B2302D",
  "Cyan" = "#5D7E19",
  "Green" = "#00A941",
  "Magenta" = "#00599D"
)

ggsci_db_iterm$"Under The Sea"$"bright" <- c(
  "Blue" = "#61D5BA",
  "Yellow" = "#8ED4FD",
  "Red" = "#FF4242",
  "Cyan" = "#98D028",
  "Green" = "#2AEA5E",
  "Magenta" = "#1298FF"
)

ggsci_db_iterm$"Unikitty"$"normal" <- c(
  "Blue" = "#145FCD",
  "Yellow" = "#EEDF4B",
  "Red" = "#A80F20",
  "Cyan" = "#6BD1BC",
  "Green" = "#BAFC8B",
  "Magenta" = "#FF36A2"
)

ggsci_db_iterm$"Unikitty"$"bright" <- c(
  "Blue" = "#0075EA",
  "Yellow" = "#FFEF50",
  "Red" = "#D91329",
  "Cyan" = "#79ECD5",
  "Green" = "#D3FFAF",
  "Magenta" = "#FDD5E5"
)

ggsci_db_iterm$"Urple"$"normal" <- c(
  "Blue" = "#564D9B",
  "Yellow" = "#AD5C42",
  "Red" = "#B0425B",
  "Cyan" = "#808080",
  "Green" = "#37A415",
  "Magenta" = "#6C3CA1"
)

ggsci_db_iterm$"Urple"$"bright" <- c(
  "Blue" = "#867AED",
  "Yellow" = "#F08161",
  "Red" = "#FF6388",
  "Cyan" = "#EAEAEA",
  "Green" = "#29E620",
  "Magenta" = "#A05EEE"
)

ggsci_db_iterm$"Vague"$"normal" <- c(
  "Blue" = "#7E98E8",
  "Yellow" = "#F3BE7C",
  "Red" = "#DF6882",
  "Cyan" = "#9BB4BC",
  "Green" = "#8CB66D",
  "Magenta" = "#C3C3D5"
)

ggsci_db_iterm$"Vague"$"bright" <- c(
  "Blue" = "#7E98E8",
  "Yellow" = "#F3BE7C",
  "Red" = "#DF6882",
  "Cyan" = "#9BB4BC",
  "Green" = "#8CB66D",
  "Magenta" = "#C3C3D5"
)

ggsci_db_iterm$"Vaughn"$"normal" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#DFAF8F",
  "Red" = "#705050",
  "Cyan" = "#8CD0D3",
  "Green" = "#60B48A",
  "Magenta" = "#F08CC3"
)

ggsci_db_iterm$"Vaughn"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#F0DFAF",
  "Red" = "#DCA3A3",
  "Cyan" = "#93E0E3",
  "Green" = "#60B48A",
  "Magenta" = "#EC93D3"
)

ggsci_db_iterm$"Vercel"$"normal" <- c(
  "Blue" = "#006AFF",
  "Yellow" = "#FFAE00",
  "Red" = "#FC0036",
  "Cyan" = "#00AC96",
  "Green" = "#29A948",
  "Magenta" = "#F32882"
)

ggsci_db_iterm$"Vercel"$"bright" <- c(
  "Blue" = "#49AEFF",
  "Yellow" = "#FFAE00",
  "Red" = "#FF8080",
  "Cyan" = "#00E4C4",
  "Green" = "#4BE15D",
  "Magenta" = "#F97EA8"
)

ggsci_db_iterm$"Vesper"$"normal" <- c(
  "Blue" = "#ACA1CF",
  "Yellow" = "#E6B99D",
  "Red" = "#F5A191",
  "Cyan" = "#EA83A5",
  "Green" = "#90B99F",
  "Magenta" = "#E29ECA"
)

ggsci_db_iterm$"Vesper"$"bright" <- c(
  "Blue" = "#B9AEDA",
  "Yellow" = "#FFC799",
  "Red" = "#FF8080",
  "Cyan" = "#F591B2",
  "Green" = "#99FFE4",
  "Magenta" = "#ECAAD6"
)

ggsci_db_iterm$"Vibrant Ink"$"normal" <- c(
  "Blue" = "#44B4CC",
  "Yellow" = "#FFCC00",
  "Red" = "#FF6600",
  "Cyan" = "#44B4CC",
  "Green" = "#CCFF04",
  "Magenta" = "#9933CC"
)

ggsci_db_iterm$"Vibrant Ink"$"bright" <- c(
  "Blue" = "#0000FF",
  "Yellow" = "#FFFF00",
  "Red" = "#FF0000",
  "Cyan" = "#00FFFF",
  "Green" = "#00FF00",
  "Magenta" = "#FF00FF"
)

ggsci_db_iterm$"Vimbones"$"normal" <- c(
  "Blue" = "#286486",
  "Yellow" = "#944927",
  "Red" = "#A8334C",
  "Cyan" = "#3B8992",
  "Green" = "#4F6C31",
  "Magenta" = "#88507D"
)

ggsci_db_iterm$"Vimbones"$"bright" <- c(
  "Blue" = "#1D5573",
  "Yellow" = "#803D1C",
  "Red" = "#94253E",
  "Cyan" = "#2B747C",
  "Green" = "#3F5A22",
  "Magenta" = "#7B3B70"
)

ggsci_db_iterm$"Violet Dark"$"normal" <- c(
  "Blue" = "#2E8BCE",
  "Yellow" = "#B4881D",
  "Red" = "#C94C22",
  "Cyan" = "#32A198",
  "Green" = "#85981C",
  "Magenta" = "#D13A82"
)

ggsci_db_iterm$"Violet Dark"$"bright" <- c(
  "Blue" = "#2176C7",
  "Yellow" = "#A57705",
  "Red" = "#BD3613",
  "Cyan" = "#259286",
  "Green" = "#738A04",
  "Magenta" = "#C61C6F"
)

ggsci_db_iterm$"Violet Light"$"normal" <- c(
  "Blue" = "#2E8BCE",
  "Yellow" = "#B4881D",
  "Red" = "#C94C22",
  "Cyan" = "#32A198",
  "Green" = "#85981C",
  "Magenta" = "#D13A82"
)

ggsci_db_iterm$"Violet Light"$"bright" <- c(
  "Blue" = "#2176C7",
  "Yellow" = "#A57705",
  "Red" = "#BD3613",
  "Cyan" = "#259286",
  "Green" = "#738A04",
  "Magenta" = "#C61C6F"
)

ggsci_db_iterm$"Violite"$"normal" <- c(
  "Blue" = "#A979EC",
  "Yellow" = "#ECE279",
  "Red" = "#EC7979",
  "Cyan" = "#79ECEC",
  "Green" = "#79ECB3",
  "Magenta" = "#EC79EC"
)

ggsci_db_iterm$"Violite"$"bright" <- c(
  "Blue" = "#B78FEF",
  "Yellow" = "#EFE78F",
  "Red" = "#EF8F8F",
  "Cyan" = "#9FEFEF",
  "Green" = "#9FEFBF",
  "Magenta" = "#EF8FCF"
)

ggsci_db_iterm$"Warm Neon"$"normal" <- c(
  "Blue" = "#4261C5",
  "Yellow" = "#DAE145",
  "Red" = "#E24346",
  "Cyan" = "#2ABBD4",
  "Green" = "#39B13A",
  "Magenta" = "#F920FB"
)

ggsci_db_iterm$"Warm Neon"$"bright" <- c(
  "Blue" = "#7B91D6",
  "Yellow" = "#DDDA7A",
  "Red" = "#E97071",
  "Cyan" = "#5ED1E5",
  "Green" = "#9CC090",
  "Magenta" = "#F674BA"
)

ggsci_db_iterm$"Wez"$"normal" <- c(
  "Blue" = "#5555CC",
  "Yellow" = "#CDCD55",
  "Red" = "#CC5555",
  "Cyan" = "#7ACACA",
  "Green" = "#55CC55",
  "Magenta" = "#CC55CC"
)

ggsci_db_iterm$"Wez"$"bright" <- c(
  "Blue" = "#5555FF",
  "Yellow" = "#FFFF55",
  "Red" = "#FF5555",
  "Cyan" = "#55FFFF",
  "Green" = "#55FF55",
  "Magenta" = "#FF55FF"
)

ggsci_db_iterm$"Whimsy"$"normal" <- c(
  "Blue" = "#65AEF7",
  "Yellow" = "#FDD877",
  "Red" = "#EF6487",
  "Cyan" = "#43C1BE",
  "Green" = "#5ECA89",
  "Magenta" = "#AA7FF0"
)

ggsci_db_iterm$"Whimsy"$"bright" <- c(
  "Blue" = "#65AEF7",
  "Yellow" = "#FDD877",
  "Red" = "#EF6487",
  "Cyan" = "#43C1BE",
  "Green" = "#5ECA89",
  "Magenta" = "#AA7FF0"
)

ggsci_db_iterm$"Wild Cherry"$"normal" <- c(
  "Blue" = "#883CDC",
  "Yellow" = "#FFD16F",
  "Red" = "#D94085",
  "Cyan" = "#C1B8B7",
  "Green" = "#2AB250",
  "Magenta" = "#ECECEC"
)

ggsci_db_iterm$"Wild Cherry"$"bright" <- c(
  "Blue" = "#308CBA",
  "Yellow" = "#EAC066",
  "Red" = "#DA6BAC",
  "Cyan" = "#FF919D",
  "Green" = "#F4DCA5",
  "Magenta" = "#AE636B"
)

ggsci_db_iterm$"Wilmersdorf"$"normal" <- c(
  "Blue" = "#A6C1E0",
  "Yellow" = "#CCCCCC",
  "Red" = "#E06383",
  "Cyan" = "#5B94AB",
  "Green" = "#7EBEBD",
  "Magenta" = "#E1C1EE"
)

ggsci_db_iterm$"Wilmersdorf"$"bright" <- c(
  "Blue" = "#B2CFF0",
  "Yellow" = "#D1DFFF",
  "Red" = "#FA7193",
  "Cyan" = "#69ABC5",
  "Green" = "#8FD7D6",
  "Magenta" = "#EFCCFD"
)

ggsci_db_iterm$"Wombat"$"normal" <- c(
  "Blue" = "#5DA9F6",
  "Yellow" = "#EBD99C",
  "Red" = "#FF615A",
  "Cyan" = "#82FFF7",
  "Green" = "#B1E969",
  "Magenta" = "#E86AFF"
)

ggsci_db_iterm$"Wombat"$"bright" <- c(
  "Blue" = "#A5C7FF",
  "Yellow" = "#EEE5B2",
  "Red" = "#F58C80",
  "Cyan" = "#B7FFF9",
  "Green" = "#DDF88F",
  "Magenta" = "#DDAAFF"
)

ggsci_db_iterm$"Wryan"$"normal" <- c(
  "Blue" = "#395573",
  "Yellow" = "#7C7C99",
  "Red" = "#8C4665",
  "Cyan" = "#31658C",
  "Green" = "#287373",
  "Magenta" = "#5E468C"
)

ggsci_db_iterm$"Wryan"$"bright" <- c(
  "Blue" = "#477AB3",
  "Yellow" = "#9E9ECB",
  "Red" = "#BF4D80",
  "Cyan" = "#6096BF",
  "Green" = "#53A6A6",
  "Magenta" = "#7E62B3"
)

ggsci_db_iterm$"Xcode Dark hc"$"normal" <- c(
  "Blue" = "#4EC4E6",
  "Yellow" = "#D9C668",
  "Red" = "#FF8A7A",
  "Cyan" = "#CDA1FF",
  "Green" = "#83C9BC",
  "Magenta" = "#FF85B8"
)

ggsci_db_iterm$"Xcode Dark hc"$"bright" <- c(
  "Blue" = "#6BDFFF",
  "Yellow" = "#FFA14F",
  "Red" = "#FF8A7A",
  "Cyan" = "#E5CFFF",
  "Green" = "#B1FAEB",
  "Magenta" = "#FF85B8"
)

ggsci_db_iterm$"Xcode Dark"$"normal" <- c(
  "Blue" = "#4EB0CC",
  "Yellow" = "#D9C97C",
  "Red" = "#FF8170",
  "Cyan" = "#B281EB",
  "Green" = "#78C2B3",
  "Magenta" = "#FF7AB2"
)

ggsci_db_iterm$"Xcode Dark"$"bright" <- c(
  "Blue" = "#6BDFFF",
  "Yellow" = "#FFA14F",
  "Red" = "#FF8170",
  "Cyan" = "#DABAFF",
  "Green" = "#ACF2E4",
  "Magenta" = "#FF7AB2"
)

ggsci_db_iterm$"Xcode Light hc"$"normal" <- c(
  "Blue" = "#0058A1",
  "Yellow" = "#78492A",
  "Red" = "#AD1805",
  "Cyan" = "#703DAA",
  "Green" = "#355D61",
  "Magenta" = "#9C2191"
)

ggsci_db_iterm$"Xcode Light hc"$"bright" <- c(
  "Blue" = "#003F73",
  "Yellow" = "#78492A",
  "Red" = "#AD1805",
  "Cyan" = "#441EA1",
  "Green" = "#174145",
  "Magenta" = "#9C2191"
)

ggsci_db_iterm$"Xcode Light"$"normal" <- c(
  "Blue" = "#0F68A0",
  "Yellow" = "#78492A",
  "Red" = "#D12F1B",
  "Cyan" = "#804FB8",
  "Green" = "#3E8087",
  "Magenta" = "#AD3DA4"
)

ggsci_db_iterm$"Xcode Light"$"bright" <- c(
  "Blue" = "#0B4F79",
  "Yellow" = "#78492A",
  "Red" = "#D12F1B",
  "Cyan" = "#4B21B0",
  "Green" = "#23575C",
  "Magenta" = "#AD3DA4"
)

ggsci_db_iterm$"Xcode WWDC"$"normal" <- c(
  "Blue" = "#8884C5",
  "Yellow" = "#D28E5D",
  "Red" = "#BB383A",
  "Cyan" = "#00ABA4",
  "Green" = "#94C66E",
  "Magenta" = "#B73999"
)

ggsci_db_iterm$"Xcode WWDC"$"bright" <- c(
  "Blue" = "#8884C5",
  "Yellow" = "#D28E5D",
  "Red" = "#BB383A",
  "Cyan" = "#00ABA4",
  "Green" = "#94C66E",
  "Magenta" = "#B73999"
)

ggsci_db_iterm$"Zenbones Dark"$"normal" <- c(
  "Blue" = "#6099C0",
  "Yellow" = "#B77E64",
  "Red" = "#DE6E7C",
  "Cyan" = "#66A5AD",
  "Green" = "#819B69",
  "Magenta" = "#B279A7"
)

ggsci_db_iterm$"Zenbones Dark"$"bright" <- c(
  "Blue" = "#61ABDA",
  "Yellow" = "#D68C67",
  "Red" = "#E8838F",
  "Cyan" = "#65B8C1",
  "Green" = "#8BAE68",
  "Magenta" = "#CF86C1"
)

ggsci_db_iterm$"Zenbones Light"$"normal" <- c(
  "Blue" = "#286486",
  "Yellow" = "#944927",
  "Red" = "#A8334C",
  "Cyan" = "#3B8992",
  "Green" = "#4F6C31",
  "Magenta" = "#88507D"
)

ggsci_db_iterm$"Zenbones Light"$"bright" <- c(
  "Blue" = "#1D5573",
  "Yellow" = "#803D1C",
  "Red" = "#94253E",
  "Cyan" = "#2B747C",
  "Green" = "#3F5A22",
  "Magenta" = "#7B3B70"
)

ggsci_db_iterm$"Zenbones"$"normal" <- c(
  "Blue" = "#286486",
  "Yellow" = "#944927",
  "Red" = "#A8334C",
  "Cyan" = "#3B8992",
  "Green" = "#4F6C31",
  "Magenta" = "#88507D"
)

ggsci_db_iterm$"Zenbones"$"bright" <- c(
  "Blue" = "#1D5573",
  "Yellow" = "#803D1C",
  "Red" = "#94253E",
  "Cyan" = "#2B747C",
  "Green" = "#3F5A22",
  "Magenta" = "#7B3B70"
)

ggsci_db_iterm$"Zenburn"$"normal" <- c(
  "Blue" = "#506070",
  "Yellow" = "#F0DFAF",
  "Red" = "#705050",
  "Cyan" = "#8CD0D3",
  "Green" = "#60B48A",
  "Magenta" = "#DC8CC3"
)

ggsci_db_iterm$"Zenburn"$"bright" <- c(
  "Blue" = "#94BFF3",
  "Yellow" = "#E0CF9F",
  "Red" = "#DCA3A3",
  "Cyan" = "#93E0E3",
  "Green" = "#C3BF9F",
  "Magenta" = "#EC93D3"
)

ggsci_db_iterm$"Zenburned"$"normal" <- c(
  "Blue" = "#6099C0",
  "Yellow" = "#B77E64",
  "Red" = "#E3716E",
  "Cyan" = "#66A5AD",
  "Green" = "#819B69",
  "Magenta" = "#B279A7"
)

ggsci_db_iterm$"Zenburned"$"bright" <- c(
  "Blue" = "#61ABDA",
  "Yellow" = "#D68C67",
  "Red" = "#EC8685",
  "Cyan" = "#65B8C1",
  "Green" = "#8BAE68",
  "Magenta" = "#CF86C1"
)

ggsci_db_iterm$"Zenwritten Dark"$"normal" <- c(
  "Blue" = "#6099C0",
  "Yellow" = "#B77E64",
  "Red" = "#DE6E7C",
  "Cyan" = "#66A5AD",
  "Green" = "#819B69",
  "Magenta" = "#B279A7"
)

ggsci_db_iterm$"Zenwritten Dark"$"bright" <- c(
  "Blue" = "#61ABDA",
  "Yellow" = "#D68C67",
  "Red" = "#E8838F",
  "Cyan" = "#65B8C1",
  "Green" = "#8BAE68",
  "Magenta" = "#CF86C1"
)

ggsci_db_iterm$"Zenwritten Light"$"normal" <- c(
  "Blue" = "#286486",
  "Yellow" = "#944927",
  "Red" = "#A8334C",
  "Cyan" = "#3B8992",
  "Green" = "#4F6C31",
  "Magenta" = "#88507D"
)

ggsci_db_iterm$"Zenwritten Light"$"bright" <- c(
  "Blue" = "#1D5573",
  "Yellow" = "#803D1C",
  "Red" = "#94253E",
  "Cyan" = "#2B747C",
  "Green" = "#3F5A22",
  "Magenta" = "#7B3B70"
)
