% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scidca.coxph.R
\name{scidca.coxph}
\alias{scidca.coxph}
\title{scidca.coxph}
\usage{
\method{scidca}{coxph}(
  fit,
  newdata = NULL,
  timepoint = "median",
  cmprsk = FALSE,
  modelnames = NULL,
  merge = FALSE,
  y.min = NULL,
  xstop = NULL,
  y.max = NULL,
  pyh = NULL,
  relcol = "#c01e35",
  irrelcol = "#0151a2",
  relabel = "Nomogram relevant",
  irrellabel = "Nomogram irrelevant",
  text.size = 4.5,
  text.col = "green",
  colbar = TRUE
)
}
\arguments{
\item{fit}{Fill in the model you want to analyze. Support survival analysis and logistic regression.}

\item{newdata}{If the decision curve of the validation set is to be analysed. Fill in the validation set data here.}

\item{timepoint}{If it is a survival analysis, fill in the point in time you need to study. The default is the median time.}

\item{cmprsk}{If it is a competitive risk model, select TRUE here.}

\item{modelnames}{Defines the name of the generated image model.}

\item{merge}{If true is selected it will merge the two long zones.}

\item{y.min}{The maximum value of the negative part of the picture. Generally defaults to positive values multiplied by 0.4.}

\item{xstop}{The maximum value of the X-axis of the picture.}

\item{y.max}{The maximum value of the Y-axis. The default value is the maximum net benefit.}

\item{pyh}{The height at which the bars are plotted cannot exceed y.min.}

\item{relcol}{The colour of the relevant part of the bar. The default is red.}

\item{irrelcol}{The colour of the irrelevant part of the bar. The default is blue.}

\item{relabel}{Relevance Tags.}

\item{irrellabel}{No relevant tags.}

\item{text.size}{Font size.}

\item{text.col}{The colour of the font.}

\item{colbar}{The default is true, and if false is selected, bar plotting is cancelled.}
}
\value{
A picture.
}
\description{
scidca.coxph
}
