% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose-seasonal.R
\name{stat_decomp}
\alias{stat_decomp}
\title{Classical seasonal adjustment Stat}
\usage{
stat_decomp(mapping = NULL, data = NULL, geom = "line",
  position = "identity", show.legend = NA, inherit.aes = TRUE, frequency,
  type = c("additive", "multiplicative"), ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{frequency}{The frequency for the time series}

\item{type}{The type of seasonal component}

\item{...}{other arguments for the geom}
}
\description{
Conducts seasonal adjustment on the fly for ggplot2, from classical seasonal decomposition by moving averages
}
\details{
Classical decomposition is a very basic way of performing seasonal
adjustment and is not recommended if you have access to X13-SEATS-ARIMA 
(\code{stat_seas}).  \code{stat_decomp} cannot allow the seasonality to vary
over time, or take outliers into account in calculating seasonality.
}
\examples{
ap_df <- tsdf(AirPassengers)

# default additive decomposition (doesn't work well in this case!):
ggplot(ap_df, aes(x = x, y = y)) +
   stat_decomp(frequency = 12)

# multiplicative decomposition, more appropriate:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_decomp(frequency = 12, type = "multiplicative")

ggplot(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex)) +
  geom_point() +
  facet_wrap(~sex) +
  stat_decomp(frequency = 12) +
  ggtitle("Seasonally adjusted lung deaths")

}
\seealso{
\code{\link{decompose}}

Other time.series.stats.for.ggplot2: \code{\link{stat_seas}},
  \code{\link{stat_stl}}
}

