% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsdc.R
\name{ggsdc}
\alias{ggsdc}
\title{Visualise seasonal decomposition}
\usage{
ggsdc(data, mapping, frequency = NULL, method = c("stl", "decompose",
  "seas"), start = NULL, s.window, type = c("additive", "multiplicative"),
  index.ref = NULL, index.basis = 100, facet.titles = c("observed",
  "trend", "seasonal", "irregular"))
}
\arguments{
\item{data}{dataset to use for plot.}

\item{mapping}{List of aesthetic mappings.  Must include x and y, and optionally
can include colour/color}

\item{frequency}{frequency of the period of the time series eg 12 = monthly}

\item{method}{function to use for performing the seasonal decomposition. stl
and decompose are functions in the \code{stats} package; \code{seas} is access
to the \code{seats} program from X-13-SEATS-ARIMA via the \code{seasonal} package}

\item{start}{starting time for the data; only needed if \code{method = 'seas'}.}

\item{s.window}{parameter to pass to \code{stl()}}

\item{type}{parameter to pass to \code{decompose()}}

\item{index.ref}{if not NULL, a vector of integers indicating which elements of
the beginning of each series to use as a reference point for converting to an index.  
If NULL, no conversion takes place and the data are presented on the original scale.}

\item{index.basis}{if index.ref is not NULL, the basis point for converting
to an index, most commonly 100 or 1000.  See examples.}

\item{facet.titles}{a vector in the order of \code{observed}, \code{trend}, \code{seasonal} and \code{irregular} 
for the titles of the four facets of the decomposition.  Make sure you get the order right...}
}
\value{
an object of class ggplot with four facets
}
\description{
Creates a four-facet plot of seasonal decomposition showing observed, trend, seasonal and random components
}
\details{
This function takes a data frame and performs seasonal decomposition
on the variable mapped to the y aesthetic, grouped by the variable (if any)
mapped to the colour or color aesthetic.  This allows the user to perform
the equivalent of plot(stats::decompose(x)) but in the ggplot2 environment for themes,
polishing etc; and to overlay decompositions on the same graphic; and with the 
X13-SEATS-ARIMA seasonal decomposition (so far only with default settings).

The "seasonal" component can be either multiplicative (in which case it will
in a small range of values around one) or additive (in which case it will be
on the scale of the original data), depending on the settings.
}
\examples{
# sample time series data in data frame
ap_df <- tsdf(AirPassengers)

ggsdc(ap_df, aes(x = x, y = y), method = "decompose") +
   geom_line()
   
ggsdc(ap_df, aes(x = x, y = y), method = "decompose", 
      type = "multiplicative") +
   geom_line(colour = "blue", size = 2) +
   theme_light(8)

ggsdc(ap_df, aes(x = x, y = y), method = "stl", s.window = 7) +
   labs(x = "", y = "Air passenger numbers") +
   geom_point()
   
\dontrun{      
ggsdc(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex), method = "seas") +
      geom_line()
      
serv <- subset(nzbop, Account == "Current account" & 
            Category \%in\% c("Services; Exports total", "Services; Imports total"))
ggsdc(serv, aes(x = TimePeriod, y = Value, colour = Category),
      method = "seas", start = c(1971, 2), frequency = 4) +
   geom_line()
}

ggsdc(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex), s.window = 7, 
   index.ref = 1:12, index.basis = 1000) +
   geom_line() +
   ylab("Lung deaths index (average month in 1974 = 1000)")
      
bop <- subset(nzbop, Account == "Current account" & !Balance)
ggsdc(bop, aes(x = TimePeriod, y = Value, colour = Category), frequency = 4, 
   method = "decomp", type = "multiplicative") +
      geom_line() 
      
ggsdc(bop, aes(x = TimePeriod, y = Value, colour = Category), frequency = 4, s.window = 7) +
      geom_line() 
}
\seealso{
\code{\link{decompose}}, \code{\link{stl}}, \code{\link{seas}}
}
