% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direction_label.R
\name{direction_label}
\alias{direction_label}
\title{Adds an arrow indicating the direction of play to a ggplot plot}
\usage{
direction_label(x_label = 50, y_label = -3, label_length = 20,
  colour = "dimgray")
}
\arguments{
\item{x_label}{x position of the centre of the arrow on the plot}

\item{y_label}{y position of the arrow on the plot}

\item{label_length}{length of arrow (in x axis units)}

\item{colour}{colour of the arrow and text}
}
\value{
list of ggplot layers to be added to a ggplot plot
}
\description{
Adds an arrow indicating the direction of play to a ggplot plot
}
\examples{
library(ggplot2)

shots_data <- data.frame(x = c(90, 85, 82, 78, 83),
                         y = c(43, 40, 52, 56, 44))

p <- ggplot(shots_data, aes(x = x, y = y)) +
  annotate_pitch() +
  geom_point()

# Add direction of play label
p + direction_label()

}
