% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-label-peaks.R
\name{stat_label_peaks}
\alias{stat_label_peaks}
\alias{stat_label_valleys}
\title{Label peaks and valleys.}
\usage{
stat_label_peaks(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  ...,
  span = 5,
  ignore_threshold = 0,
  global.threshold = ignore_threshold,
  strict = TRUE,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  x.label.transform = function(x) {
     x
 },
  y.label.transform = function(x) {
     x
 },
  x.colour.transform = x.label.transform,
  label.fill = "",
  na.rm = TRUE,
  show.legend = FALSE,
  inherit.aes = TRUE
)

stat_label_valleys(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  ...,
  span = 5,
  ignore_threshold = 0,
  global.threshold = ignore_threshold,
  strict = TRUE,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  x.label.transform = function(x) {
     x
 },
  y.label.transform = function(x) {
     x
 },
  x.colour.transform = x.label.transform,
  label.fill = "",
  na.rm = TRUE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{span}{odd positive integer A peak is defined as an element in a
sequence which is greater than all other elements within a moving window of
width \code{span} centred at that element. The default value is 5, meaning
that a peak is taller than its four nearest neighbours. \code{span = NULL}
extends the span to the whole length of \code{x}.}

\item{ignore_threshold}{Deprecated synonym for \code{global.threshold}.}

\item{global.threshold}{numeric A value belonging to class
\code{"AsIs"} is interpreted as an absolute minimum height or depth
expressed in data units. A bare \code{numeric} value (normally between 0.0
and 1.0), is interpreted as relative to the range of the data. In both
cases it sets a \emph{global} height (depth) threshold below which peaks
(valleys) are ignored. A bare negative \code{numeric} value indicates the
\emph{global} height (depth) threshold below which peaks (valleys) are be
ignored. If \code{global.threshold = NULL}, no threshold is applied and all
peaks are returned.}

\item{strict}{logical flag: if \code{TRUE}, an element must be strictly
greater than all other values in its window to be considered a peak.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt, x.label.fmt, y.label.fmt}{character  strings giving a format
definition for construction of character strings labels with function
\code{\link{sprintf}} from \code{x} and/or \code{y} values.}

\item{x.label.transform, y.label.transform, x.colour.transform}{function Applied
to \code{x} or \code{y} values when constructing the character labels or
computing matching colours.}

\item{label.fill}{character string to use for labels not at peaks or valleys
being highlighted.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The original data with additional computed variables added.
}
\description{
\code{stat_labels_peaks} finds at which \code{x} positions the global maximum
or local maxima are located,
and adds labels and color definitions to the data without subsetting.
\code{stat_labels_valleys} finds instead minima. The variable
mapped to the \code{x} aesthetic is expected to contain wavelength values
expressed in nanometres. \strong{Axis flipping is currently not supported.}
}
\details{
These statistics assemble text labels for each peak or valley and
  compute the colour corresponding to the wavelength of the peaks and
  valleys. Defaults work as long as the variable mapped to the \code{x}
  aesthetic contains wavelengths expressed in nanometres and the plot has
  an x-scale that does not apply a transformation. The three \code{transform}
  parameters can be used to back-transform the values when scales apply
  transformations so that peak/valley labels and axis labels match. Of
  course, \code{x.label.transform} and \code{y.label.transform} make also
  possible to scale the values in the labels.

  Both statistics use \code{geom_text} by default as it is the geom most
  likely to work well in almost any situation without need of tweaking. These
  statistics work best with \code{geom_text_repel} and
  \code{geom_label_repel} from package 'ggrepel' as they are designed so that
  peak or valley labels will not overlap any observation in the whole data
  set. Default aesthetics set by these statistics allow their direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The formatting of the labels
  returned can be controlled by the user.
}
\note{
When using \code{geom_text}, to discard overlapping labels pass
  \code{check_overlap = TRUE} in the call to the statistic.

  These stats work nicely together with geoms \code{geom_text_repel} and
  \code{geom_label_repel} from package \code{\link[ggrepel]{ggrepel}} to
  solve the problem of overlapping labels by displacing them, without
  discarding any of them. The difference between \code{stat_peaks} and
  \code{stat_label_peaks}, and between \code{stat_valleys} and
  \code{stat_label_valleys}, is that while the first only returns the rows in
  data matching peaks or valleys, the second return all rows, but set the
  labels to the value passed as argument to \code{label.fill}. In the "label"
  stats the default \code{label.fill = ""} ensures that when using repulsive
  geoms the labels do not overlap any observations, labelled or not.

  By default the labels are character values suitable to be plotted as is,
  but with a suitable \code{label.fmt} labels suitable for parsing by the
  geoms (e.g. into expressions containing greek letters or super or
  subscripts) can be also easily obtained.
}
\section{Computed variables}{
 \describe{ \item{x.label}{x-value at a peak (or
  valley) formatted as character or otherwise the
  value passed to \code{label.fill} which defaults to an
  empty string (\code{""}).}
  \item{y.label}{y-value at the peak (or valley) formatted as character or
   otherwise the value passed to \code{label.fill} which defaults to an
  empty string (\code{""}).}
  \item{wl.color}{At peaks and valleys,
  color definition calculated by assuming that x-values are wavelengths
  expressed in nanometres, otherwise, \code{rgb(1, 1, 1, 0)} (transparent
  white).} }
}

\section{Default aesthetics}{
 Set by the statistic and available to geoms.
  \describe{ \item{label}{after_stat(x.label)} \item{xintercept}{after_stat(x)}
  \item{yintercept}{after_stat(y)} \item{color}{black_or_white(after_stat(wl.color))}
  \item{fill}{after_stat(wl.color)} }
}

\section{Required aesthetics}{
 Required by the statistic and need to be set
  with \code{aes()}. \describe{ \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity} }
}

\examples{

# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) +
  geom_line() +
  stat_label_peaks(hjust = "left", span = 31, angle = 90, color = "red")

ggplot(sun.spct) +
  geom_line() +
  stat_label_valleys(hjust = "right", span = 21, angle = 90, color = "blue")

# using transformed scales requires the user to pass functions as arguments
ggplot(sun.spct) +
  geom_line() +
  stat_label_peaks(hjust = "left", span = 31, angle = 90, color = "red",
                   x.label.transform = abs) +
  scale_x_reverse()

ggplot(sun.spct) +
  geom_line() +
  stat_label_peaks(hjust = "left", span = 31, angle = 90, color = "red",
                   x.label.transform = function(x) {10^x}) +
  scale_x_log10()

# geom_label
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(span = 41, shape = 21, size = 3) +
  stat_label_peaks(span = 41, geom = "label", label.fmt = "\%3.0f nm") +
  scale_fill_identity() +
  scale_color_identity() +
  expand_limits(y = c(NA, 1))

# using 'ggrepel' to avoid overlaps
# too slow for CRAN checks
\dontrun{
library(ggrepel)

ggplot(sun.spct) + geom_line() +
  stat_peaks(span = 41, shape = 21, size = 2) +
  stat_label_peaks(span = 41, geom = "label_repel", segment.colour = "red",
                   nudge_y = 0.12, label.fmt = "\%3.0f nm",
                   max.overlaps = Inf, min.segment.length = 0) +
  scale_fill_identity() +
  scale_color_identity() +
  expand_limits(y = c(NA, 1))
}

}
\seealso{
\code{\link{stat_peaks}}, \code{\link{stat_valleys}} and
  \code{\link[photobiology]{find_peaks}}, which is used in the
  implementation.

Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
