% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{w_length_label}
\alias{w_length_label}
\alias{w_number_label}
\alias{w_frequency_label}
\alias{w_energy_eV_label}
\alias{w_energy_J_label}
\title{Wave- axis labels}
\usage{
w_length_label(
  unit.exponent = -9,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["w.length"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

w_number_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["w.number"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

w_frequency_label(
  unit.exponent = 9,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["freq"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

w_energy_eV_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["energy"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

w_energy_J_label(
  unit.exponent = -18,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["energy"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)
}
\arguments{
\item{unit.exponent}{integer The exponent in base 10 of the scale multiplier
to use.}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}
}
\value{
a character string or an R expression.
}
\description{
Generate wavelength, wavenumber, wave frequency, and energy per photon axis
labels in SI units, using SI scale factors. Output can be selected as
character, expression (R default devices) or LaTeX (for tikz device).
}
\details{
By default labels consist in a textual name for the quantity, a
  symbol separated by a comma and units with scale factor in parenthesis. The
  textual names are by default in English but this default can be overridden
  for example with translations to a different language. To change or
  translate the default texts please see \code{\link{axis_labels_uk}}. The
  markup language used for the labels can be selected through a parameter
  argument, with character strings ready to be parsed into R expressions
  as default.

  Wavelengths are assumed to be expressed in nanometres in the data. The
  \code{unit.exponent} corresponds to that desired for the tick labels
  with the corresponding axis label automatically set to an SI scale
  factor if possible, and otherwise shown as a power of 10.

  These functions are used internally by \emph{x} scales; see
  \code{\link{sec_axis_w_number}} and \code{\link{scale_x_wl_continuous}}.
  The scales and secondary axis functions should be used except when
  defining new scale functions.
}
\examples{

w_length_label()
w_length_label(axis.symbols = FALSE)
w_length_label(format = "R.expression")
w_length_label(format = "LaTeX")
w_number_label()
w_number_label(format = "R.expression")
w_frequency_label()
w_frequency_label(format = "R.expression")
w_energy_J_label()
w_energy_eV_label()

}
