% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggpiestats.R
\name{grouped_ggpiestats}
\alias{grouped_ggpiestats}
\title{Grouped pie charts with statistical tests}
\usage{
grouped_ggpiestats(data, main, condition = NULL, counts = NULL,
  grouping.var, title.prefix = "Group", ratio = NULL, paired = FALSE,
  factor.levels = NULL, stat.title = NULL, sample.size.label = TRUE,
  bf.message = FALSE, sampling.plan = "indepMulti",
  fixed.margin = "rows", prior.concentration = 1, caption = NULL,
  conf.level = 0.95, nboot = 25, simulate.p.value = FALSE,
  B = 2000, legend.title = NULL, facet.wrap.name = NULL, k = 2,
  perc.k = 0, slice.label = "percentage", facet.proptest = TRUE,
  ggtheme = ggplot2::theme_bw(), ggstatsplot.layer = TRUE,
  package = "RColorBrewer", palette = "Dark2", direction = 1,
  messages = TRUE, ...)
}
\arguments{
\item{data}{The data as a data frame (matrix or tables will not be accepted).}

\item{main}{The variable to use as the \strong{rows} in the
contingency table.}

\item{condition}{The variable to use as the \strong{columns} in the contingency
table.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{grouping.var}{Grouping variable.}

\item{title.prefix}{Character specifying the prefix text for the fixed plot
title (name of each factor level) (Default: \code{"Group"}).}

\item{ratio}{A vector of numbers: the expected proportions for the proportion
test. Default is \code{NULL}, which means if there are two levels \code{ratio = c(1,1)}, etc.}

\item{paired}{Logical indicating whether data came from a within-subjects
design study (Default: \code{FALSE}). If \code{TRUE}, McNemar test subtitle will be
returned. If \code{FALSE}, Pearson's chi-square test will be returned.}

\item{factor.levels}{A character vector with labels for factor levels of
\code{main} variable.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{condition}
(Default: \code{TRUE}).}

\item{bf.message}{Logical that decides whether to display a caption with
results from bayes factor test in favor of the null hypothesis (default:
\code{FALSE}).}

\item{sampling.plan}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{caption}{The text for the plot caption.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{25}).}

\item{simulate.p.value}{a logical indicating whether to compute
    p-values by Monte Carlo simulation.}

\item{B}{an integer specifying the number of replicates used in the
    Monte Carlo test.}

\item{legend.title}{Title text for the legend.}

\item{facet.wrap.name}{The text for the facet_wrap variable label.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{perc.k}{Numeric that decides number of decimal places for percentage
labels (Default: \code{0}).}

\item{slice.label}{Character decides what information needs to be displayed
on the label in each pie slice. Possible options are \code{"percentage"}
(default), \code{"counts"}, \code{"both"}.}

\item{facet.proptest}{Decides whether proportion test for \code{main} variable is
to be carried out for each level of \code{condition} (Default: \code{TRUE}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_economist()},
\code{hrbrthemes::theme_ipsum_ps()}, \code{ggthemes::theme_fivethirtyeight()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Arguments passed on to \code{combine_plots}
\describe{
  \item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}
  \item{title.color}{Text color for title.}
  \item{title.size}{Point size of title text.}
  \item{title.vjust}{Vertical justification for title. Default = \code{0.5}
(centered on \code{y}). \code{0} = baseline at \code{y}, \code{1} = ascender at \code{y}.}
  \item{title.hjust}{Horizontal justification for title. Default = \code{0.5}
(centered on \code{x}). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{title.fontface}{The font face (\code{"plain"}, \code{"bold"} (default),
\code{"italic"}, \code{"bold.italic"}) for title.}
  \item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}
  \item{caption.color}{Text color for caption.}
  \item{caption.size}{Point size of title text.}
  \item{caption.vjust}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}
  \item{caption.hjust}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{caption.fontface}{The font face (\code{"plain"} (default), \code{"bold"},
\code{"italic"}, \code{"bold.italic"}) for caption.}
  \item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}
  \item{sub.color}{Text color for annotation label (Default: \code{"black"}).}
  \item{sub.size}{Point size of annotation text (Default: \code{12}).}
  \item{sub.x}{The x position of annotation label (Default: \code{0.5}).}
  \item{sub.y}{The y position of annotation label (Default: \code{0.5}).}
  \item{sub.hjust}{Horizontal justification for annotation label (Default:
\code{0.5}).}
  \item{sub.vjust}{Vertical justification for annotation label (Default:
\code{0.5}).}
  \item{sub.vpadding}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed (Default: \code{grid::unit(1, "lines")}).}
  \item{sub.fontface}{The font face (\code{"plain"} (default), \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}
  \item{sub.angle}{Angle at which annotation label is to be drawn (Default:
\code{0}).}
  \item{sub.lineheight}{Line height of annotation label.}
  \item{title.caption.rel.heights}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
  \item{title.rel.heights}{Numerical vector of relative columns heights while
combining (title, plot).}
  \item{caption.rel.heights}{Numerical vector of relative columns heights while
combining (plot, caption).}
}}
}
\value{
Unlike a number of statistical softwares, \code{ggstatsplot} doesn't
provide the option for Yates' correction for the Pearson's chi-squared
statistic. This is due to compelling amount of Monte-Carlo simulation
research which suggests that the Yates' correction is overly conservative,
even in small sample sizes. As such it is recommended that it should not
ever be applied in practice (Camilli & Hopkins, 1978, 1979; Feinberg, 1980;
Larntz, 1978; Thompson, 1988). For more, see-
\url{http://www.how2stats.net/2011/09/yates-correction.html}
}
\description{
Helper function for \code{ggstatsplot::ggpiestats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{

# grouped one-sample proportion tests
ggstatsplot::grouped_ggpiestats(
  data = mtcars,
  grouping.var = am,
  main = cyl
)

# without condition and with count data
library(jmv)

ggstatsplot::grouped_ggpiestats(
  data = as.data.frame(HairEyeColor),
  main = Hair,
  counts = Freq,
  grouping.var = Sex
)

# the following will take slightly more amount of time
\dontrun{
# for reproducibility
set.seed(123)

# let's create a smaller dataframe
diamonds_short <- ggplot2::diamonds \%>\%
  dplyr::filter(.data = ., cut \%in\% c("Fair", "Very Good", "Ideal")) \%>\%
  dplyr::sample_frac(tbl = ., size = 0.10)

# plot
ggstatsplot::grouped_ggpiestats(
  data = diamonds_short,
  main = color,
  condition = clarity,
  grouping.var = cut,
  bf.message = TRUE,
  sampling.plan = "poisson",
  title.prefix = "Quality",
  slice.label = "both",
  messages = FALSE,
  perc.k = 1,
  nrow = 3
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggpiestats.html}
}
\seealso{
\code{\link{ggpiestats}}
}
\author{
Indrajeet Patil, Chuck Powell
}
