% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_stream.R
\name{geom_stream_label}
\alias{geom_stream_label}
\title{geom_stream_label

geom to create labels to a geom_stream plot}
\usage{
geom_stream_label(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  na.rm = TRUE,
  bw = 0.75,
  extra_span = 0.01,
  n_grid = 100,
  method = c("new_wiggle"),
  center_fun = NULL,
  type = c("mirror", "ridge", "proportional"),
  true_range = c("both", "min_x", "max_x", "none"),
  sorting = c("none", "onset", "inside_out"),
  ...
)
}
\arguments{
\item{mapping}{provide you own mapping. both x and y need to be numeric.}

\item{data}{provide you own data}

\item{geom}{change geom}

\item{position}{change position}

\item{show.legend}{show legend in plot}

\item{inherit.aes}{should the geom inherits aesthetics}

\item{na.rm}{remove missing values}

\item{bw}{bandwidth of kernel density estimation}

\item{extra_span}{How many extra range should be used in estimation? Percent of x range added to min and max.}

\item{n_grid}{number of x points that should be calculated. The higher the more smooth plot.}

\item{method}{Only `new wiggle` is implemented so far.}

\item{center_fun}{a function that returns the y center for each possible x in range of x.}

\item{type}{one of `mirror` which stacks symmetrically around the x axis, or `ridge` which stacks from the x-axis, or `proportional`.}

\item{true_range}{should the true data range be used or the estimation range?}

\item{sorting}{Should the groups be sorted. Either the default 'none', 'onset' or 'inside_out'}

\item{...}{other arguments to be passed to the geom}
}
\value{
a 'ggplot' layer
}
\description{
geom_stream_label

geom to create labels to a geom_stream plot
}
\examples{
library(ggplot2)
set.seed(123)
 df <- data.frame(x = rep(1:10, 3),
                  y = rpois(30, 2),
                  group = sort(rep(c("A", "B", "C"), 10)))
ggplot(df, aes(x, y, fill = group, label = group)) +
  geom_stream() +
  geom_stream_label(n_grid = 100)

}
