% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-tern.R
\docType{data}
\name{geom_density_tern}
\alias{GeomDensityTern}
\alias{geom_density_tern}
\title{Density Estimate}
\usage{
geom_density_tern(mapping = NULL, data = NULL, stat = "DensityTern",
  position = "identity", lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
Perform a 2D kernel density estimatation using kde2d and display the results with contours. This can be 
useful for dealing with overplotting. Additional weight aesthetic (see aesthetic section below) permits better weighting if desired
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "density_tern")}
}
\examples{
data(Feldspar); Feldspar$weight= 0*c(1:nrow(Feldspar))^2
ggtern(Feldspar,aes(Ab,An,Or,weight=weight)) + 
geom_density_tern(aes(colour=..level..),expand=0.5,base='identity')
}
\author{
Nicholas Hamilton
}
\keyword{datasets}

