% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-ticks.R
\name{theme_showprimary}
\alias{theme_showprimary}
\alias{theme_noprimary}
\alias{theme_hideprimary}
\alias{theme_nosecondary}
\alias{theme_hidesecondary}
\alias{theme_showsecondary}
\alias{theme_showticks}
\alias{theme_hideticks}
\alias{theme_noticks}
\title{Show or Hide the Primary/Secondary Ticks}
\usage{
theme_noprimary()

theme_hideprimary()

theme_showprimary()

theme_nosecondary()

theme_hidesecondary()

theme_showsecondary()

theme_showticks()

theme_hideticks()

theme_noticks()
}
\description{
Convenience functions to enable or disable the axis primary or secondary ticks.
}
\details{
In \code{ggtern}, the primary ticks are deemed as being the ticks along the binary axis increasing to the apex species, primary ticks can consist of 
both major and minor ticks (major ticks have labels, and are generally longer and bolder). Therefore, there are three (3) sets of major primary ticks, and,
three (3) sets of minor primary ticks. 

These convenience functions introduce the concept of secondary ticks, which, are the same items however on the 
'opposing' binary axis. 

For example, considering the TOP apex species, in a plot with 'clockwise' axis precession, the primary ticks would run along the 
LHS, whilst, the secondary ticks, woudl run along the RHS. By default, the primary ticks are switched ON, whilst the secondary ticks are switched OFF and are
controlled by the \code{tern.axis.ticks.primary.show} and \code{tern.axis.ticks.secondary.show} theme elements respectively.

\code{theme_showsecondary} is a function that apends to the current theme a flag to switch ON the secondary ticks
\code{theme_showticks(), themehideticks(), theme_noticks()} are functions that switch ON or OFF BOTH the primary or secondary ticks.
\code{theme_nosecondary} or \code{theme_hidesecondary} (Alias) are functions that apends to the current theme a flag to switch OFF the secondary ticks
\code{theme_showprimary} is a function that apends to the current theme a flag to switch ON the primary ticks
\code{theme_noprimary} or \code{theme_hideprimary} (Alias) are functions that apends to the current theme a flag to switch OFF the primary ticks
}
\examples{
data(Feldspar)
plot <- ggtern(data=Feldspar,aes(Ab,An,Or)) + geom_point() + 
  theme_showsecondary()
}
\author{
Nicholas Hamilton
}
