% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtikzTransform.R
\name{ggtikzTransform}
\alias{ggtikzTransform}
\title{Transform TikZ coordinates according to scale transformations}
\usage{
ggtikzTransform(ggtikzCanvas, ggtikzAnnotation)
}
\arguments{
\item{ggtikzCanvas}{A \code{link{ggtikzCanvas}} object.}

\item{ggtikzAnnotation}{A \code{link{ggtikzAnnotaton}} object.}
}
\value{
A \code{link{ggtikzAnnotation}} object, with transformations applied
to the coordinates in the TikZ code.
}
\description{
ggtikzTransform extracts coordinates definitions in an annotation's TikZ code
and transforms them with the transformer functions stored in the underlying
plot's x or y scales, respectively.
}
\details{
This function does not have to called directly. It is automatically called
when annotations are added to a canvas, if \code{transform = TRUE} in the
\code{ggtikzAnnotation} construction call.

Coordinates components with physical lengths are not changed.
For a plot with a linear x scale and a log10-transformed y scale,
\itemize{
\item the TikZ coordinate (10,10) becomes (10,1),
\item the TikZ coordinate (10cm,10) becomes (10cm,1),
\item the TikZ coordinate (10,10cm) becomes (10,10cm)
\item the TikZ coordinate (0,0) will raise an error.
}
}
