% Generated by roxygen2 (4.0.1): do not edit by hand
\name{add_tooltip}
\alias{add_tooltip}
\title{Add tooltips to a plot.}
\usage{
add_tooltip(vis, html, on = c("hover", "click"))
}
\arguments{
\item{vis}{Visualisation to add tooltips to.}

\item{html}{A function that takes a single argument as input. This argument
will be a list containing the data in the mark currently under the
mouse. It should return a string containing HTML or \code{NULL} to
hide tooltip for the current element.}

\item{on}{Should tooltips appear on hover, or on click?}
}
\description{
Add tooltips to a plot.
}
\examples{
\donttest{
all_values <- function(x) {
  if(is.null(x)) return(NULL)
  paste0(names(x), ": ", format(x), collapse = "<br />")
}

base <- mtcars \%>\% ggvis(x = ~wt, y = ~mpg) \%>\%
  layer_points()
base \%>\% add_tooltip(all_values, "hover")
base \%>\% add_tooltip(all_values, "click")
}
}

