% Generated by roxygen2 (4.0.1): do not edit by hand
\name{compute_bin}
\alias{compute_bin}
\title{Bin data along a continuous variable}
\usage{
compute_bin(x, x_var, w_var = NULL, binwidth = NULL, origin = NULL,
  right = TRUE, pad = TRUE)
}
\arguments{
\item{x}{Dataset-like object to bin. Built-in methods for data frames,
grouped data frames and ggvis visualisations.}

\item{x_var,w_var}{Names of x and weight variables. The x variable must be
continuous.}

\item{binwidth}{The width of the bins. The default is \code{NULL}, which
yields 30 bins that cover the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.}

\item{origin}{The initial position of the left-most bin. If \code{NULL}, the
the default, will use the smallest value in the dataset.}

\item{right}{Should bins be right-open, left-closed, or
right-closed, left-open.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This
ensures frequency polygons touch 0, and adds padidng between the data
and axis for histograms.}
}
\value{
A data frame with columns:
 \item{count_}{the number of points}
 \item{x_}{mid-point of bin}
 \item{xmin_}{left boundary of bin}
 \item{xmax_}{right boundary of bin}
 \item{width_}{width of bin}
}
\description{
Bin data along a continuous variable
}
\examples{
mtcars \%>\% compute_bin(~mpg)
mtcars \%>\% compute_bin(~mpg, binwidth = 10)
mtcars \%>\% group_by(cyl) \%>\% compute_bin(~mpg, binwidth = 10)

# It doesn't matter whether you transform inside or outside of a vis
mtcars \%>\% compute_bin(~mpg) \%>\% ggvis(~x_, ~count_) \%>\% layer_paths()
mtcars \%>\% ggvis(~ x_, ~ count_) \%>\% compute_bin(~mpg) \%>\% layer_paths()
}
\seealso{
\code{\link{compute_count}} For counting cases at specific locations
  of a continuous variable. This is useful when the variable is continuous
  but the data is granular.
}

