% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/compute_model_prediction.R
\name{compute_model_prediction}
\alias{compute_model_prediction}
\alias{compute_smooth}
\title{Create a model of a data set and compute predictions.}
\usage{
compute_model_prediction(x, formula, ..., model = NULL, se = FALSE,
  level = 0.95, n = 80L, domain = NULL, method)

compute_smooth(x, formula, ..., span = 0.75, se = FALSE)
}
\arguments{
\item{x}{Dataset-like object to model and predict. Built-in methods for data
frames, grouped data frames and ggvis visualisations.}

\item{formula}{Formula passed to modelling function. Can use any variables
from data.}

\item{...}{arguments passed on to \code{model} function}

\item{model}{Model fitting function to use - it must support R's standard
modelling interface, taking a formula and data frame as input, and
returning predictions with \code{\link{predict}}. If not supplied, will use
\code{\link{loess}} for <= 1000 points, otherwise it will use
\code{\link[mgcv]{gam}}. Other modelling functions that will work include
\code{\link{lm}}, \code{\link{glm}} and \code{\link[MASS]{rlm}}.}

\item{se}{include standard errors in output? Requires appropriate method of
\code{predict_grid}, since the interface for returning predictions with
standard errors is not consistent acrossing modelling frameworks.}

\item{level}{the confidence level of the standard errors.}

\item{n}{the number of grid points to use in the prediction}

\item{domain}{If \code{NULL} (the default), the domain of the predicted
values will be the same as the domain of the prediction variable in the
data. It can also be a two-element numeric vector specifying the min and
max.}

\item{method}{Deprecated. Please use \code{model} instead.}

\item{span}{Smoothing span used for loess model.}
}
\value{
A data frame with columns: \item{\code{resp_}}{regularly spaced grid
  of \code{n} locations} \item{\code{pred_}}{predicted value from model}
  \item{\code{pred_lwr_} and \code{pred_upr_}}{upper and lower bounds of
  confidence interval (if \code{se = TRUE})} \item{\code{pred_se_}}{the
  standard error (width of the confidence interval) (if \code{se = TRUE})}
}
\description{
Fit a 1d model, then compute predictions and (optionally) standard errors
over an evenly spaced grid.
}
\details{
\code{compute_model_prediction} fits a model to the data and makes
predictions with it. \code{compute_smooth} is a special case of model
predictions where the model is a smooth loess curve whose smoothness is
controlled by the \code{span} parameter.
}
\examples{
# Use a small value of n for these examples
mtcars \%>\% compute_model_prediction(mpg ~ wt, n = 10)
mtcars \%>\% compute_model_prediction(mpg ~ wt, n = 10, se = TRUE)
mtcars \%>\% group_by(cyl) \%>\% compute_model_prediction(mpg ~ wt, n = 10)

# compute_smooth defaults to loess
mtcars \%>\% compute_smooth(mpg ~ wt)

# Override model to suppress message or change approach
mtcars \%>\% compute_model_prediction(mpg ~ wt, n = 10, model = "loess")
mtcars \%>\% compute_model_prediction(mpg ~ wt, n = 10, model = "lm")

# Set the domain manually
mtcars \%>\%
  compute_model_prediction(mpg ~ wt, n = 20, model = "lm", domain = c(0, 8))

# Plot the results
mtcars \%>\% compute_model_prediction(mpg ~ wt) \%>\%
  ggvis(~pred_, ~resp_) \%>\%
  layer_paths()
mtcars \%>\% ggvis() \%>\%
  compute_model_prediction(mpg ~ wt) \%>\%
  layer_paths(~pred_, ~resp_)
}

