% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-text-wordcloud.R
\name{geom_text_wordcloud}
\alias{geom_text_wordcloud}
\title{wordcloud text geom}
\usage{
geom_text_wordcloud(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., parse = FALSE, nudge_x = 0,
  nudge_y = 0, eccentricity = 0.65, rstep = 0.01, tstep = 0.02,
  grid_size = 4, max_grid_size = 128, grid_margin = 1, xlim = c(NA,
  NA), ylim = c(NA, NA), seed = NA, rm_outside = FALSE,
  na.rm = FALSE, show.legend = FALSE, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. If specified and
\code{inherit.aes = TRUE} (the default), is combined with the default
mapping at the top level of the plot. You only need to supply
\code{mapping} if there isn't a mapping defined for the plot. Note that if
not specified both x and y are set to 0.5, i.e. the middle of the default
panel.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
are three types of arguments you can use here: \itemize{ \item Aesthetics:
to set an aesthetic to a fixed value, like \code{colour = "red"} or
\code{size = 3}. \item Other arguments to the layer, for example you
override the default \code{stat} associated with the layer. \item Other
arguments passed on to the stat. }}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label.}

\item{eccentricity}{eccentricity of the spiral. Default to .65}

\item{rstep}{relative wordclould spiral radius increment after one full
rotation. Default to .01.}

\item{tstep}{wordclould spiral angle increment at each step. Default to .02.}

\item{grid_size}{grid size used when creating the text bounding boxes.
Default to 4}

\item{max_grid_size}{maximum size of the bounding boxes. Default to 128}

\item{grid_margin}{safety margin around the texts. Default to 1.}

\item{xlim, ylim}{Limits for the x and y axes. Text labels will be constrained
to these limits. By default, text labels are constrained to the entire plot
area.}

\item{seed}{Random seed passed to \code{set.seed}. Defaults to \code{NA},
which means that \code{set.seed} will not be called.}

\item{rm_outside}{Remove the texts that could not be fitted. Default to
\code{FALSE}}

\item{na.rm}{Remove missing values if TRUE}

\item{show.legend}{is set by default to \code{FALSE}}

\item{inherit.aes}{Inherits aesthetics if TRUE}
}
\value{
a ggplot
}
\description{
\code{geom_text_wordcloud} adds text to the plot using a variation of the
wordcloud2.js algorithm. The texts are layered around a spiral centered on
the original position. This geom is based on
\code{\link[ggrepel]{geom_text_repel}} which in turn is based on
\code{\link[ggplot2]{geom_text}}. See the documentation for those functions
for more details.
}
\examples{
set.seed(42)
dat <- mtcars
dat$name <- row.names(mtcars)
dat$size <- dat$mpg
dat$size[1] <- 300
ggplot(data = dat, aes(size = size, label = name)) + geom_text_wordcloud() +
  theme_minimal()
dat$angle <- (-90+180*runif(nrow(dat)))*(runif(nrow(dat)>.6))
ggplot(data = dat, aes(size = size, label = name, angle = angle)) +
 geom_text_wordcloud() + theme_minimal()
}
