% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-gi.R
\name{plot_targets_bar}
\alias{plot_targets_bar}
\title{Target bar plot for CRISPR scores}
\usage{
plot_targets_bar(gimap_dataset, target1, target2, reps_to_drop = "")
}
\arguments{
\item{gimap_dataset}{A special dataset structure that is originally setup using
`setup_data()` and has had gi scores calculated with `calc_gi()`.}

\item{target1}{Name of the first target to be plotted e.g.}

\item{target2}{Name of the second target to be plotted e.g.}

\item{reps_to_drop}{Names of replicates that should be not plotted (Optional)}
}
\value{
A ggplot2 bar plot of the specific target's genetic interaction scores.
}
\description{
This plot is for when you'd like to examine a target pair
specifically -- meant to be functionally equivalent to Fig 3b
CRISPR scores for representative synthetic lethal paralog pairs.
Data shown are the mean CRISPR score for each single KO or DKO target across
 three biological replicates with replicate data shown in overlaid points.
}
\examples{
\donttest{

gimap_dataset <- get_example_data("gimap") \%>\%
  gimap_filter() \%>\%
  gimap_annotate(cell_line = "HELA") \%>\%
  gimap_normalize(
    timepoints = "day"
  ) \%>\%
  calc_gi()

# To plot results, pick out two targets from the gi_score table
head(dplyr::arrange(gimap_dataset$gi_score, fdr))

# "TIAL1_TIA1" is top result so let's plot that
plot_targets_bar(gimap_dataset, target1 = "TIAL1", target2 = "TIA1")
}
}
